/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.layout;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.io.Serializable;

public class LCBLayout
implements LayoutManager,
Serializable {
    private static final long serialVersionUID = -2531780832406163833L;
    private static final int COLUMNS = 3;
    private int[] colWidth = new int[3];
    private int[] rowHeight;
    private int labelGap = 10;
    private int buttonGap = 6;
    private int vGap = 2;

    public LCBLayout(int n) {
        this.rowHeight = new int[n];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Dimension preferredLayoutSize(Container container) {
        Object object = container.getTreeLock();
        synchronized (object) {
            int n;
            Insets insets = container.getInsets();
            int n2 = container.getComponentCount();
            int n3 = n2 / 3;
            int n4 = 0;
            while (n4 < 3) {
                n = 0;
                while (n < n3) {
                    Component component = container.getComponent(n * 3 + n4);
                    Dimension dimension = component.getPreferredSize();
                    if (this.colWidth[n4] < dimension.width) {
                        this.colWidth[n4] = dimension.width;
                    }
                    if (this.rowHeight[n] < dimension.height) {
                        this.rowHeight[n] = dimension.height;
                    }
                    ++n;
                }
                ++n4;
            }
            n4 = this.vGap * (n3 - 1);
            n = 0;
            while (n < n3) {
                n4 += this.rowHeight[n];
                ++n;
            }
            n = this.colWidth[0] + this.labelGap + this.colWidth[1] + this.buttonGap + this.colWidth[2];
            return new Dimension(insets.left + insets.right + n + this.labelGap + this.buttonGap, insets.top + insets.bottom + n4 + this.vGap);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Dimension minimumLayoutSize(Container container) {
        Object object = container.getTreeLock();
        synchronized (object) {
            int n;
            Insets insets = container.getInsets();
            int n2 = container.getComponentCount();
            int n3 = n2 / 3;
            int n4 = 0;
            while (n4 < 3) {
                n = 0;
                while (n < n3) {
                    Component component = container.getComponent(n * 3 + n4);
                    Dimension dimension = component.getMinimumSize();
                    if (this.colWidth[n4] < dimension.width) {
                        this.colWidth[n4] = dimension.width;
                    }
                    if (this.rowHeight[n] < dimension.height) {
                        this.rowHeight[n] = dimension.height;
                    }
                    ++n;
                }
                ++n4;
            }
            n4 = this.vGap * (n3 - 1);
            n = 0;
            while (n < n3) {
                n4 += this.rowHeight[n];
                ++n;
            }
            n = this.colWidth[0] + this.labelGap + this.colWidth[1] + this.buttonGap + this.colWidth[2];
            return new Dimension(insets.left + insets.right + n + this.labelGap + this.buttonGap, insets.top + insets.bottom + n4 + this.vGap);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void layoutContainer(Container container) {
        Object object = container.getTreeLock();
        synchronized (object) {
            int n;
            Insets insets = container.getInsets();
            int n2 = container.getComponentCount();
            int n3 = n2 / 3;
            int n4 = 0;
            while (n4 < 3) {
                n = 0;
                while (n < n3) {
                    Component component = container.getComponent(n * 3 + n4);
                    Dimension dimension = component.getPreferredSize();
                    if (this.colWidth[n4] < dimension.width) {
                        this.colWidth[n4] = dimension.width;
                    }
                    if (this.rowHeight[n] < dimension.height) {
                        this.rowHeight[n] = dimension.height;
                    }
                    ++n;
                }
                ++n4;
            }
            n4 = this.vGap * (n3 - 1);
            n = 0;
            while (n < n3) {
                n4 += this.rowHeight[n];
                ++n;
            }
            n = this.colWidth[0] + this.colWidth[1] + this.colWidth[2];
            int n5 = container.getWidth() - insets.left - insets.right - this.labelGap - this.buttonGap;
            this.colWidth[1] = this.colWidth[1] + (n5 - n);
            int n6 = insets.left;
            int n7 = 0;
            while (n7 < 3) {
                int n8 = insets.top;
                int n9 = 0;
                while (n9 < n3) {
                    int n10 = n9 * 3 + n7;
                    if (n10 < n2) {
                        Component component = container.getComponent(n10);
                        Dimension dimension = component.getPreferredSize();
                        int n11 = dimension.height;
                        int n12 = (this.rowHeight[n9] - n11) / 2;
                        container.getComponent(n10).setBounds(n6, n8 + n12, this.colWidth[n7], n11);
                    }
                    n8 = n8 + this.rowHeight[n9] + this.vGap;
                    ++n9;
                }
                n6 += this.colWidth[n7];
                if (n7 == 0) {
                    n6 += this.labelGap;
                }
                if (n7 == 1) {
                    n6 += this.buttonGap;
                }
                ++n7;
            }
        }
    }

    public void addLayoutComponent(Component component) {
    }

    public void removeLayoutComponent(Component component) {
    }

    public void addLayoutComponent(String string, Component component) {
    }

    public void removeLayoutComponent(String string, Component component) {
    }
}

