/*
 * Decompiled with CFR 0.152.
 */
package serpro.ppgd.formatosexternos.barcode.util;

import java.text.SimpleDateFormat;
import java.util.Date;
import serpro.ppgd.formatosexternos.barcode.util.CalculosGenericos;
import serpro.ppgd.formatosexternos.barcode.util.JulianDate;
import serpro.ppgd.negocio.CNPJ;
import serpro.ppgd.negocio.CPF;
import serpro.ppgd.negocio.Data;
import serpro.ppgd.negocio.Informacao;
import serpro.ppgd.negocio.NI;
import serpro.ppgd.negocio.util.LogPPGD;

public class DarfAdaptor {
    private String nome = "";
    private String telefone = "";
    private Data periodoApuracao = new Data(null, "");
    private String periodoApuracaoJuliana = "";
    private Informacao cpfCnpj = new NI(null, "");
    private String codigoReceita = "";
    private String numeroReferencia = "";
    private Data dataVencimento = new Data(null, "");
    private String dataVencimentoJuliana = "";
    private String valorPrincipal = "";
    private String valorMulta = "";
    private String valorJuros = "";
    private String valorTotal = "";
    private String nomePrograma = "";
    private String observacoes = "";
    private Data dataValidade = new Data(null, "");
    private String mensagem = "";
    private String municipio = "";
    private String indicadorManualCalculado = "";
    private String codigoEmpresa = "";
    private String tipoDocumento = "0";

    public String montaData() {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("dd/MM/yyyy '\u00e0s' HH:mm");
        return simpleDateFormat.format(new Date());
    }

    public String getCodigoReceita() {
        return this.codigoReceita;
    }

    public Informacao getCpfCnpj() {
        return this.cpfCnpj;
    }

    public String getCpfCnpjCalculado() {
        if (this.getCpfCnpj().asString().length() == 11) {
            StringBuffer stringBuffer = new StringBuffer(this.cpfCnpj.asString());
            stringBuffer.append('0');
            return stringBuffer.toString();
        }
        return this.cpfCnpj.asString().substring(0, 12);
    }

    public Data getDataValidade() {
        return this.dataValidade;
    }

    public Data getDataVencimento() {
        return this.dataVencimento;
    }

    public String getIndicadorManualCalculado() {
        return this.indicadorManualCalculado;
    }

    public String getMensagem() {
        return this.mensagem;
    }

    public String getMunicipio() {
        return this.municipio;
    }

    public String getNome() {
        return this.nome;
    }

    public String getNomePrograma() {
        return this.nomePrograma;
    }

    public String getNumeroReferencia() {
        return this.numeroReferencia;
    }

    public String getObservacoes() {
        return this.observacoes;
    }

    public Data getPeriodoApuracao() {
        return this.periodoApuracao;
    }

    public String getTelefone() {
        return this.telefone;
    }

    public String getValorJuros() {
        return this.valorJuros;
    }

    public String getValorMulta() {
        return this.valorMulta;
    }

    public String getValorPrincipal() {
        return this.valorPrincipal;
    }

    public String getValorTotal() {
        return this.valorTotal;
    }

    public void setCodigoReceita(String string) throws Exception {
        if (CalculosGenericos.testaCampo(string) != 4) {
            throw new Exception("Atributo \"codigoReceita\" inv\u00e1lido. Tamanho inconsistente.");
        }
        this.codigoReceita = string;
    }

    public void setCpfCnpj(CPF cPF) throws Exception {
        if (CalculosGenericos.testaCampo(cPF.asString()) != 11) {
            throw new Exception("Atributo \"cpfCnpj\" inv\u00e1lido. Tamanho inconsistente.");
        }
        this.setTipoDocumento("0");
        this.cpfCnpj = cPF;
    }

    public void setCpfCnpj(CNPJ cNPJ) throws Exception {
        if (CalculosGenericos.testaCampo(cNPJ.asString()) != 14) {
            throw new Exception("Atributo \"cpfCnpj\" inv\u00e1lido. Tamanho inconsistente.");
        }
        this.setTipoDocumento("1");
        this.cpfCnpj = cNPJ;
    }

    public void setCpfCnpj(NI nI) throws Exception {
        if (CalculosGenericos.testaCampo(nI.asString()) != 14 && CalculosGenericos.testaCampo(nI.asString()) != 11) {
            throw new Exception("Atributo \"cpfCnpj\" inv\u00e1lido. Tamanho inconsistente.");
        }
        this.setTipoDocumento("1");
        this.cpfCnpj = nI;
    }

    public void setDataValidade(Data data) throws Exception {
        if (CalculosGenericos.testaCampo(data.asString()) != 8) {
            throw new Exception("Atributo \"dataValidade\" inv\u00e1lido. Tamanho inconsistente.");
        }
        this.dataValidade = data;
    }

    public void setDataVencimento(Data data) throws Exception {
        if (CalculosGenericos.testaCampo(data.asString()) != 8) {
            throw new Exception("Atributo \"dataVencimento\" inv\u00e1lido. Tamanho inconsistente.");
        }
        this.dataVencimento = data;
        this.setDataVencimentoJuliana();
    }

    public void setIndicadorManualCalculado(String string) throws Exception {
        if (CalculosGenericos.testaCampo(string) != 1) {
            throw new Exception("Atributo \"indicadorManualCalculado\" inv\u00e1lido. Tamanho inconsistente.");
        }
        this.indicadorManualCalculado = string;
    }

    public void setMensagem(String string) {
        this.mensagem = string;
    }

    public void setMunicipio(String string) {
        this.municipio = string;
    }

    public void setNome(String string) {
        this.nome = string;
    }

    public void setNomePrograma(String string) {
        this.nomePrograma = string;
    }

    public void setNumeroReferencia(String string) {
        this.numeroReferencia = string;
    }

    public void setObservacoes(String string) {
        this.observacoes = string;
    }

    public void setPeriodoApuracao(Data data) throws Exception {
        if (CalculosGenericos.testaCampo(data.asString()) != 8) {
            throw new Exception("Atributo \"periodoApuracao\" inv\u00e1lido. Tamanho inconsistente.");
        }
        this.periodoApuracao = data;
        this.setPeriodoApuracaoJuliana();
    }

    public void setTelefone(String string) {
        this.telefone = string;
    }

    public void setValorJuros(String string) throws Exception {
        if (string.trim().length() == 0) {
            throw new Exception("Atributo \"valorJuros\" inv\u00e1lido. Valor n\u00e3o foi atribu\u00eddo.");
        }
        this.valorJuros = string;
    }

    public void setValorMulta(String string) throws Exception {
        if (string.trim().length() == 0) {
            throw new Exception("Atributo \"valorMulta\" inv\u00e1lido. Valor n\u00e3o foi atribu\u00eddo.");
        }
        this.valorMulta = string;
    }

    public void setValorPrincipal(String string) throws Exception {
        if (string.trim().length() == 0) {
            throw new Exception("Atributo \"valorPrincipal\" inv\u00e1lido. Valor n\u00e3o foi atribu\u00eddo.");
        }
        this.valorPrincipal = string;
    }

    public void setValorTotal(String string) throws Exception {
        if (string.trim().length() == 0) {
            throw new Exception("Atributo \"valorTotal\" inv\u00e1lido. Valor n\u00e3o foi atribu\u00eddo.");
        }
        this.valorTotal = string;
    }

    public String getCodigoEmpresa() {
        return this.codigoEmpresa;
    }

    public void setCodigoEmpresa(String string) {
        this.codigoEmpresa = string;
    }

    public String getDataVencimentoJuliana() {
        return this.dataVencimentoJuliana;
    }

    private void setDataVencimentoJuliana() {
        try {
            JulianDate julianDate = new JulianDate(this.dataVencimento.asString());
            this.dataVencimentoJuliana = julianDate.getJulianDate4Digits();
        }
        catch (Exception exception) {
            LogPPGD.erro(exception.getMessage());
        }
    }

    public String getPeriodoApuracaoJuliana() {
        return this.periodoApuracaoJuliana;
    }

    private void setPeriodoApuracaoJuliana() {
        try {
            JulianDate julianDate = new JulianDate(this.periodoApuracao.asString());
            this.periodoApuracaoJuliana = julianDate.getJulianDate4Digits();
        }
        catch (Exception exception) {
            LogPPGD.erro(exception.getMessage());
        }
    }

    public String getTipoDocumento() {
        return this.tipoDocumento;
    }

    private void setTipoDocumento(String string) {
        this.tipoDocumento = string;
    }
}

