/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine;

import java.awt.Image;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.CharArrayReader;
import java.io.CharArrayWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRField;
import net.sf.jasperreports.engine.util.JRImageLoader;

public class JRResultSetDataSource
implements JRDataSource {
    private static final String INDEXED_COLUMN_PREFIX = "COLUMN_";
    private static final int INDEXED_COLUMN_PREFIX_LENGTH = "COLUMN_".length();
    private ResultSet resultSet = null;
    private Map columnIndexMap = new HashMap();

    public JRResultSetDataSource(ResultSet resultSet) {
        this.resultSet = resultSet;
    }

    public boolean next() throws JRException {
        boolean bl = false;
        if (this.resultSet != null) {
            try {
                bl = this.resultSet.next();
            }
            catch (SQLException sQLException) {
                throw new JRException("Unable to get next record.", sQLException);
            }
        }
        return bl;
    }

    public Object getFieldValue(JRField jRField) throws JRException {
        Object object;
        block42: {
            object = null;
            if (jRField != null && this.resultSet != null) {
                Integer n = this.getColumnIndex(jRField.getName());
                Class clazz = jRField.getValueClass();
                try {
                    if (clazz.equals(Boolean.class)) {
                        object = this.resultSet.getBoolean(n) ? Boolean.TRUE : Boolean.FALSE;
                        break block42;
                    }
                    if (clazz.equals(Byte.class)) {
                        object = new Byte(this.resultSet.getByte(n));
                        if (this.resultSet.wasNull()) {
                            object = null;
                        }
                        break block42;
                    }
                    if (clazz.equals(Date.class)) {
                        object = this.resultSet.getDate(n);
                        if (this.resultSet.wasNull()) {
                            object = null;
                        }
                        break block42;
                    }
                    if (clazz.equals(Timestamp.class)) {
                        object = this.resultSet.getTimestamp(n);
                        if (this.resultSet.wasNull()) {
                            object = null;
                        }
                        break block42;
                    }
                    if (clazz.equals(Time.class)) {
                        object = this.resultSet.getTime(n);
                        if (this.resultSet.wasNull()) {
                            object = null;
                        }
                        break block42;
                    }
                    if (clazz.equals(Double.class)) {
                        object = new Double(this.resultSet.getDouble(n));
                        if (this.resultSet.wasNull()) {
                            object = null;
                        }
                        break block42;
                    }
                    if (clazz.equals(Float.class)) {
                        object = new Float(this.resultSet.getFloat(n));
                        if (this.resultSet.wasNull()) {
                            object = null;
                        }
                        break block42;
                    }
                    if (clazz.equals(Integer.class)) {
                        object = new Integer(this.resultSet.getInt(n));
                        if (this.resultSet.wasNull()) {
                            object = null;
                        }
                        break block42;
                    }
                    if (clazz.equals(InputStream.class)) {
                        byte[] byArray = this.readBytes(n);
                        object = byArray == null ? null : new ByteArrayInputStream(byArray);
                        break block42;
                    }
                    if (clazz.equals(Long.class)) {
                        object = new Long(this.resultSet.getLong(n));
                        if (this.resultSet.wasNull()) {
                            object = null;
                        }
                        break block42;
                    }
                    if (clazz.equals(Short.class)) {
                        object = new Short(this.resultSet.getShort(n));
                        if (this.resultSet.wasNull()) {
                            object = null;
                        }
                        break block42;
                    }
                    if (clazz.equals(BigDecimal.class)) {
                        object = this.resultSet.getBigDecimal(n);
                        if (this.resultSet.wasNull()) {
                            object = null;
                        }
                        break block42;
                    }
                    if (clazz.equals(String.class)) {
                        int n2 = this.resultSet.getMetaData().getColumnType(n);
                        switch (n2) {
                            case 2005: {
                                Clob clob = this.resultSet.getClob(n);
                                if (this.resultSet.wasNull()) {
                                    object = null;
                                    break;
                                }
                                object = this.clobToString(clob);
                                break;
                            }
                            default: {
                                object = this.resultSet.getString(n);
                                if (this.resultSet.wasNull()) {
                                    object = null;
                                    break;
                                } else {
                                    break;
                                }
                            }
                        }
                        break block42;
                    }
                    if (clazz.equals(Clob.class)) {
                        object = this.resultSet.getClob(n);
                        if (this.resultSet.wasNull()) {
                            object = null;
                        }
                    } else if (clazz.equals(Reader.class)) {
                        Reader reader = null;
                        long l = -1L;
                        int n3 = this.resultSet.getMetaData().getColumnType(n);
                        switch (n3) {
                            case 2005: {
                                Clob clob = this.resultSet.getClob(n);
                                if (this.resultSet.wasNull()) break;
                                reader = clob.getCharacterStream();
                                l = clob.length();
                                break;
                            }
                            default: {
                                reader = this.resultSet.getCharacterStream(n);
                                if (!this.resultSet.wasNull()) break;
                                reader = null;
                            }
                        }
                        object = reader == null ? null : this.getArrayReader(reader, l);
                    } else if (clazz.equals(Blob.class)) {
                        object = this.resultSet.getBlob(n);
                        if (this.resultSet.wasNull()) {
                            object = null;
                        }
                    } else {
                        byte[] byArray;
                        object = clazz.equals(Image.class) ? ((byArray = this.readBytes(n)) == null ? null : JRImageLoader.loadImage(byArray)) : this.resultSet.getObject(n);
                    }
                }
                catch (Exception exception) {
                    throw new JRException("Unable to get value for field '" + jRField.getName() + "' of class '" + clazz.getName() + "'", exception);
                }
            }
        }
        return object;
    }

    private Integer getColumnIndex(String string) throws JRException {
        Integer n = (Integer)this.columnIndexMap.get(string);
        if (n == null) {
            try {
                n = this.searchColumnByName(string);
                if (n == null) {
                    n = this.searchColumnByLabel(string);
                }
                if (n == null && string.startsWith(INDEXED_COLUMN_PREFIX) && ((n = new Integer(string.substring(INDEXED_COLUMN_PREFIX_LENGTH))) <= 0 || n > this.resultSet.getMetaData().getColumnCount())) {
                    throw new JRException("Column index out of range : " + n);
                }
                if (n == null) {
                    throw new JRException("Unknown column name : " + string);
                }
            }
            catch (SQLException sQLException) {
                throw new JRException("Unable to retrieve result set metadata.", sQLException);
            }
            this.columnIndexMap.put(string, n);
        }
        return n;
    }

    protected Integer searchColumnByName(String string) throws SQLException {
        Integer n = null;
        ResultSetMetaData resultSetMetaData = this.resultSet.getMetaData();
        int n2 = 1;
        while (n2 <= resultSetMetaData.getColumnCount()) {
            String string2 = resultSetMetaData.getColumnName(n2);
            if (string.equalsIgnoreCase(string2)) {
                n = new Integer(n2);
                break;
            }
            ++n2;
        }
        return n;
    }

    protected Integer searchColumnByLabel(String string) throws SQLException {
        Integer n = null;
        ResultSetMetaData resultSetMetaData = this.resultSet.getMetaData();
        int n2 = 1;
        while (n2 <= resultSetMetaData.getColumnCount()) {
            String string2 = resultSetMetaData.getColumnLabel(n2);
            if (string2 != null && string.equalsIgnoreCase(string2)) {
                n = new Integer(n2);
                break;
            }
            ++n2;
        }
        return n;
    }

    protected String clobToString(Clob clob) throws JRException {
        try {
            int n = 8192;
            char[] cArray = new char[n];
            BufferedReader bufferedReader = new BufferedReader(clob.getCharacterStream(), n);
            StringBuffer stringBuffer = new StringBuffer((int)clob.length());
            int n2 = bufferedReader.read(cArray);
            while (n2 > 0) {
                stringBuffer.append(cArray, 0, n2);
                n2 = bufferedReader.read(cArray);
            }
            return stringBuffer.toString();
        }
        catch (SQLException sQLException) {
            throw new JRException("Unable to read clob value", sQLException);
        }
        catch (IOException iOException) {
            throw new JRException("Unable to read clob value", iOException);
        }
    }

    protected CharArrayReader getArrayReader(Reader reader, long l) throws IOException {
        char[] cArray = new char[8192];
        CharArrayWriter charArrayWriter = new CharArrayWriter(l > 0L ? (int)l : 8192);
        BufferedReader bufferedReader = new BufferedReader(reader, 8192);
        int n = bufferedReader.read(cArray);
        while (n > 0) {
            charArrayWriter.write(cArray, 0, n);
            n = bufferedReader.read(cArray);
        }
        charArrayWriter.flush();
        return new CharArrayReader(charArrayWriter.toCharArray());
    }

    protected byte[] readBytes(Integer n) throws SQLException, IOException {
        Object object;
        InputStream inputStream = null;
        long l = -1L;
        int n2 = this.resultSet.getMetaData().getColumnType(n);
        switch (n2) {
            case 2004: {
                object = this.resultSet.getBlob(n);
                if (this.resultSet.wasNull()) break;
                inputStream = object.getBinaryStream();
                l = object.length();
                break;
            }
            default: {
                inputStream = this.resultSet.getBinaryStream(n);
                if (!this.resultSet.wasNull()) break;
                inputStream = null;
            }
        }
        object = null;
        if (inputStream != null) {
            object = this.readBytes(inputStream, l);
        }
        return object;
    }

    protected byte[] readBytes(InputStream inputStream, long l) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(l > 0L ? (int)l : 1000);
        byte[] byArray = new byte[1000];
        int n = 0;
        try {
            while ((n = inputStream.read(byArray)) > 0) {
                byteArrayOutputStream.write(byArray, 0, n);
            }
            byteArrayOutputStream.flush();
        }
        catch (Throwable throwable) {
            try {
                byteArrayOutputStream.close();
            }
            catch (IOException iOException) {}
            throw throwable;
        }
        try {
            byteArrayOutputStream.close();
        }
        catch (IOException iOException) {}
        return byteArrayOutputStream.toByteArray();
    }
}

