# Makefile machinery to extract selected portions from the movie,
# along with the stuff in the main Makefile.

# Copyright 2007 Alexandre Oliva <lxoliva@fsfla.org>

# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 3 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful, but
# WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
# General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, a copy can be downloaded from
# http://www.gnu.org/copyleft/gpl.html, or by writing to the Free
# Software Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
# 02111-1307, USA.


ALANG = en
EXTRACT_OPTS = -alang $(ALANG) -oac lavc -ovc lavc -lavcopts vcodec=ffv1 -of lavf -lavfopts i_certify_that_my_video_stream_does_not_use_b_frames $(VFX) dvd://

VFX = -vf crop=720:360:0:60,harddup

M1 = -dvd-device extract/Matrix
M2 = -dvd-device extract/Reloaded
M3 = -dvd-device extract/Revolutions

M1EXTRACT = $(MENCODER) $(EXTRACT_OPTS) $(M1)
M2EXTRACT = $(MENCODER) $(EXTRACT_OPTS) $(M2)
M3EXTRACT = $(MENCODER) $(EXTRACT_OPTS) $(M3)

# Use these to extract subtitle timings from DVD
# EXTRACT_OPTS = -alang $(ALANG) -oac copy -ovc copy dvd://
# M1EXTRACT += -sid $(M1-SUB-$(SUBLANG)) -vobsubout $(@:%.avi=%)
# M2EXTRACT += -sid $(M2-SUB-$(SUBLANG)) -vobsubout $(@:%.avi=%)
# M3EXTRACT += -sid $(M3-SUB-$(SUBLANG)) -vobsubout $(@:%.avi=%)

# M1-SUB-es = 2
# M1-SUB-en = 4
# M1-SUB-pt = 0

# M2-SUB-es = 2
# M2-SUB-en = 4
# M2-SUB-pt = 0

# M3-SUB-en = 2
# M3-SUB-es = 1
# M3-SUB-pt = 0

# ENCODE_OPTS = -ovc lavc -oac lavc -of lavf -lavfopts i_certify_that_my_video_stream_does_not_use_b_frames
# MENCODE = $(MENCODER) $(ENCODE_OPTS) -o $@

MAIN-name = fsmatrix

MAIN += $(intro) # 1 -chapter 1 -ss 30 -endpos 11
MAIN += $(sleeping) # 1 -chapter 3 -ss 396 -endpos 77
MAIN += $(dependent-on-machines) # 2 -chapter 10 -ss 2112 -endpos 103
MAIN += $(rabbit-hole) # 1 -chapter 8 -ss 1580 -endpos 202
MAIN += $(liquid-mirror) # 1 -chapter 9 -ss 1895 -endpos 1
MAIN += $(mirror-on-hand) # 1 -chapter 9 -ss 1904 -endpos 1
# up to 2.5
MAIN += $(mirror-on-neck) # 1 -chapter 9 -ss 1932 -endpos 1
# -1 up to 4
MAIN += $(mirror-on-face) # 1 -chapter 9 -ss 1939 -endpos 2
MAIN += $(in-nest) # 1 -chapter 10 -ss 1948 -endpos 1
MAIN += $(leaving-nest) # 1 -chapter 10 -ss 1955 -endpos 1.5
MAIN += $(see-nests) # 1 -chapter 10 -ss 1988 -endpos 1
MAIN += $(more-nests) # 1 -chapter 10 -ss 2012 -endpos 1
MAIN += $(machine-on-neck) # 1 -chapter 10 -ss 2030 -endpos 1.5
MAIN += $(flush) # 1 -chapter 10 -ss 2058 -endpos 1
MAIN += $(going-down) # 1 -chapter 10 -ss 2062 -endpos 1
MAIN += $(coming-out) # 1 -chapter 10 -ss 2066 -endpos 1
MAIN += $(into-the-water) # 1 -chapter 10 -ss 2068.5 -endpos 1
MAIN += $(drowning) # 1 -chapter 10 -ss 2073 -endpos 1
# from -1 up to 4
MAIN += $(acupuncture) # 1 -chapter 10 -ss 2145 -endpos 2
MAIN += $(cant-go-back) # 1 -chapter 13 -ss 2673 -endpos 83
MAIN += $(neo-set-me-free) # 2 -chapter 3 -ss 548 -endpos 3.3
MAIN += $(freedoms-intro) # 1 -chapter 1 -ss 114 -endpos 10
MAIN += $(freedom0-rodar) # 1 -chapter 1 -ss 183 -endpos 4
MAIN += $(freedom0-executar) # 1 -chapter 31 -ss 6406 -endpos 6
# could be up to 46
MAIN += $(freedom0-run-neo) # 1 -chapter 35 -ss 7179 -endpos 20.5
MAIN += $(freedom0-run-trinity) # 1 -chapter 2 -ss 226 -endpos 94
MAIN += $(freedom1-learn-kung-fu) # 1 -chapter 14 -ss 2875 -endpos 49
MAIN += $(freedom1-learn-chopper) # 1 -chapter 31 -ss 6432 -endpos 26
MAIN += $(freedom1-psychic) # 1 -chapter 21 -ss 4268 -endpos 24
MAIN += $(freedom1-stopping-bullets) # 1 -chapter 36 -ss 7498 -endpos 39
MAIN += $(freedom1-matrix-source-code) # 1 -chapter 19 -ss 3686 -endpos 26
MAIN += $(freedom1-metro-loop) # 3 -chapter 4 -ss 868 -endpos 14
MAIN += $(freedom1-bugged) # 1 -chapter 8 -ss 1450 -endpos 3
MAIN += $(freedom1-removing-bug) # 1 -chapter 8 -ss 1475 -endpos 27
MAIN += $(freedom1-removing-bullet) # 2 -chapter 32 -ss 7201 -endpos 10.8
MAIN += $(freedom2-copy-disk) # 1 -chapter 3 -ss 505 -endpos 15
MAIN += $(freedom2-got-the-money) # 1 -chapter 3 -ss 494.2 -endpos 5
MAIN += $(freedom2-smith-bits-copied) # 2 -chapter 14 -ss 3075 -endpos 10
MAIN += $(freedom2-smith-free-man) # 2 -chapter 14 -ss 3111 -endpos 54.7
MAIN += $(freedom2-smith-neo-park) # 2 -chapter 14 -ss 3188 -endpos 34
MAIN += $(freedom2-agent-park) # 2 -chapter 15 -ss 3310 -endpos 4
MAIN += $(freedom2-smith-agent-park) # 2 -chapter 15 -ss 3316 -endpos 19.5
MAIN += $(freedom2-smith-with-sati) # 3 -chapter 8 -ss 1988 -endpos 12
MAIN += $(freedom2-smith-with-oracle) # 3 -chapter 8 -ss 2082 -endpos 25
MAIN += $(freedom2-smith-neo-rain) # 3 -chapter 30 -ss 6765 -endpos 25
MAIN += $(freedom3-give-spoon) # 1 -chapter 21 -ss 4290 -endpos 28
MAIN += $(freedom3-bend-spoon) # 1 -chapter 21 -ss 4335 -endpos 6
MAIN += $(freedom3-dejavu) # 1 -chapter 23 -ss 4715 -endpos 11.5
MAIN += $(freedom3-new-wall) # 1 -chapter 23 -ss 4770 -endpos 8.4
MAIN += $(freedom3-dejavu-explained) # 1 -chapter 23 -ss 4750.4 -endpos 3.6
MAIN += $(freedom3-dessert) # 2 -chapter 17 -ss 3969 -endpos 114
MAIN += $(bending-rules) # 1 -chapter 15 -ss 2935 -endpos 35
MAIN += $(jump-and-kick) # 1 -chapter 15 -ss 3086 -endpos 12
MAIN += $(he-is-fast) # 1 -chapter 15 -ss 3188 -endpos 6
MAIN += $(adaptation) # 1 -chapter 15 -ss 3011.5 -endpos 8.5
MAIN += $(beaten) # 1 -chapter 34 -ss 7032 -endpos 8
MAIN += $(watching-you) # 1 -chapter 4 -ss 637 -endpos 17
MAIN += $(machine-master) # 3 -chapter 26 -ss 5945 -endpos 10
MAIN += $(machine-control) # 3 -chapter 26 -ss 6060 -endpos 26
MAIN += $(mind-has-the-key) # 1 -chapter 28 -ss 6028.5 -endpos 24
MAIN += $(ready-to-see) # 1 -chapter 5 -ss 805 -endpos 28
MAIN += $(making-a-choice) # 1 -chapter 5 -ss 735 -endpos 27
MAIN += $(stay-as-low-as-you-can) # 1 -chapter 5 -ss 854 -endpos 71
MAIN += $(scaffold) # 1 -chapter 5 -ss 936 -endpos 5
MAIN += $(cant-do-this) # 1 -chapter 5 -ss 1000 -endpos 16
MAIN += $(giving-the-finger) # 1 -chapter 6 -ss 1067 -endpos 223
MAIN += $(why-not-the-blue-pill) # 1 -chapter 19 -ss 3720 -endpos 18
MAIN += $(champions-breakfast) # 1 -chapter 19 -ss 3920 -endpos 9
MAIN += $(you-call-this-free) # 1 -chapter 25 -ss 5309.5 -endpos 5
MAIN += $(delicious-steak) # 1 -chapter 19 -ss 3824 -endpos 17
MAIN += $(want-to-be-rich) # 1 -chapter 19 -ss 3860 -endpos 27
MAIN += $(what-is-the-matrix) # 1 -chapter 12 -ss 2595 -endpos 39
MAIN += $(down-that-road) # 1 -chapter 8 -ss 1410 -endpos 25
MAIN += $(trying-to-free-your-mind) # 1 -chapter 16 -ss 3197 -endpos 13
MAIN += $(jump-program) # 1 -chapter 16 -ss 3223 -endpos 16
MAIN += $(free-my-mind) # 1 -chapter 16 -ss 3250 -endpos 51
MAIN += $(the-system-is-our-enemy) # 1 -chapter 17 -ss 3389 -endpos 42
MAIN += $(got-the-gift) # 1 -chapter 22 -ss 4511 -endpos 7
MAIN += $(have-to-make-a-choice) # 1 -chapter 22 -ss 4578 -endpos 3
MAIN += $(control-own-life) # 1 -chapter 22 -ss 4621 -endpos 6
MAIN += $(why-keep-fighting) # 3 -chapter 29 -ss 6520 -endpos 31.2
MAIN += $(hell-yes) # 1 -chapter 14 -ss 2915 -endpos 2
MAIN += $(wrap-up) # 1 -chapter 37 -ss 7665 -endpos 93.5

TEASE-name = trailer1

TEASE += $(intro)
TEASE += $(wake-up) # 1 -chapter 3 -ss 433.5 -endpos 1
TEASE += $(matrix-has-you) # 1 -chapter 3 -ss 446.5 -endpos 3.5
# TEASE += $(change-whatever) # 1 -chapter 13 -ss 2716 -endpos 3.2
TEASE += $(nobody-cares) # 2 -chapter 10 -ss 2137.5 -endpos 4
# TEASE += $(how-could-they) # 2 -chapter 10 -ss 2172 -endpos 14
TEASE += $(we-control-these-machines) # 2 -chapter 10 -ss 2180 -endpos 3.2
# TEASE += $(smash-them-to-bits) # 2 -chapter 10 -ss 2203.5 -endpos 11
TEASE += $(control-of-my-life) # 1 -chapter 8 -ss 1612 -endpos 3
TEASE += $(you-are-a-slave) # 1 -chapter 8 -ss 1699 -endpos 13.4
# TEASE += $(set-me-free) # 2 -chapter 3 -ss 548 -endpos 4
# TEASE += $(smith-free-man) # 2 -chapter 14 -ss 3140 -endpos 5
# TEASE += $(change-whatever) # 1 -chapter 13 -ss 2711 -endpos 27
TEASE += $(change-whatever) # 1 -chapter 13 -ss 2711 -endpos 8.2
TEASE += $(dejavu-explained) # 1 -chapter 23 -ss 4750.4 -endpos 3.6
TEASE += $(youre-bugged) # 1 -chapter 8 -ss 1450 -endpos 3
TEASE += $(dont-even-see-the-code) # 1 -chapter 19 -ss 3705 -endpos 3
TEASE += $(oh-no) # 1 -chapter 23 -ss 4775 -endpos 1
TEASE += $(begins-with-choice) # 2 -chapter 17 -ss 3969 -endpos 4
TEASE += $(rules-can-be-bent) # 1 -chapter 15 -ss 2959.5 -endpos 7.5
TEASE += $(like-poetry) # 2 -chapter 17 -ss 4015 -endpos 7
TEASE += $(not-your-technique) # 1 -chapter 15 -ss 3011.5 -endpos 8.5
TEASE += $(why-youre-here) # 2 -chapter 17 -ss 3912.5 -endpos 3.3
TEASE += $(because-not-free) # 2 -chapter 14 -ss 3160 -endpos 5.7
TEASE += $(must-get-free) # 1 -chapter 28 -ss 6032.5 -endpos 2.5
TEASE += $(applause-1) # 3 -chapter 31 -ss 6967 -endpos 4

TEASE2-name = trailer2

TEASE2 += $(intro)
TEASE2 += $(knock-knock) # 1 -chapter 3 -ss 469 -endpos 3
TEASE2 += $(make-a-choice) # 1 -chapter 22 -ss 4578 -endpos 3
TEASE2 += $(blue-pill) # 1 -chapter 8 -ss 1744 -endpos 2
TEASE2 += $(going-to-help) # 1 -chapter 6 -ss 1257 -endpos 6
TEASE2 += $(know-that-road) # 1 -chapter 8 -ss 1418.5 -endpos 8.5
TEASE2 += $(red-pill) # 1 -chapter 8 -ss 1751 -endpos 1.5
TEASE2 += $(okiedokie) # 1 -chapter 16 -ss 3249 -endpos 6
TEASE2 += $(no-problem) # 1 -chapter 16 -ss 3265 -endpos 7
TEASE2 += $(waiting-for-something) # 1 -chapter 22 -ss 4515.5 -endpos 2.5
TEASE2 += $(showing-the-door) # 1 -chapter 16 -ss 3201 -endpos 8.5
TEASE2 += $(takes-red-pill) # 1 -chapter 8 -ss 1772 -endpos 5
TEASE2 += $(control-life) # 1 -chapter 22 -ss 4621 -endpos 3
TEASE2 += $(show-these-people) # 1 -chapter 37 -ss 7693.5 -endpos 15
TEASE2 += $(fighting-for-something) # 3 -chapter 29 -ss 6537.5 -endpos 5.5
TEASE2 += $(is-it-freedom) # 3 -chapter 29 -ss 6550 -endpos 1.2
TEASE2 += $(hell-yes-tease) # 1 -chapter 14 -ss 2915 -endpos 2
TEASE2 += $(applause-2) # 2 -chapter 7 -ss 1461 -endpos 3

-include Makefile.xg
Makefile.xg: Makefile.x genextract
	$(AWK) -f genextract < Makefile.x > $@

.PHONY: extract-all from-Matrix from-Reloaded from-Revolutions
extract-all: from-Matrix from-Reloaded from-Revolutions
from-Matrix: $(FROM1)
from-Reloaded: $(FROM2)
from-Revolutions: $(FROM3)

.PHONY: avi
avi: $(ALL_AVI)

$(ALL_AVI):
	$(MCOPY) $(INPUT-$(@:%.avi=%))

.PHONY: links clean-links
links: $(FROM1) $(FROM2) $(FROM3)

clean-links:
	-rm -f $(FROM1) $(FROM2) $(FROM3)

xclean:
	-rm -f $(TOCLEAN)
