// $Id: MetaException.java,v 1.3 1998/05/08 15:50:12 oliva Exp $

/* Copyright 1997,1998 Alexandre Oliva <oliva@dcc.unicamp.br>
 *
 * See the files "COPYING" and "README" for information on usage and
 * redistribution of this file.  */

package BR.unicamp.Guarana;

/** This exception encapsulates any Exception that is produced by a
    MetaObject or other objects it invokes while handling an
    Operation.

    @author Alexandre Oliva
    @version $Revision: 1.3 $  */
public class MetaException extends RuntimeException {
  /** The thrown value encapsulated in this Exception.  */
  public final Throwable thrown;

  /** Constructs an MetaException without a detail message.

      @param thrown the Throwable thrown in the meta-level.  */
  public MetaException(Throwable thrown) {
    super();
    this.thrown = thrown;
  }

  /** Constructs an MetaException with a detail message.

      @param thrown the Throwable thrown in the meta-level.

      @param s the detail message.  */
  public MetaException(Throwable thrown, String s) {
    super(s);
    this.thrown = thrown;
  }

  /** Obtains the Throwable that was encapsulated in the
      MetaException.

      @return the Throwable.  */
  public Throwable getException() {
    return thrown;
  }
}
