// $Id: MakeProxy.java,v 1.1 1998/06/05 12:22:41 oliva Exp $

/* Copyright 1998 Alexandre Oliva <oliva@dcc.unicamp.br>
 *
 * This file is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

import BR.unicamp.Guarana.*;

/**
 * This program shows how objects can be created from the meta-level,
 * by calling Guarana.makeProxy then invoking the object's
 * constructor.
 *
 * @see Guarana#makeProxy
 *
 * @author Alexandre Oliva
 * @version $Revision: 1.1 $
 */
public class MakeProxy extends MetaObject {
    public static class Base {}
    public static class Init implements Message {}
    public static void main(String [ ] argv) {
	Guarana.reconfigure(Base.class, null, new MetaLogger().setPrefix("c: "));
	MetaObject mo = new SequentialComposer(new MetaObject [ ] {
	    new MetaLogger().setPrefix("o: "), new MakeProxy()
	}) {
	    public MetaObject reconfigure
	    (final Object o, final MetaObject pre, final MetaObject pos) {
		if (pre == this) return pos;
		else return super.reconfigure(o, pre, pos);
	    }
	};
	Base o = (Base)Guarana.makeProxy(Base.class, mo);
	Guarana.reconfigure(Base.class, null, null);
	Guarana.broadcast(new Init(), o);
	Guarana.reconfigure(o, null, null);
	System.out.println(o);
    }
    private OperationFactory opf;
    public void initialize(final OperationFactory opf, final Object ob)
    { this.opf = opf; }
    public void handle(final Message m, final Object ob) {
	if (m instanceof Init) try {
	    final java.lang.reflect.Constructor
		c = Base.class.getDeclaredConstructor(new Class[0]);
	    opf.construct(c, new Object[0]).perform();
	} catch (NoSuchMethodException e) {
	} catch (IllegalAccessException e) {}
    }
}
