// $Id: OpFactNoPrivate.java,v 1.1 1998/06/05 12:22:47 oliva Exp $

/* Copyright 1998 Alexandre Oliva <oliva@dcc.unicamp.br>
 *
 * This file is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

import java.lang.reflect.*;
import BR.unicamp.Guarana.*;

/**
 * This class shows how an Operation Factory that restricts access to
 * the underlying object can be implemented.  This particular
 * implementation prevents access to private fields.  It also prevents
 * non-reflexive instances from becoming reflexive.
 *
 * @author Alexandre Oliva
 * @version $Revision: 1.1 $ */
public class OpFactNoPrivate extends OperationFactoryFilter {
    public OpFactNoPrivate(final OperationFactory opf) { super(opf); }
    public Operation read(final Field field, final Operation op) 
    throws IllegalAccessException, IllegalArgumentException {
	if (Modifier.isPrivate(field.getModifiers()))
	    throw new IllegalAccessException("access to private field denied");
	else return super.read(field, op);
    }
    public Operation write(final Field field, final Object value, final Operation op) 
    throws IllegalAccessException, IllegalArgumentException {
	if (Modifier.isPrivate(field.getModifiers()))
	    throw new IllegalAccessException("access to private field denied");
	else return super.write(field, value, op);
    }
    static {
	Guarana.reconfigure(OpFactNoPrivate.class, null, new MetaObject() {
	    public void handle(final Message m, final Object o) {
		if (m instanceof InstanceReconfigure)
		    ((InstanceReconfigure)m).setMetaObject(null);
	    }
	    public MetaObject reconfigure
		(final Object o, final MetaObject m, final MetaObject n)
		{ return this; }
	});
    }
}
