// $Id: Composer.java,v 1.7 1998/06/08 10:14:03 oliva Exp $

/* Copyright 1997,1998 Alexandre Oliva <oliva@dcc.unicamp.br>
 *
 * This file is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

package BR.unicamp.Guarana;

import java.util.Enumeration;

/** Composers are MetaObjects that delegate operations to other
    MetaObjects.  The only difference between a MetaObject and a
    Composer is semantic: a Composer is expected to delegate operation
    handling to other MetaObjects, while non-Composers are expected to
    handle operations by themselves.  A Composer must implement at
    least one method that will return the set of MetaObjects it
    delegates to.
   
    @author Alexandre Oliva
    @version $Revision: 1.7 $  */
public abstract class Composer extends MetaObject {
  /** Provides the set of MetaObjects the Composer delegates to.  The
      Enumeration may contain non-MetaObject objects that mark up
      semantics of delegation.  Thus, concurrent MetaObjects may be
      preceded and followed by such objects; MetaObjects that are only
      invoked conditionally may be marked so, etc.  There are no
      predefined marks.

      Even if the Composer does not delegate to any MetaObject, it
      must return a non-null Enumeration.  The Enumeration must
      reflect the set of MetaObjects at the moment of the invocation
      of this method; if the set of MetaObjects changes thereafter,
      the Enumeration must NOT change accordingly.  It must iterate on
      a copy of the current set, or prevent any modification thereof.

      @return an unmodifiable set of MetaObjects the Composer
      delegates to as an Enumeration.  */
  public abstract Enumeration getMetaObjects();

  /** Provides an array of MetaObjects this Composer delegates to,
      that is ensured not to change.  It must be a copy of the current
      set of MetaObjects, or the array must be ensured not to change.

      The default behavior is to count the number of MetaObjects
      in the Enumeration returned by getMetaObjects(), then create an
      array that large, and copy references to the MetaObjects into
      that array.  Mark up non-MetaObjects are ignored.

      @return an unmodifiable array of MetaObjects.  */
  public synchronized MetaObject[] getMetaObjectsArray() {
    int count = 0;
    for(final Enumeration e = getMetaObjects();
	e.hasMoreElements();)
      if (e.nextElement() instanceof MetaObject)
	++count;
    MetaObject[] res = new MetaObject[count];
    int i = 0;
    for(final Enumeration e = getMetaObjects();
	e.hasMoreElements();) {
      Object o = e.nextElement();
      if (o instanceof MetaObject)
	res[i++] = (MetaObject)o;
    }
    return res;
  }
}
