/*
 * Decompiled with CFR 0.152.
 */
package java.awt;

import java.awt.Component;
import java.awt.Defaults;
import java.awt.Event;
import java.awt.RootWindow;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.MouseEvent;
import java.util.EventObject;
import kaffe.util.Ptr;

public class AWTEvent
extends EventObject {
    protected int id;
    protected boolean consumed = false;
    protected AWTEvent next;
    private static final long serialVersionUID = -1825314779160409405L;
    public static final int COMPONENT_EVENT_MASK = 1;
    public static final int CONTAINER_EVENT_MASK = 2;
    public static final int FOCUS_EVENT_MASK = 4;
    public static final int KEY_EVENT_MASK = 8;
    public static final int MOUSE_EVENT_MASK = 16;
    public static final int MOUSE_MOTION_EVENT_MASK = 32;
    public static final int WINDOW_EVENT_MASK = 64;
    public static final int ACTION_EVENT_MASK = 128;
    public static final int ADJUSTMENT_EVENT_MASK = 256;
    public static final int ITEM_EVENT_MASK = 512;
    public static final int TEXT_EVENT_MASK = 1024;
    public static final int RESERVED_ID_MAX = 1999;
    static final int DISABLED_MASK = Integer.MIN_VALUE;
    static Component keyTgt;
    static Window activeWindow;
    static Component mouseTgt;
    protected static int inputModifier;
    protected static boolean accelHint;
    protected static Component[] sources;
    static int nSources;
    protected static Object evtLock;
    protected static RootWindow root;
    protected static Component nativeSource;

    protected AWTEvent(Object object, int n) {
        super(object);
        this.id = n;
    }

    public void consume() {
        this.consumed = true;
    }

    protected void dispatch() {
        ((Component)this.source).processEvent(this);
    }

    public int getID() {
        return this.id;
    }

    static int getID(AWTEvent aWTEvent) {
        return aWTEvent.id;
    }

    static Object getSource(AWTEvent aWTEvent) {
        return aWTEvent.source;
    }

    protected static Component getToplevel(Component component) {
        while (!(component instanceof Window)) {
            component = component.parent;
        }
        return component;
    }

    protected Event initOldEvent(Event event) {
        return null;
    }

    protected boolean isConsumed() {
        return this.consumed;
    }

    protected boolean isLiveEventFor(Object object) {
        return false;
    }

    protected boolean isObsoletePaint(Object object, int n, int n2, int n3, int n4) {
        return false;
    }

    public String paramString() {
        return "";
    }

    protected void recycle() {
        this.source = null;
        this.next = null;
    }

    static void registerSource(Component component, Ptr ptr) {
        int n = Toolkit.evtRegisterSource(ptr);
        AWTEvent.sources[n] = component;
        if (++nSources == 1) {
            Toolkit.startDispatch();
        }
    }

    protected MouseEvent retarget(Component component, int n, int n2) {
        return null;
    }

    protected static void sendEvent(AWTEvent aWTEvent, boolean bl) {
        if (bl) {
            aWTEvent.dispatch();
        } else {
            Toolkit.eventQueue.postEvent(aWTEvent);
        }
    }

    static void setSource(AWTEvent aWTEvent, Object object) {
        aWTEvent.source = object;
    }

    public String toString() {
        return String.valueOf(String.valueOf(String.valueOf(String.valueOf(this.getClass().getName()).concat(String.valueOf(':'))).concat(String.valueOf(this.paramString()))).concat(String.valueOf(", source: "))).concat(String.valueOf(this.source));
    }

    static void unregisterSource(Component component, Ptr ptr) {
        int n = Toolkit.evtUnregisterSource(ptr);
        AWTEvent.sources[n] = null;
        if (component == nativeSource) {
            nativeSource = null;
        }
        if (--nSources == 0 && Defaults.AutoStop) {
            System.getSecurityManager().checkExit(0);
            Toolkit.terminate();
            System.exit(0);
        }
    }

    static {
        evtLock = new Object();
        sources = Toolkit.evtInit();
    }
}

