/*
 * Decompiled with CFR 0.152.
 */
package java.awt;

import java.awt.Font;
import java.awt.Toolkit;
import java.io.Serializable;
import java.util.Hashtable;
import kaffe.util.Ptr;

public class FontMetrics
implements Serializable {
    transient Ptr nativeData;
    protected Font font;
    transient int height;
    transient int descent;
    transient int ascent;
    transient int leading;
    transient int maxAdvance;
    transient int maxDescent;
    transient int maxAscent;
    transient int fixedWidth;
    transient int[] widths;
    transient boolean isWideFont;
    static transient Hashtable cache = new Hashtable();
    private static final long serialVersionUID = 1681126225205050147L;

    FontMetrics(Font font) {
        this.font = font;
        this.nativeData = Toolkit.fntInitFontMetrics(this.font.nativeData);
        this.height = Toolkit.fntGetHeight(this.nativeData);
        this.descent = Toolkit.fntGetDescent(this.nativeData);
        this.maxDescent = Toolkit.fntGetMaxDescent(this.nativeData);
        this.ascent = Toolkit.fntGetAscent(this.nativeData);
        this.leading = Toolkit.fntGetLeading(this.nativeData);
        this.maxAscent = Toolkit.fntGetMaxAscent(this.nativeData);
        this.maxAdvance = Toolkit.fntGetMaxAdvance(this.nativeData);
        this.fixedWidth = Toolkit.fntGetFixedWidth(this.nativeData);
        this.widths = Toolkit.fntGetWidths(this.nativeData);
        this.isWideFont = Toolkit.fntIsWideFont(this.nativeData);
    }

    public int bytesWidth(byte[] byArray, int n, int n2) {
        if (this.fixedWidth != 0) {
            return n2 * this.fixedWidth;
        }
        if (!this.isWideFont) {
            int n3;
            int n4 = n + n2;
            try {
                n3 = 0;
                for (int i = n; i < n4; ++i) {
                    n3 += this.widths[byArray[i]];
                }
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                return 0;
            }
            return n3;
        }
        return Toolkit.fntBytesWidth(this.nativeData, byArray, n, n2);
    }

    public int charWidth(char c) {
        if (this.fixedWidth != 0) {
            return this.fixedWidth;
        }
        if (c < '\u0100') {
            return this.widths[c];
        }
        return Toolkit.fntCharWidth(this.nativeData, c);
    }

    public int charWidth(int n) {
        return this.charWidth((char)n);
    }

    public int charsWidth(char[] cArray, int n, int n2) {
        if (this.fixedWidth != 0) {
            return n2 * this.fixedWidth;
        }
        if (!this.isWideFont) {
            int n3;
            int n4 = n + n2;
            try {
                n3 = 0;
                for (int i = n; i < n4; ++i) {
                    n3 += this.widths[cArray[i]];
                }
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                return 0;
            }
            return n3;
        }
        return Toolkit.fntCharsWidth(this.nativeData, cArray, n, n2);
    }

    protected void finalize() throws Throwable {
        if (this.nativeData != null) {
            Toolkit.fntFreeFontMetrics(this.nativeData);
            this.nativeData = null;
        }
        super.finalize();
    }

    public int getAscent() {
        return this.ascent;
    }

    public int getDescent() {
        return this.descent;
    }

    public Font getFont() {
        return this.font;
    }

    static FontMetrics getFontMetrics(Font font) {
        FontMetrics fontMetrics = (FontMetrics)cache.get(font);
        if (fontMetrics == null) {
            fontMetrics = new FontMetrics(font);
            cache.put(font, fontMetrics);
        }
        return fontMetrics;
    }

    public int getHeight() {
        return this.height;
    }

    public int getLeading() {
        return this.leading;
    }

    public int getMaxAdvance() {
        return this.maxAdvance;
    }

    public int getMaxAscent() {
        return this.maxAscent;
    }

    public int getMaxDecent() {
        return this.getMaxDescent();
    }

    public int getMaxDescent() {
        return this.maxDescent;
    }

    public int[] getWidths() {
        return this.widths;
    }

    public int stringWidth(String string) {
        return Toolkit.fntStringWidth(this.nativeData, string);
    }

    public String toString() {
        return String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(this.getClass().getName()).concat(String.valueOf(" ["))).concat(String.valueOf(this.font))).concat(String.valueOf(','))).concat(String.valueOf(this.ascent))).concat(String.valueOf(','))).concat(String.valueOf(this.descent))).concat(String.valueOf(','))).concat(String.valueOf(this.height))).concat(String.valueOf(']'));
    }
}

