/*
 * Decompiled with CFR 0.152.
 */
package java.awt;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.LayoutManager2;
import java.awt.Point;
import java.awt.Rectangle;
import java.io.Serializable;
import java.util.Hashtable;
import kaffe.util.NotImplemented;

public class GridBagLayout
implements LayoutManager2,
Serializable {
    protected static final int MINSIZE = 1;
    protected static final int PREFERREDSIZE = 2;
    protected static final int ACTUALSIZE = 3;
    protected static final int MAXGRIDSIZE = 512;
    private static final long serialVersionUID = 8838754796412211005L;
    protected Hashtable comptable = new Hashtable();
    protected GridBagConstraints defaultConstraints = new GridBagConstraints();
    public int[] columnWidths;
    public int[] rowHeights;
    public double[] columnWeights;
    public double[] rowWeights;
    transient Point offset = new Point();

    protected void AdjustForGravity(GridBagConstraints gridBagConstraints, Rectangle rectangle) {
        throw new NotImplemented();
    }

    protected void ArrangeGrid(Container container) {
        this.layoutContainer(container);
    }

    public void addLayoutComponent(Component component, Object object) {
        try {
            if (object != null) {
                this.setConstraints(component, (GridBagConstraints)object);
            }
        }
        catch (ClassCastException classCastException) {
            throw new IllegalArgumentException("not GridBagConstraints");
        }
    }

    public void addLayoutComponent(String string, Component component) {
    }

    void adjustWeightsRelative(Container container) {
        int n;
        double d;
        int n2;
        int n3;
        Insets insets = container.getInsets();
        int n4 = 0;
        int n5 = 0;
        int n6 = this.sumWidths();
        int n7 = this.sumHeights();
        double d2 = 0.0;
        double d3 = 0.0;
        for (n3 = 0; n3 < this.columnWeights.length; ++n3) {
            if (!(this.columnWeights[n3] > 0.0)) continue;
            d2 += this.columnWeights[n3];
            ++n4;
        }
        for (n3 = 0; n3 < this.rowWeights.length; ++n3) {
            if (!(this.rowWeights[n3] > 0.0)) continue;
            d3 += this.rowWeights[n3];
            ++n5;
        }
        int n8 = insets.left + insets.right;
        int n9 = insets.top + insets.bottom;
        if (n4 > 0) {
            n2 = container.width - n6 - n8;
            for (n3 = 0; n3 < this.columnWeights.length; ++n3) {
                d = this.columnWeights[n3];
                if (d > 0.0) {
                    n = (int)(d / d2 * (double)n2);
                    int n10 = n3;
                    this.columnWidths[n10] = this.columnWidths[n10] + n;
                    d2 -= d;
                    n2 -= n;
                }
                if (d2 == 0.0) break;
            }
            if (n2 > 0) {
                int n11 = n3;
                this.columnWidths[n11] = this.columnWidths[n11] + n2;
            }
            this.offset.x = 0;
        } else {
            this.offset.x = (container.width - n6 - n8) / 2;
        }
        if (n5 > 0) {
            n2 = container.height - n7 - n9;
            for (n3 = 0; n3 < this.rowWeights.length; ++n3) {
                d = this.rowWeights[n3];
                if (d > 0.0) {
                    n = (int)(d / d3 * (double)n2);
                    int n12 = n3;
                    this.rowHeights[n12] = this.rowHeights[n12] + n;
                    d3 -= d;
                    n2 -= n;
                }
                if (d3 == 0.0) break;
            }
            if (n2 > 0) {
                int n13 = n3;
                this.rowHeights[n13] = this.rowHeights[n13] + n2;
            }
            this.offset.y = 0;
        } else {
            this.offset.y = (container.height - n7 - n9) / 2;
        }
    }

    int columnStart(int n) {
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            n2 += this.columnWidths[i];
        }
        return n2;
    }

    void dumpDims() {
        System.out.print("\t");
        for (int i = 0; i < this.columnWidths.length; ++i) {
            System.out.print(String.valueOf(this.columnWidths[i]).concat(String.valueOf(" ")));
        }
        System.out.println();
        for (int i = 0; i < this.rowHeights.length; ++i) {
            System.out.println(this.rowHeights[i]);
        }
    }

    void dumpWeights() {
        System.out.print("\t");
        for (int i = 0; i < this.columnWeights.length; ++i) {
            System.out.print(String.valueOf(this.columnWeights[i]).concat(String.valueOf(" ")));
        }
        System.out.println();
        for (int i = 0; i < this.rowWeights.length; ++i) {
            System.out.println(this.rowWeights[i]);
        }
    }

    void getCellDims(Container container, int n) {
        Dimension dimension = this.getLayoutExtends(container);
        int n2 = -1;
        int n3 = 0;
        int n4 = container.getComponentCount();
        this.rowHeights = new int[dimension.height];
        this.columnWidths = new int[dimension.width];
        this.columnWeights = new double[dimension.width];
        this.rowWeights = new double[dimension.height];
        for (int i = 0; i < n4; ++i) {
            Component component = container.getComponent(i);
            GridBagConstraints gridBagConstraints = this.lookupConstraints(component);
            Dimension dimension2 = n == 1 ? component.getMinimumSize() : component.getPreferredSize();
            n2 = gridBagConstraints.gridx == -1 ? ++n2 : gridBagConstraints.gridx;
            if (gridBagConstraints.gridy > -1) {
                n3 = gridBagConstraints.gridy;
            }
            int n5 = dimension2.width + gridBagConstraints.insets.left + gridBagConstraints.insets.right + 2 * gridBagConstraints.ipadx;
            int n6 = dimension2.height + gridBagConstraints.insets.top + gridBagConstraints.insets.bottom + 2 * gridBagConstraints.ipady;
            int n7 = gridBagConstraints.gridwidth;
            int n8 = gridBagConstraints.gridheight;
            if (n7 == 0) {
                n7 = dimension.width - n2;
            } else if (n7 == -1) {
                n7 = dimension.width - n2 - 1;
            }
            if (n8 == 0) {
                n8 = dimension.height - n3;
            } else if (n8 == -1) {
                n8 = dimension.height - n3 - 1;
            }
            if (n7 < 1) {
                n7 = 1;
            }
            if (n8 < 1) {
                n8 = 1;
            }
            n5 /= n7;
            n6 /= n8;
            for (int j = 0; j < n7; ++j) {
                if (this.columnWidths[n2 + j] >= n5) continue;
                this.columnWidths[n2 + j] = n5;
            }
            if (this.columnWeights[n2 + n7 - 1] < gridBagConstraints.weightx) {
                this.columnWeights[n2 + n7 - 1] = gridBagConstraints.weightx;
            }
            for (int j = 0; j < n8; ++j) {
                if (this.rowHeights[n3 + j] >= n6) continue;
                this.rowHeights[n3 + j] = n6;
            }
            if (this.rowWeights[n3 + n8 - 1] < gridBagConstraints.weighty) {
                this.rowWeights[n3 + n8 - 1] = gridBagConstraints.weighty;
            }
            n2 += n7 - 1;
            if (gridBagConstraints.gridwidth != 0) continue;
            ++n3;
            n2 = -1;
        }
        if (n == 3) {
            this.adjustWeightsRelative(container);
        }
    }

    public GridBagConstraints getConstraints(Component component) {
        return (GridBagConstraints)this.lookupConstraints(component).clone();
    }

    public float getLayoutAlignmentX(Container container) {
        return 0.5f;
    }

    public float getLayoutAlignmentY(Container container) {
        return 0.5f;
    }

    public int[][] getLayoutDimensions() {
        return new int[][]{this.columnWidths, this.rowHeights};
    }

    Dimension getLayoutExtends(Container container) {
        int n = 0;
        int n2 = 0;
        int n3 = -1;
        int n4 = 0;
        int n5 = container.getComponentCount();
        block7: for (int i = 0; i < n5; ++i) {
            Component component = container.getComponent(i);
            GridBagConstraints gridBagConstraints = this.lookupConstraints(component);
            n3 = gridBagConstraints.gridx >= 0 ? gridBagConstraints.gridx : ++n3;
            if (gridBagConstraints.gridy >= 0) {
                n4 = gridBagConstraints.gridy;
            }
            switch (gridBagConstraints.gridwidth) {
                case 0: {
                    if (n < n3) {
                        n = n3;
                    }
                    n3 = -1;
                    ++n4;
                    break;
                }
                case -1: {
                    if (n >= n3) break;
                    n = n3;
                    break;
                }
                default: {
                    if (n >= (n3 += gridBagConstraints.gridwidth - 1)) break;
                    n = n3;
                }
            }
            switch (gridBagConstraints.gridheight) {
                case -1: 
                case 0: {
                    continue block7;
                }
                default: {
                    if (n3 == -1 || n2 >= n4 + gridBagConstraints.gridheight) continue block7;
                    n2 = n4 + gridBagConstraints.gridheight;
                }
            }
        }
        return new Dimension(n + 1, Math.max(n2, n4));
    }

    public Point getLayoutOrigin() {
        return this.offset;
    }

    public double[][] getLayoutWeights() {
        return new double[][]{this.columnWeights, this.rowWeights};
    }

    public void invalidateLayout(Container container) {
        this.layoutContainer(container);
    }

    public void layoutContainer(Container container) {
        Insets insets = container.getInsets();
        int n = -1;
        int n2 = 0;
        int n3 = insets.left;
        int n4 = insets.top;
        int n5 = 0;
        int n6 = 0;
        Rectangle rectangle = new Rectangle();
        int n7 = container.getComponentCount();
        this.getCellDims(container, 3);
        for (int i = 0; i < n7; ++i) {
            int n8;
            Component component = container.getComponent(i);
            GridBagConstraints gridBagConstraints = this.lookupConstraints(component);
            boolean bl = false;
            if (gridBagConstraints.gridy >= 0) {
                n2 = gridBagConstraints.gridy;
                n4 = this.rowStart(n2) + insets.top;
            }
            if (gridBagConstraints.gridx < 0) {
                ++n;
                if (n2 > rectangle.y) {
                    n += rectangle.x + rectangle.width;
                }
                n3 = this.columnStart(n) + insets.left;
            } else {
                n = gridBagConstraints.gridx;
                n3 = this.columnStart(n) + insets.left;
            }
            int n9 = gridBagConstraints.gridwidth;
            if (n9 == 0) {
                n9 = this.columnWidths.length - n;
                bl = true;
            } else if (n9 == -1) {
                n9 = this.columnWidths.length - n - 1;
            }
            int n10 = gridBagConstraints.gridheight;
            if (n10 == 0) {
                n10 = this.rowHeights.length - n2;
            } else if (n10 == -1) {
                n10 = this.rowHeights.length - n2 - 1;
            }
            n5 = 0;
            for (n8 = 0; n8 < n9; ++n8) {
                n5 += this.columnWidths[n++];
            }
            --n;
            n6 = 0;
            for (n8 = 0; n8 < n10; ++n8) {
                n6 += this.rowHeights[n2 + n8];
            }
            if (n10 > 1) {
                rectangle.setBounds(n, n2, n9, n10);
            } else if (n2 >= rectangle.y + rectangle.height) {
                rectangle.setBounds(0, 0, 0, 0);
            }
            Insets insets2 = gridBagConstraints.insets;
            Dimension dimension = component.getPreferredSize();
            int n11 = n3 + this.offset.x;
            int n12 = n4 + this.offset.y;
            int n13 = dimension.width;
            int n14 = dimension.height;
            block0 : switch (gridBagConstraints.fill) {
                case 1: {
                    n11 += insets2.left + gridBagConstraints.ipadx;
                    n12 += insets2.top + gridBagConstraints.ipady;
                    n13 = n5 - (insets2.left + insets2.right + 2 * gridBagConstraints.ipadx);
                    n14 = n6 - (insets2.top + insets2.bottom + 2 * gridBagConstraints.ipady);
                    break;
                }
                case 2: {
                    n11 += insets2.left + gridBagConstraints.ipadx;
                    n13 = n5 - (insets2.left + insets2.right + 2 * gridBagConstraints.ipadx);
                    switch (gridBagConstraints.anchor) {
                        default: {
                            n12 += (n6 - n14) / 2;
                            break block0;
                        }
                        case 11: 
                        case 12: 
                        case 18: {
                            n12 += insets2.top + gridBagConstraints.ipady;
                            break block0;
                        }
                        case 14: 
                        case 15: 
                        case 16: 
                    }
                    n12 += n6 - (dimension.height + insets2.bottom + gridBagConstraints.ipady);
                    break;
                }
                case 3: {
                    n12 += insets2.top + gridBagConstraints.ipady;
                    n13 = n6 - (insets2.top + insets2.bottom + 2 * gridBagConstraints.ipady);
                    switch (gridBagConstraints.anchor) {
                        default: {
                            n11 += (n5 - n13) / 2;
                            break block0;
                        }
                        case 16: 
                        case 17: 
                        case 18: {
                            n11 += insets2.left + gridBagConstraints.ipadx;
                            break block0;
                        }
                        case 12: 
                        case 13: 
                        case 14: 
                    }
                    n11 += n5 - (n13 + insets2.right + gridBagConstraints.ipadx);
                    break;
                }
                default: {
                    switch (gridBagConstraints.anchor) {
                        case 11: {
                            n12 += insets2.top + gridBagConstraints.ipady;
                            n11 += (n5 - n13) / 2;
                            break block0;
                        }
                        case 12: {
                            n12 += insets2.top + gridBagConstraints.ipady;
                            n11 += n5 - (n13 + insets2.right + gridBagConstraints.ipadx);
                            break block0;
                        }
                        case 13: {
                            n12 += (n6 - n14) / 2;
                            n11 += n5 - (n13 + insets2.right + gridBagConstraints.ipadx);
                            break block0;
                        }
                        case 14: {
                            n12 += n6 - (n14 + insets2.bottom + gridBagConstraints.ipady);
                            n11 += n5 - (n13 + insets2.right + gridBagConstraints.ipadx);
                            break block0;
                        }
                        case 15: {
                            n12 += n6 - (n14 + insets2.bottom + gridBagConstraints.ipady);
                            n11 += (n5 - n13) / 2;
                            break block0;
                        }
                        case 16: {
                            n12 += n6 - (n14 + insets2.bottom + gridBagConstraints.ipady);
                            n11 += insets2.left + gridBagConstraints.ipadx;
                            break block0;
                        }
                        case 17: {
                            n12 += (n6 - n14) / 2;
                            n11 += insets2.left + gridBagConstraints.ipadx;
                            break block0;
                        }
                        case 18: {
                            n12 += insets2.top + gridBagConstraints.ipady;
                            n11 += insets2.left + gridBagConstraints.ipadx;
                            break block0;
                        }
                    }
                    n12 += (n6 - n14) / 2;
                    n11 += (n5 - n13) / 2;
                }
            }
            component.setBounds(n11, n12, n13, n14);
            if (!bl) continue;
            n = -1;
            n4 += n6;
            ++n2;
        }
    }

    public Point location(int n, int n2) {
        int n3;
        int n4 = this.offset.x;
        int n5 = this.offset.y;
        for (n3 = 0; n3 < this.columnWidths.length && n >= (n4 += this.columnWidths[n3]); ++n3) {
        }
        int n6 = 0;
        while (n3 < this.rowHeights.length && n2 >= (n5 += this.rowHeights[n6])) {
            ++n6;
        }
        return new Point(n3, n6);
    }

    protected GridBagConstraints lookupConstraints(Component component) {
        GridBagConstraints gridBagConstraints = (GridBagConstraints)this.comptable.get(component);
        if (gridBagConstraints == null) {
            gridBagConstraints = this.defaultConstraints;
        }
        return gridBagConstraints;
    }

    public Dimension maximumLayoutSize(Container container) {
        return new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE);
    }

    public Dimension minimumLayoutSize(Container container) {
        Insets insets = container.getInsets();
        this.getCellDims(container, 1);
        return new Dimension(this.sumWidths() + insets.left + insets.right, this.sumHeights() + insets.top + insets.bottom);
    }

    public Dimension preferredLayoutSize(Container container) {
        Insets insets = container.getInsets();
        this.getCellDims(container, 2);
        return new Dimension(this.sumWidths() + insets.left + insets.right, this.sumHeights() + insets.top + insets.bottom);
    }

    public void removeLayoutComponent(Component component) {
        this.comptable.remove(component);
    }

    int rowStart(int n) {
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            n2 += this.rowHeights[i];
        }
        return n2;
    }

    public void setConstraints(Component component, GridBagConstraints gridBagConstraints) {
        this.comptable.put(component, (GridBagConstraints)gridBagConstraints.clone());
    }

    int sumHeights() {
        int n = 0;
        for (int i = 0; i < this.rowHeights.length; ++i) {
            n += this.rowHeights[i];
        }
        return n;
    }

    int sumWidths() {
        int n = 0;
        for (int i = 0; i < this.columnWidths.length; ++i) {
            n += this.columnWidths[i];
        }
        return n;
    }

    public String toString() {
        int n = this.columnWidths != null ? this.columnWidths.length : 0;
        int n2 = this.rowHeights != null ? this.rowHeights.length : 0;
        return String.valueOf(String.valueOf(String.valueOf("GridBagLayout columns: ").concat(String.valueOf(n))).concat(String.valueOf(",rows: "))).concat(String.valueOf(n2));
    }
}

