/*
 * Decompiled with CFR 0.152.
 */
package java.awt;

import java.awt.Defaults;
import java.awt.Image;
import java.awt.ImageLoader;
import java.awt.Toolkit;
import java.awt.image.ColorModel;
import java.awt.image.ImageConsumer;
import java.awt.image.ImageProducer;
import java.io.File;
import java.io.InputStream;
import java.net.URL;
import java.util.Vector;
import kaffe.io.AccessibleBAOStream;
import kaffe.util.Ptr;

class ImageNativeProducer
implements ImageProducer {
    Object consumer;
    Object src;
    int off;
    int len;

    ImageNativeProducer(Image image) {
        this.src = image;
    }

    ImageNativeProducer(Image image, File file) {
        this.src = file;
        if (file.exists()) {
            if (file.length() < (long)Defaults.FileImageThreshold) {
                image.flags |= 0x100;
                ImageLoader imageLoader = ImageLoader.syncLoader;
                synchronized (imageLoader) {
                    try {
                        ImageLoader.syncLoader.img = image;
                        image.producer = this;
                        this.startProduction(ImageLoader.syncLoader);
                        Object var5_4 = null;
                    }
                    catch (Throwable throwable) {
                        Object var5_5 = null;
                        throw throwable;
                    }
                }
            }
        } else {
            image.flags = 192;
        }
    }

    ImageNativeProducer(Image image, byte[] byArray, int n, int n2) {
        this.src = byArray;
        this.off = n;
        this.len = n2;
        if (n2 < Defaults.DataImageThreshold) {
            image.flags |= 0x100;
            ImageLoader imageLoader = ImageLoader.syncLoader;
            synchronized (imageLoader) {
                try {
                    ImageLoader.syncLoader.img = image;
                    image.producer = this;
                    this.startProduction(ImageLoader.syncLoader);
                    Object var7_6 = null;
                }
                catch (Throwable throwable) {
                    Object var7_7 = null;
                    throw throwable;
                }
            }
        }
    }

    ImageNativeProducer(URL uRL) {
        this.src = uRL;
    }

    public void addConsumer(ImageConsumer imageConsumer) {
        if (this.consumer == null) {
            this.consumer = imageConsumer;
        } else if (this.consumer instanceof Vector) {
            ((Vector)this.consumer).addElement(imageConsumer);
        } else {
            Vector vector = new Vector(3);
            vector.addElement(this.consumer);
            vector.addElement(imageConsumer);
            this.consumer = vector;
        }
    }

    void imageComplete(int n) {
        if (this.consumer instanceof ImageConsumer) {
            ((ImageConsumer)this.consumer).imageComplete(n);
        } else if (this.consumer instanceof Vector) {
            Vector vector = (Vector)this.consumer;
            int n2 = vector.size();
            for (int i = 0; i < n2; ++i) {
                ((ImageConsumer)vector.elementAt(i)).imageComplete(n);
            }
        }
    }

    public boolean isConsumer(ImageConsumer imageConsumer) {
        if (this.consumer instanceof ImageConsumer) {
            return this.consumer == imageConsumer;
        }
        if (this.consumer instanceof Vector) {
            return ((Vector)this.consumer).contains(imageConsumer);
        }
        return false;
    }

    void produceFrom(File file) {
        Ptr ptr;
        if (file.exists() && (ptr = Toolkit.imgCreateFromFile(file.getAbsolutePath())) != null) {
            this.produceFrom(ptr);
        } else {
            this.imageComplete(5);
        }
    }

    void produceFrom(Ptr ptr) {
        if (this.consumer instanceof ImageLoader) {
            ImageLoader imageLoader = (ImageLoader)this.consumer;
            Image image = imageLoader.img;
            image.nativeData = ptr;
            image.width = Toolkit.imgGetWidth(ptr);
            image.height = Toolkit.imgGetHeight(ptr);
            imageLoader.setDimensions(image.width, image.height);
            imageLoader.imageComplete(Toolkit.imgIsMultiFrame(ptr) ? 2 : 3);
        } else {
            Toolkit.imgProduceImage(this, ptr);
            Toolkit.imgFreeImage(ptr);
        }
    }

    void produceFrom(URL uRL) {
        byte[] byArray = new byte[1024];
        try {
            InputStream inputStream = uRL.openStream();
            if (inputStream != null) {
                int n;
                AccessibleBAOStream accessibleBAOStream = new AccessibleBAOStream(8192);
                while ((n = inputStream.read(byArray)) >= 0) {
                    accessibleBAOStream.write(byArray, 0, n);
                }
                inputStream.close();
                Ptr ptr = Toolkit.imgCreateFromData(accessibleBAOStream.getBuffer(), 0, accessibleBAOStream.size());
                if (ptr != null) {
                    this.produceFrom(ptr);
                    return;
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.imageComplete(5);
    }

    void produceFrom(byte[] byArray, int n, int n2) {
        Ptr ptr = Toolkit.imgCreateFromData(byArray, n, n2);
        if (ptr != null) {
            this.produceFrom(ptr);
        } else {
            this.imageComplete(5);
        }
    }

    public void removeConsumer(ImageConsumer imageConsumer) {
        if (this.consumer == imageConsumer) {
            this.consumer = null;
        } else if (this.consumer instanceof Vector) {
            Vector vector = (Vector)this.consumer;
            vector.removeElement(imageConsumer);
            if (vector.size() == 1) {
                this.consumer = vector.elementAt(0);
            }
        }
    }

    public void requestTopDownLeftRightResend(ImageConsumer imageConsumer) {
    }

    void setColorModel(ColorModel colorModel) {
        if (this.consumer instanceof ImageConsumer) {
            ((ImageConsumer)this.consumer).setColorModel(colorModel);
        } else if (this.consumer instanceof Vector) {
            Vector vector = (Vector)this.consumer;
            int n = vector.size();
            for (int i = 0; i < n; ++i) {
                ((ImageConsumer)vector.elementAt(i)).setColorModel(colorModel);
            }
        }
    }

    void setDimensions(int n, int n2) {
        if (this.consumer instanceof ImageConsumer) {
            ((ImageConsumer)this.consumer).setDimensions(n, n2);
        } else if (this.consumer instanceof Vector) {
            Vector vector = (Vector)this.consumer;
            int n3 = vector.size();
            for (int i = 0; i < n3; ++i) {
                ((ImageConsumer)vector.elementAt(i)).setDimensions(n, n2);
            }
        }
    }

    void setHints(int n) {
        if (this.consumer instanceof ImageConsumer) {
            ((ImageConsumer)this.consumer).setHints(n);
        } else if (this.consumer instanceof Vector) {
            Vector vector = (Vector)this.consumer;
            int n2 = vector.size();
            for (int i = 0; i < n2; ++i) {
                ((ImageConsumer)vector.elementAt(i)).setHints(n);
            }
        }
    }

    void setPixels(int n, int n2, int n3, int n4, ColorModel colorModel, int[] nArray, int n5, int n6) {
        if (this.consumer instanceof ImageConsumer) {
            ((ImageConsumer)this.consumer).setPixels(n, n2, n3, n4, colorModel, nArray, n5, n6);
        } else if (this.consumer instanceof Vector) {
            Vector vector = (Vector)this.consumer;
            int n7 = vector.size();
            for (int i = 0; i < n7; ++i) {
                ((ImageConsumer)vector.elementAt(i)).setPixels(n, n2, n3, n4, colorModel, nArray, n5, n6);
            }
        }
    }

    public void startProduction(ImageConsumer imageConsumer) {
        this.addConsumer(imageConsumer);
        if (this.src instanceof File) {
            this.produceFrom((File)this.src);
        } else if (this.src instanceof URL) {
            this.produceFrom((URL)this.src);
        } else if (this.src instanceof byte[]) {
            this.produceFrom((byte[])this.src, this.off, this.len);
        } else if (this.src instanceof Image) {
            Toolkit.imgProduceImage(this, ((Image)this.src).nativeData);
        } else {
            System.err.println(String.valueOf("unsupported production source: ").concat(String.valueOf(this.src.getClass())));
        }
        this.removeConsumer(imageConsumer);
    }
}

