/*
 * Decompiled with CFR 0.152.
 */
package java.awt;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.image.ImageObserver;
import kaffe.util.Ptr;

class NativeGraphics
extends Graphics
implements ComponentListener {
    Ptr nativeData;
    int xOffset;
    int yOffset;
    Color fgClr;
    Color bgClr;
    Font font;
    int xClip;
    int yClip;
    int wClip;
    int hClip;
    Color xClr;
    Component target;
    int xTarget;
    int yTarget;
    NativeGraphics next;
    static NativeGraphics cache;
    static Object lock;
    static final int TGT_TYPE_WINDOW = 0;
    static final int TGT_TYPE_IMAGE = 1;
    static final int TGT_TYPE_GRAPHICS = 2;

    public void clearRect(int n, int n2, int n3, int n4) {
        Toolkit.graClearRect(this.nativeData, n, n2, n3, n4);
    }

    public void clipRect(int n, int n2, int n3, int n4) {
        int n5 = n > this.xClip ? n : this.xClip;
        int n6 = n2 > this.yClip ? n2 : this.yClip;
        int n7 = this.xClip + this.wClip;
        int n8 = this.yClip + this.hClip;
        int n9 = n + n3;
        int n10 = n2 + n4;
        int n11 = (n9 > n7 ? n7 : n9) - n5;
        int n12 = (n10 > n8 ? n8 : n10) - n6;
        if (n11 < 0) {
            n11 = 0;
        }
        if (n12 < 0) {
            n12 = 0;
        }
        this.xClip = n5;
        this.yClip = n6;
        this.wClip = n11;
        this.hClip = n12;
        Toolkit.graSetClip(this.nativeData, this.xClip, this.yClip, this.wClip, this.hClip);
    }

    public void componentHidden(ComponentEvent componentEvent) {
        Toolkit.graSetVisible(this.nativeData, false);
    }

    public void componentMoved(ComponentEvent componentEvent) {
        NativeGraphics.getClippedGraphics(this, this.target, this.xOffset - this.xTarget, this.yOffset - this.yTarget, this.xClip, this.yClip, this.wClip, this.hClip, false);
    }

    public void componentResized(ComponentEvent componentEvent) {
        NativeGraphics.getClippedGraphics(this, this.target, this.xOffset - this.xTarget, this.yOffset - this.yTarget, this.xClip, this.yClip, this.wClip, this.hClip, false);
    }

    public void componentShown(ComponentEvent componentEvent) {
        Toolkit.graSetVisible(this.nativeData, true);
    }

    public void copyArea(int n, int n2, int n3, int n4, int n5, int n6) {
        Toolkit.graCopyArea(this.nativeData, n, n2, n3, n4, n5, n6);
    }

    public Graphics create() {
        NativeGraphics nativeGraphics = NativeGraphics.getGraphics(this, this.nativeData, 2, this.xOffset, this.yOffset, this.xClip, this.yClip, this.wClip, this.hClip, this.fgClr, this.bgClr, this.font, false);
        if (this.xClr != null) {
            nativeGraphics.setXORMode(this.xClr);
        }
        return nativeGraphics;
    }

    public Graphics create(int n, int n2, int n3, int n4) {
        int n5 = n + n3;
        int n6 = n2 + n4;
        int n7 = this.xClip + this.wClip;
        int n8 = this.yClip + this.hClip;
        int n9 = n > this.xClip ? n : this.xClip;
        int n10 = n2 > this.yClip ? n2 : this.yClip;
        int n11 = (n5 > n7 ? n7 : n5) - n9;
        int n12 = (n6 > n8 ? n8 : n6) - n10;
        NativeGraphics nativeGraphics = NativeGraphics.getGraphics(this, this.nativeData, 2, n + this.xOffset, n2 + this.yOffset, n9 - n, n10 - n2, n11, n12, this.fgClr, this.bgClr, this.font, false);
        if (this.xClr != null) {
            nativeGraphics.setXORMode(this.xClr);
        }
        return nativeGraphics;
    }

    public void dispose() {
        if (this.bgClr == null) {
            return;
        }
        Object object = lock;
        synchronized (object) {
            try {
                this.xClr = null;
                this.font = null;
                this.fgClr = null;
                this.bgClr = null;
                if (this.target != null) {
                    Component component = this.target;
                    while (component != null) {
                        component.removeComponentListener(this);
                        component = component.parent;
                    }
                    this.target = null;
                }
                this.next = cache;
                cache = this;
                Object var4_3 = null;
            }
            catch (Throwable throwable) {
                Object var4_4 = null;
                throw throwable;
            }
        }
    }

    public void draw3DRect(int n, int n2, int n3, int n4, boolean bl) {
        Toolkit.graDraw3DRect(this.nativeData, n, n2, n3, n4, bl, this.fgClr.rgbValue);
    }

    public void drawArc(int n, int n2, int n3, int n4, int n5, int n6) {
        Toolkit.graDrawArc(this.nativeData, n, n2, n3, n4, n5, n6);
    }

    public void drawBytes(byte[] byArray, int n, int n2, int n3, int n4) {
        Toolkit.graDrawBytes(this.nativeData, byArray, n, n2, n3, n4);
    }

    public void drawChars(char[] cArray, int n, int n2, int n3, int n4) {
        Toolkit.graDrawChars(this.nativeData, cArray, n, n2, n3, n4);
    }

    public boolean drawImage(Image image, int n, int n2, Color color, ImageObserver imageObserver) {
        if (!image.loadImage(-1, -1, imageObserver)) {
            return false;
        }
        this.drawImg(image, n, n2, 0, 0, image.width, image.height, color);
        return true;
    }

    public boolean drawImage(Image image, int n, int n2, ImageObserver imageObserver) {
        if (!image.loadImage(-1, -1, imageObserver)) {
            return false;
        }
        this.drawImg(image, n, n2, 0, 0, image.width, image.height, null);
        return true;
    }

    public boolean drawImage(Image image, int n, int n2, int n3, int n4, Color color, ImageObserver imageObserver) {
        if (!image.loadImage(-1, -1, imageObserver)) {
            return false;
        }
        if (n3 < 0) {
            n3 = image.width;
            if (n4 < 0) {
                n4 = image.height;
            } else {
                n3 = n3 * n4 / image.height;
            }
        } else if (n4 < 0) {
            n4 = image.height * n3 / image.width;
        }
        if (image.width != n3 || image.height != n4) {
            this.drawImgScaled(image, n, n2, n + n3, n2 + n4, 0, 0, image.width, image.height, color);
        } else {
            this.drawImg(image, n, n2, 0, 0, n3, n4, color);
        }
        return true;
    }

    public boolean drawImage(Image image, int n, int n2, int n3, int n4, ImageObserver imageObserver) {
        return this.drawImage(image, n, n2, n3, n4, null, imageObserver);
    }

    public boolean drawImage(Image image, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, Color color, ImageObserver imageObserver) {
        if (!image.loadImage(-1, -1, imageObserver)) {
            return false;
        }
        if (n5 < 0 || n6 < 0 || n7 < 0 || n8 < 0) {
            return false;
        }
        this.drawImgScaled(image, n, n2, n3, n4, n5, n6, n7, n8, color);
        return true;
    }

    public boolean drawImage(Image image, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, ImageObserver imageObserver) {
        return this.drawImage(image, n, n2, n3, n4, n5, n6, n7, n8, null, imageObserver);
    }

    void drawImg(Image image, int n, int n2, int n3, int n4, int n5, int n6, Color color) {
        if ((image.flags & 0x800) != 0) {
            image.activateFrameLoader();
        }
        Toolkit.graDrawImage(this.nativeData, image.nativeData, n3, n4, n, n2, n5, n6, color == null ? -1 : color.nativeValue);
    }

    void drawImgScaled(Image image, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, Color color) {
        if (image.nativeData != null) {
            if ((image.flags & 0x800) != 0) {
                image.activateFrameLoader();
            }
            Toolkit.graDrawImageScaled(this.nativeData, image.nativeData, n, n2, n3, n4, n5, n6, n7, n8, color == null ? -1 : color.nativeValue);
        }
    }

    public void drawLine(int n, int n2, int n3, int n4) {
        Toolkit.graDrawLine(this.nativeData, n, n2, n3, n4);
    }

    public void drawOval(int n, int n2, int n3, int n4) {
        Toolkit.graDrawOval(this.nativeData, n, n2, n3, n4);
    }

    public void drawPolygon(Polygon polygon) {
        Toolkit.graDrawPolygon(this.nativeData, polygon.xpoints, polygon.ypoints, polygon.npoints);
    }

    public void drawPolygon(int[] nArray, int[] nArray2, int n) {
        Toolkit.graDrawPolygon(this.nativeData, nArray, nArray2, n);
    }

    public void drawPolyline(int[] nArray, int[] nArray2, int n) {
        Toolkit.graDrawPolyline(this.nativeData, nArray, nArray2, n);
    }

    public void drawRect(int n, int n2, int n3, int n4) {
        Toolkit.graDrawRect(this.nativeData, n, n2, n3, n4);
    }

    public void drawRoundRect(int n, int n2, int n3, int n4, int n5, int n6) {
        Toolkit.graDrawRoundRect(this.nativeData, n, n2, n3, n4, n5, n6);
    }

    public void drawString(String string, int n, int n2) {
        Toolkit.graDrawString(this.nativeData, string, n, n2);
    }

    public void fill3DRect(int n, int n2, int n3, int n4, boolean bl) {
        Toolkit.graFill3DRect(this.nativeData, n, n2, n3, n4, bl, this.fgClr.rgbValue);
    }

    public void fillArc(int n, int n2, int n3, int n4, int n5, int n6) {
        Toolkit.graFillArc(this.nativeData, n, n2, n3, n4, n5, n6);
    }

    public void fillOval(int n, int n2, int n3, int n4) {
        Toolkit.graFillOval(this.nativeData, n, n2, n3, n4);
    }

    public void fillPolygon(Polygon polygon) {
        Toolkit.graFillPolygon(this.nativeData, polygon.xpoints, polygon.ypoints, polygon.npoints);
    }

    public void fillPolygon(int[] nArray, int[] nArray2, int n) {
        Toolkit.graFillPolygon(this.nativeData, nArray, nArray2, n);
    }

    public void fillRect(int n, int n2, int n3, int n4) {
        Toolkit.graFillRect(this.nativeData, n, n2, n3, n4);
    }

    public void fillRoundRect(int n, int n2, int n3, int n4, int n5, int n6) {
        Toolkit.graFillRoundRect(this.nativeData, n, n2, n3, n4, n5, n6);
    }

    protected void finalize() throws Throwable {
        if (this.nativeData != null) {
            Toolkit.graFreeGraphics(this.nativeData);
            this.nativeData = null;
        }
        super.finalize();
    }

    Color getBackColor() {
        return this.bgClr;
    }

    public Shape getClip() {
        return this.getClipRect();
    }

    public Rectangle getClipBounds() {
        return new Rectangle(this.xClip, this.yClip, this.wClip, this.hClip);
    }

    int getClipHeight() {
        return this.hClip;
    }

    int getClipWidth() {
        return this.wClip;
    }

    int getClipX() {
        return this.xClip;
    }

    int getClipY() {
        return this.yClip;
    }

    static NativeGraphics getClippedGraphics(NativeGraphics nativeGraphics, Component component, int n, int n2, int n3, int n4, int n5, int n6, boolean bl) {
        Font font;
        Color color;
        Color color2;
        if ((component.flags & 0x400) == 0) {
            return null;
        }
        if (nativeGraphics == null) {
            color2 = component.fgClr;
            color = component.bgClr;
            font = component.font;
        } else {
            color2 = nativeGraphics.fgClr;
            color = nativeGraphics.bgClr;
            font = nativeGraphics.font;
        }
        while (true) {
            int n7;
            int n8;
            int n9;
            int n10;
            if (component.parent == null) {
                if ((Toolkit.flags & 0x10) != 0) {
                    n -= component.deco.x;
                    n2 -= component.deco.y;
                }
                if (nativeGraphics == null) {
                    return NativeGraphics.getGraphics(component, ((Window)component).nativeData, 0, n, n2, n3, n4, n5, n6, color2, color, font, bl);
                }
                Toolkit.graInitGraphics(nativeGraphics.nativeData, null, 0, n, n2, n3, n4, n5, n6, font.nativeData, color2.nativeValue, color.nativeValue, bl);
                return nativeGraphics;
            }
            n += component.x;
            n2 += component.y;
            Container container = component.parent;
            if (container.insets != Insets.noInsets) {
                Insets insets = container.insets;
                n10 = insets.left;
                n9 = insets.top;
                n8 = container.width - insets.right;
                n7 = container.height - insets.bottom;
            } else {
                n10 = 0;
                n9 = 0;
                n8 = container.width;
                n7 = container.height;
            }
            if (n + n3 < n10) {
                int n11 = n10 - n;
                n5 -= n11 - n3;
                n3 = n11;
            }
            if (n2 + n4 < n9) {
                int n12 = n9 - n2;
                n6 -= n12 - n4;
                n4 = n12;
            }
            int n13 = n3 + n5;
            int n14 = n4 + n6;
            int n15 = n + n13;
            int n16 = n2 + n14;
            if (n15 > n8) {
                n5 -= n15 - n8;
            }
            if (n16 > n7) {
                n6 -= n16 - n7;
            }
            component = container;
        }
    }

    public Color getColor() {
        return this.fgClr;
    }

    public Font getFont() {
        return this.font;
    }

    public FontMetrics getFontMetrics(Font font) {
        return FontMetrics.getFontMetrics(font);
    }

    static NativeGraphics getGraphics(Object object, Ptr ptr, int n, int n2, int n3, int n4, int n5, int n6, int n7, Color color, Color color2, Font font, boolean bl) {
        NativeGraphics nativeGraphics;
        if (ptr == null) {
            return null;
        }
        Object object2 = lock;
        synchronized (object2) {
            try {
                if (cache == null) {
                    nativeGraphics = new NativeGraphics();
                } else {
                    nativeGraphics = cache;
                    cache = nativeGraphics.next;
                    nativeGraphics.next = null;
                }
                Object var16_15 = null;
            }
            catch (Throwable throwable) {
                Object var16_16 = null;
                throw throwable;
            }
        }
        nativeGraphics.xOffset = n2;
        nativeGraphics.yOffset = n3;
        nativeGraphics.xClip = n4;
        nativeGraphics.yClip = n5;
        nativeGraphics.wClip = n6;
        nativeGraphics.hClip = n7;
        nativeGraphics.font = font;
        nativeGraphics.fgClr = color;
        nativeGraphics.bgClr = color2;
        nativeGraphics.nativeData = Toolkit.graInitGraphics(nativeGraphics.nativeData, ptr, n, n2, n3, n4, n5, n6, n7, font.nativeData, color.nativeValue, color2.nativeValue, bl);
        return nativeGraphics;
    }

    void paintChild(Component component, boolean bl) {
        int n = component.x + component.width;
        int n2 = component.y + component.height;
        int n3 = this.xClip + this.wClip;
        int n4 = this.yClip + this.hClip;
        if (this.xClip > n || this.yClip > n2 || component.x > n3 || component.y > n4) {
            return;
        }
        int n5 = component.x > this.xClip ? component.x : this.xClip;
        int n6 = component.y > this.yClip ? component.y : this.yClip;
        int n7 = (n > n3 ? n3 : n) - n5;
        int n8 = (n2 > n4 ? n4 : n2) - n6;
        n5 -= component.x;
        n6 -= component.y;
        if ((component.flags & 0x100) != 0) {
            Toolkit.eventQueue.repaint(800, component, n5, n6, n7, n8);
        } else {
            NativeGraphics nativeGraphics = NativeGraphics.getGraphics(this, this.nativeData, 2, component.x + this.xOffset, component.y + this.yOffset, n5, n6, n7, n8, component.fgClr, component.bgClr, component.font, false);
            if (nativeGraphics != null) {
                if (bl) {
                    component.update(nativeGraphics);
                } else {
                    component.paint(nativeGraphics);
                }
                nativeGraphics.dispose();
            }
        }
        component.flags &= 0xFFFF7FFF;
    }

    void setBackColor(Color color) {
        if (color != null && color != this.bgClr) {
            this.bgClr = color;
            Toolkit.graSetBackColor(this.nativeData, this.bgClr.nativeValue);
        }
    }

    public void setClip(Shape shape) {
        Rectangle rectangle = shape.getBounds();
        this.setClip(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
    }

    public void setClip(int n, int n2, int n3, int n4) {
        this.xClip = n;
        this.yClip = n2;
        this.wClip = n3;
        this.hClip = n4;
        Toolkit.graSetClip(this.nativeData, n, n2, n3, n4);
    }

    public void setColor(Color color) {
        if (color != null && color != this.fgClr) {
            this.fgClr = color;
            Toolkit.graSetColor(this.nativeData, this.fgClr.nativeValue);
        }
    }

    public void setFont(Font font) {
        if (font != null && font != this.font) {
            this.font = font;
            Toolkit.graSetFont(this.nativeData, this.font.nativeData);
        }
    }

    void setGraphics(Ptr ptr, int n, int n2, int n3, int n4, int n5, int n6, int n7, Color color, Color color2, Font font, boolean bl) {
        this.xOffset = n2;
        this.yOffset = n3;
        this.xClip = n4;
        this.yClip = n5;
        this.wClip = n6;
        this.hClip = n7;
        if (font != null) {
            this.font = font;
        }
        if (color != null) {
            this.fgClr = color;
        }
        if (color2 != null) {
            this.bgClr = color2;
        }
        this.nativeData = Toolkit.graInitGraphics(this.nativeData, ptr, n, n2, n3, n4, n5, n6, n7, this.font.nativeData, this.fgClr.nativeValue, this.bgClr.nativeValue, bl);
    }

    public void setPaintMode() {
        if (this.xClr != null) {
            this.xClr = null;
            Toolkit.graSetPaintMode(this.nativeData);
        }
    }

    void setTarget(Component component) {
        this.target = component;
        Component component2 = component;
        while (component2 != null) {
            component2.addComponentListener(this);
            component2 = component2.parent;
        }
        this.xTarget = this.xOffset;
        this.yTarget = this.yOffset;
        if ((this.target.flags & 1) == 0) {
            Toolkit.graSetVisible(this.nativeData, false);
        }
    }

    public void setXORMode(Color color) {
        if (color != this.xClr) {
            this.xClr = color;
            Toolkit.graSetXORMode(this.nativeData, this.xClr.nativeValue);
        }
    }

    public String toString() {
        return String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(this.getClass().getName()).concat(String.valueOf(" ["))).concat(String.valueOf(this.xOffset))).concat(String.valueOf(','))).concat(String.valueOf(this.yOffset))).concat(String.valueOf(" clip:"))).concat(String.valueOf(this.xClip))).concat(String.valueOf(','))).concat(String.valueOf(this.yClip))).concat(String.valueOf(' '))).concat(String.valueOf(this.wClip))).concat(String.valueOf(','))).concat(String.valueOf(this.hClip))).concat(String.valueOf(']'));
    }

    public void translate(int n, int n2) {
        this.xOffset += n;
        this.yOffset += n2;
        this.xClip -= n;
        this.yClip -= n2;
        Toolkit.graSetOffset(this.nativeData, this.xOffset, this.yOffset);
    }

    NativeGraphics() {
    }

    static {
        lock = new Object();
    }
}

