/*
 * Decompiled with CFR 0.152.
 */
package java.awt;

import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.Defaults;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.NativeGraphics;
import java.awt.Scrollbar;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.util.Vector;

class RowCanvas
extends Component
implements AdjustmentListener,
FocusListener,
ComponentListener {
    Scrollbar hScroll;
    Scrollbar vScroll;
    int rowHeight;
    Vector rows = new Vector();
    int first;
    int xOffs;
    int xOffsInit;
    FontMetrics fm;
    int initVis = -1;
    NativeGraphics rgr;

    public void addNotify() {
        super.addNotify();
        if (this.rgr == null) {
            this.setResGraphics();
            Component component = this;
            while (component != null) {
                component.addComponentListener(this);
                component = component.parent;
            }
        }
    }

    public void adjustmentValueChanged(AdjustmentEvent adjustmentEvent) {
        int n;
        Object object = adjustmentEvent.getSource();
        if (object == this.vScroll) {
            int n2 = adjustmentEvent.getValue();
            int n3 = this.first;
            if (n2 != this.first) {
                this.first = n2;
                this.shiftVertical(n3 - n2, false);
                this.vPosChange(n3 - n2);
            }
        } else if (object == this.hScroll && (n = -adjustmentEvent.getValue()) != this.xOffs + this.xOffsInit) {
            this.xOffs = n + this.xOffsInit;
            this.hPosChange();
        }
    }

    public void componentHidden(ComponentEvent componentEvent) {
    }

    public void componentMoved(ComponentEvent componentEvent) {
        this.setResGraphics();
    }

    public void componentResized(ComponentEvent componentEvent) {
        this.setResGraphics();
    }

    public void componentShown(ComponentEvent componentEvent) {
    }

    public void focusGained(FocusEvent focusEvent) {
        this.paintBorder();
        if (Defaults.FocusScrolls) {
            if (this.hScroll != null) {
                this.hScroll.setBackground(Defaults.FocusClr);
            }
            if (this.vScroll != null) {
                this.vScroll.setBackground(Defaults.FocusClr);
            }
        }
        this.redirectFocusEvent(focusEvent);
    }

    public void focusLost(FocusEvent focusEvent) {
        this.paintBorder();
        if (Defaults.FocusScrolls) {
            if (this.hScroll != null) {
                this.hScroll.setBackground(Defaults.BtnClr);
            }
            if (this.vScroll != null) {
                this.vScroll.setBackground(Defaults.BtnClr);
            }
        }
        this.redirectFocusEvent(focusEvent);
    }

    int getRowIdx(int n) {
        int n2;
        int n3 = 2;
        if (n < 2) {
            for (int i = this.first - 1; i >= 0; --i) {
                if ((n3 -= this.rowHeight) >= n) continue;
                return i;
            }
            return 0;
        }
        int n4 = this.rows.size();
        for (n2 = this.first; n2 < n4 - 1 && (n3 += this.rowHeight) <= n; ++n2) {
        }
        return n2;
    }

    int getRowYPos(int n) {
        return 2 + (n - this.first) * this.rowHeight;
    }

    int getVisibleRows() {
        return (this.height - 4) / this.rowHeight;
    }

    void hPosChange() {
        this.repaint();
    }

    void innerLayout() {
        int n = this.parent.width;
        int n2 = this.parent.height;
        int n3 = Scrollbar.SCROLLBAR_WIDTH;
        boolean bl = this.vScroll != null && this.vScroll.isSliderShowing();
        boolean bl2 = this.hScroll != null && this.hScroll.isSliderShowing();
        this.setBounds(0, 0, bl ? n - n3 : n, bl2 ? n2 - n3 : n2);
        if (this.vScroll != null) {
            if (this.vScroll.isVisible() && !bl) {
                this.vScroll.setVisible(false);
            } else if (!this.vScroll.isVisible() && bl) {
                this.vScroll.setVisible(true);
            }
            this.vScroll.setBounds(n - n3, 0, n3, bl2 ? n2 - n3 : n2);
        }
        if (this.hScroll != null) {
            if (this.hScroll.isVisible() && !bl2) {
                this.hScroll.setVisible(false);
            } else if (!this.hScroll.isVisible() && bl2) {
                this.hScroll.setVisible(true);
            }
            this.hScroll.setBounds(0, n2 - n3, bl ? n - n3 : n, n3);
        }
        this.updateVScroll();
        if (this.initVis > -1) {
            this.makeVisible(this.initVis);
            this.initVis = -1;
        }
    }

    void makeVisible(int n) {
        int n2 = this.getVisibleRows();
        int n3 = this.rows.size();
        int n4 = n3 - n2;
        if (this.height == 0) {
            this.initVis = n;
            return;
        }
        if (n >= this.first && n < this.first + n2) {
            return;
        }
        if (n < 0) {
            n = 0;
        } else if (n >= n3) {
            n = n3 - 1;
        }
        int n5 = this.first;
        if (n < this.first) {
            this.first = n;
            this.shiftVertical(n5 - this.first, true);
        } else if (n > this.first + n2 - 1) {
            this.first = n - n2 + 1;
            this.shiftVertical(n5 - this.first, true);
        }
    }

    void paintBorder() {
        Graphics graphics = super.getGraphics();
        if (graphics != null) {
            this.paintBorder(graphics);
            graphics.dispose();
        }
    }

    void redirectFocusEvent(FocusEvent focusEvent) {
        if (this.parent.focusListener != null) {
            AWTEvent.setSource(focusEvent, this.parent);
            this.parent.process(focusEvent);
        }
    }

    void redirectKeyEvent(KeyEvent keyEvent) {
        if (this.parent.keyListener != null) {
            AWTEvent.setSource(keyEvent, this.parent);
            this.parent.process(keyEvent);
        }
    }

    void redirectMotionEvent(MouseEvent mouseEvent) {
        if (this.parent.motionListener != null) {
            mouseEvent.retarget(this.parent, this.x, this.y);
            this.parent.process(mouseEvent);
            mouseEvent.retarget(this, -this.x, -this.y);
        }
    }

    void redirectMouseEvent(MouseEvent mouseEvent) {
        if (this.parent.mouseListener != null) {
            mouseEvent.retarget(this.parent, this.x, this.y);
            this.parent.process(mouseEvent);
            mouseEvent.retarget(this, -this.x, -this.y);
        }
    }

    public void removeNotify() {
        super.removeNotify();
        if (this.rgr != null) {
            Component component = this;
            while (component != null) {
                component.removeComponentListener(this);
                component = component.parent;
            }
            this.rgr.dispose();
            this.rgr = null;
        }
    }

    void repaintRow(Graphics graphics, int n) {
    }

    void repaintRow(int n) {
        if (this.rgr != null) {
            this.repaintRow(this.rgr, n);
        }
    }

    int repaintRows(Graphics graphics, int n, int n2) {
        int n3;
        if (graphics == null) {
            return 0;
        }
        int n4 = this.rows.size();
        int n5 = n3 = 2;
        for (int i = this.first; i < n4; ++i) {
            if (i >= n && i <= n + n2) {
                this.repaintRow(graphics, i);
            }
            if ((n5 += this.rowHeight) > this.height) break;
        }
        if (n5 < this.height) {
            graphics.setColor(this.getBackground());
            graphics.fillRect(n3, n5, this.width - 2 * n3, this.height - n5 - n3);
        }
        return n5;
    }

    int repaintRows(int n, int n2) {
        if (this.rgr != null) {
            return this.repaintRows(this.rgr, n, n2);
        }
        return 0;
    }

    void setListeners() {
        if (this.hScroll != null) {
            this.hScroll.addAdjustmentListener(this);
        }
        if (this.vScroll != null) {
            this.vScroll.addAdjustmentListener(this);
        }
        this.addFocusListener(this);
    }

    void setResGraphics() {
        this.rgr = NativeGraphics.getClippedGraphics(this.rgr, this, 0, 0, 2, 2, this.width - 4, this.height - 4, false);
    }

    void shiftVertical(int n, boolean bl) {
        if (n == 0) {
            return;
        }
        if (bl && this.vScroll != null) {
            this.vScroll.setValues(this.first, this.vScroll.vis, this.vScroll.min, this.vScroll.max, false);
        }
        int n2 = 2;
        int n3 = n2 * 2;
        int n4 = n * this.rowHeight;
        if (n < 0) {
            this.rgr.copyArea(n2, n2 - n4, this.width - n3, this.height - n3 + n4 - 1, 0, n4);
            int n5 = this.first + this.getVisibleRows() + n;
            int n6 = -n + 1;
            this.repaintRows(n5, n6);
        } else {
            this.rgr.copyArea(n2, n2, this.width - n3, this.height - n3 - n4 - 1, 0, n4);
            this.repaintRows(this.first, n - 1);
        }
    }

    public void update(Graphics graphics) {
        this.paint(graphics);
    }

    void updateVScroll() {
        boolean bl = false;
        boolean bl2 = false;
        if (this.vScroll != null) {
            bl = this.vScroll.isSliderShowing();
            int n = this.getVisibleRows();
            this.vScroll.setValues(this.first, n, 0, this.rows.size(), false);
            bl2 = this.vScroll.isSliderShowing();
        }
        if (bl != bl2) {
            Graphics graphics = this.parent.getGraphics();
            if (graphics != null) {
                graphics.setColor(this.parent.bgClr);
                graphics.fillRect(0, 0, this.parent.width, this.parent.height);
                graphics.dispose();
            }
            this.innerLayout();
        }
    }

    void vPosChange(int n) {
    }

    RowCanvas() {
    }
}

