/*
 * Decompiled with CFR 0.152.
 */
package java.awt.image;

import java.awt.image.ColorModel;
import java.awt.image.ImageFilter;
import java.awt.image.IndexColorModel;

public abstract class RGBImageFilter
extends ImageFilter {
    protected ColorModel origmodel;
    protected ColorModel newmodel;
    protected boolean canFilterIndexColorModel;

    public IndexColorModel filterIndexColorModel(IndexColorModel indexColorModel) {
        int n = indexColorModel.getTransparentPixel();
        int n2 = indexColorModel.getMapSize();
        int n3 = n;
        int[] nArray = new int[n2];
        for (int i = 0; i < n2; ++i) {
            byte by;
            int n4 = this.filterRGB(-1, -1, indexColorModel.rgbs[i]);
            if (n3 == n && i != n && (by = (byte)(n4 >> 24)) != 255) {
                n3 = -1;
            }
            nArray[i] = n4;
        }
        return new IndexColorModel(indexColorModel.getPixelSize(), nArray, n3);
    }

    public abstract int filterRGB(int var1, int var2, int var3);

    public void filterRGBPixels(int n, int n2, int n3, int n4, int[] nArray, int n5, int n6) {
        int n7 = n + n3;
        int n8 = n2 + n4;
        for (int i = n2; i < n8; ++i) {
            for (int j = n; j < n7; ++j) {
                int n9 = j + i * n6 + n5;
                nArray[n9] = this.filterRGB(j, i, nArray[n9]);
            }
        }
        this.consumer.setPixels(n, n2, n3, n4, ColorModel.getRGBdefault(), nArray, n5, n6);
    }

    public void setColorModel(ColorModel colorModel) {
        ColorModel colorModel2 = ColorModel.getRGBdefault();
        if (colorModel instanceof IndexColorModel && this.canFilterIndexColorModel) {
            colorModel2 = this.filterIndexColorModel((IndexColorModel)colorModel);
            this.substituteColorModel(colorModel, colorModel2);
        }
        this.consumer.setColorModel(colorModel2);
    }

    public void setPixels(int n, int n2, int n3, int n4, ColorModel colorModel, byte[] byArray, int n5, int n6) {
        if (colorModel == this.origmodel) {
            this.consumer.setPixels(n, n2, n3, n4, this.newmodel, byArray, n5, n6);
        } else {
            int n7 = n + n3;
            int n8 = n2 + n4;
            int[] nArray = new int[byArray.length];
            for (int i = n2; i < n8; ++i) {
                for (int j = n; j < n7; ++j) {
                    int n9 = j + i * n6 + n5;
                    nArray[n9] = colorModel.getRGB(byArray[n9]);
                }
            }
            this.filterRGBPixels(n, n2, n3, n4, nArray, 0, n3);
        }
    }

    public void setPixels(int n, int n2, int n3, int n4, ColorModel colorModel, int[] nArray, int n5, int n6) {
        if (colorModel == this.origmodel) {
            this.consumer.setPixels(n, n2, n3, n4, this.newmodel, nArray, n5, n6);
        } else {
            int n7 = n + n3;
            int n8 = n2 + n4;
            int[] nArray2 = new int[nArray.length];
            for (int i = n2; i < n8; ++i) {
                for (int j = n; j < n7; ++j) {
                    int n9 = j + i * n6 + n5;
                    nArray2[n9] = colorModel.getRGB(nArray[n9]);
                }
            }
            this.filterRGBPixels(n, n2, n3, n4, nArray2, 0, n3);
        }
    }

    public void substituteColorModel(ColorModel colorModel, ColorModel colorModel2) {
        this.origmodel = colorModel;
        this.newmodel = colorModel2;
    }
}

