/*
 * Decompiled with CFR 0.152.
 */
package java.io;

import java.io.IOException;
import java.io.Reader;

public class BufferedReader
extends Reader {
    private static final int DEFAULTBUFFERSIZE = 1024;
    private Reader rd;
    private char[] inbuf;
    private int pos;
    private int size;
    private boolean markset;

    public BufferedReader(Reader reader) {
        this(reader, 1024);
    }

    public BufferedReader(Reader reader, int n) {
        this.rd = reader;
        this.inbuf = new char[n];
        this.pos = 0;
        this.size = 0;
        this.markset = false;
    }

    public void close() throws IOException {
        this.rd.close();
    }

    public void mark(int n) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            try {
                char[] cArray = this.inbuf;
                if (n > this.inbuf.length) {
                    this.inbuf = new char[n];
                }
                System.arraycopy(cArray, this.pos, this.inbuf, 0, this.size - this.pos);
                this.size -= this.pos;
                this.pos = 0;
                this.markset = true;
                Object var5_4 = null;
            }
            catch (Throwable throwable) {
                Object var5_5 = null;
                throw throwable;
            }
        }
    }

    public boolean markSupported() {
        return true;
    }

    void pushback() {
        --this.pos;
    }

    public int read() throws IOException {
        if (this.pos < this.size || this.refillBuffer() > 0) {
            return this.inbuf[this.pos++];
        }
        return -1;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int read(char[] cArray, int n, int n2) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            try {
                if (this.pos == this.size && !this.markset && n2 >= this.inbuf.length) {
                    return this.rd.read(cArray, n, n2);
                }
                int n3 = 0;
                while (n3 < n2) {
                    int n4;
                    if (this.pos == this.size) {
                        if (n3 > 0 && !this.rd.ready()) {
                            return n3;
                        }
                        if (this.refillBuffer() <= 0) {
                            if (n3 <= 0) return -1;
                            int n5 = n3;
                            return n5;
                        }
                    }
                    if ((n4 = n2 - n3) > this.size) {
                        n4 = this.size;
                    }
                    System.arraycopy(this.inbuf, this.pos, cArray, n, n4);
                    this.pos += n4;
                    n += n4;
                    n3 += n4;
                }
                return n3;
            }
            catch (Throwable throwable) {
                Object var9_11 = null;
                throw throwable;
            }
        }
    }

    public String readLine() throws IOException {
        int n = this.pos;
        int n2 = 32;
        String string = null;
        Object object = this.lock;
        synchronized (object) {
            String string2;
            try {
                while (true) {
                    if (this.pos < this.size && (n2 = this.inbuf[this.pos]) != 10 && n2 != 13) {
                        ++this.pos;
                        continue;
                    }
                    if (this.pos != this.size) break;
                    if (this.pos > n) {
                        string = string == null ? new String(this.inbuf, n, this.pos - n) : String.valueOf(string).concat(String.valueOf(new String(this.inbuf, n, this.pos - n)));
                    }
                    if (this.refillBuffer() <= 0) {
                        String string3 = string;
                        Object var7_7 = null;
                        return string3;
                    }
                    n = 0;
                }
                string = string == null ? new String(this.inbuf, n, this.pos - n) : String.valueOf(string).concat(String.valueOf(new String(this.inbuf, n, this.pos - n)));
                ++this.pos;
                if (n2 == 13 && this.read() != 10 && this.pos > 0) {
                    --this.pos;
                }
                string2 = string;
            }
            catch (Throwable throwable) {
                Object var7_9 = null;
                throw throwable;
            }
            Object var7_8 = null;
            return string2;
        }
    }

    public boolean ready() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            try {
                boolean bl = this.pos < this.size || this.rd.ready();
                Object var4_3 = null;
                return bl;
            }
            catch (Throwable throwable) {
                Object var4_4 = null;
                throw throwable;
            }
        }
    }

    private int refillBuffer() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            int n;
            try {
                int n2 = this.rd.read(this.inbuf, 0, this.inbuf.length);
                this.pos = 0;
                this.markset = false;
                if (n2 > 0) {
                    this.size = n2;
                    int n3 = n2;
                    Object var5_5 = null;
                    return n3;
                }
                this.size = 0;
                n = -1;
            }
            catch (Throwable throwable) {
                Object var5_7 = null;
                throw throwable;
            }
            Object var5_6 = null;
            return n;
        }
    }

    public void reset() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            try {
                if (!this.markset) {
                    throw new IOException("invalid mark");
                }
                this.pos = 0;
                Object var3_2 = null;
            }
            catch (Throwable throwable) {
                Object var3_3 = null;
                throw throwable;
            }
        }
    }

    public long skip(long l) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            long l2;
            try {
                long l3 = this.size - this.pos;
                if (l3 > l) {
                    l3 = l;
                }
                this.pos += (int)l3;
                if (l3 == l) {
                    long l4 = l;
                    Object var9_6 = null;
                    return l4;
                }
                this.pos = 0;
                this.size = 0;
                this.markset = false;
                l2 = l3 + this.rd.skip(l - l3);
            }
            catch (Throwable throwable) {
                Object var9_8 = null;
                throw throwable;
            }
            Object var9_7 = null;
            return l2;
        }
    }
}

