/*
 * Decompiled with CFR 0.152.
 */
package java.io;

import java.io.IOException;
import java.io.InputStream;
import java.io.PipedOutputStream;

public class PipedInputStream
extends InputStream {
    PipedOutputStream src = null;
    protected static final int PIPE_SIZE = 512;
    protected byte[] buffer = new byte[512];
    protected int out = 0;
    protected int in = 0;
    private boolean closed = true;
    private boolean finished = true;

    public PipedInputStream() {
    }

    public PipedInputStream(PipedOutputStream pipedOutputStream) throws IOException {
        this.connect(pipedOutputStream);
    }

    public int available() throws IOException {
        return this.in >= this.out ? this.in - this.out : 512 + this.out - this.in;
    }

    public void close() throws IOException {
        this.out = 0;
        this.in = 0;
        this.closed = true;
    }

    public void connect(PipedOutputStream pipedOutputStream) throws IOException {
        if (this.src != null) {
            throw new IOException("already connected");
        }
        this.src = pipedOutputStream;
        if (pipedOutputStream.sink == null) {
            pipedOutputStream.connect(this);
        }
        this.closed = false;
        this.finished = false;
    }

    public synchronized int read() throws IOException {
        if (this.closed) {
            throw new IOException("stream closed");
        }
        if (this.finished && this.out == this.in) {
            return -1;
        }
        while (this.out == this.in) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (!this.finished || this.out != this.in) continue;
            return -1;
        }
        byte by = this.buffer[this.out];
        this.out = (this.out + 1) % 512;
        this.notifyAll();
        return by & 0xFF;
    }

    public synchronized int read(byte[] byArray, int n, int n2) throws IOException {
        return super.read(byArray, n, n2);
    }

    protected synchronized void receive(int n) throws IOException {
        while (this.out == (this.in + 1) % 512) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {}
        }
        this.buffer[this.in] = (byte)n;
        this.in = (this.in + 1) % 512;
        this.notifyAll();
    }

    void receivedLast() {
        this.finished = true;
    }
}

