/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

import java.io.Serializable;

public final class Character
implements Serializable {
    public static final int MIN_RADIX = 2;
    public static final int MAX_RADIX = 36;
    public static final char MIN_VALUE = '\u0000';
    public static final char MAX_VALUE = '\uffff';
    public static final byte UNASSIGNED = 0;
    public static final byte UPPERCASE_LETTER = 1;
    public static final byte LOWERCASE_LETTER = 2;
    public static final byte TITLECASE_LETTER = 3;
    public static final byte MODIFIER_LETTER = 4;
    public static final byte OTHER_LETTER = 5;
    public static final byte NON_SPACING_MARK = 6;
    public static final byte ENCLOSING_MARK = 7;
    public static final byte COMBINING_SPACING_MARK = 8;
    public static final byte DECIMAL_DIGIT_NUMBER = 9;
    public static final byte LETTER_NUMBER = 10;
    public static final byte OTHER_NUMBER = 11;
    public static final byte SPACE_SEPARATOR = 12;
    public static final byte LINE_SEPARATOR = 13;
    public static final byte PARAGRAPH_SEPARATOR = 14;
    public static final byte CONTROL = 15;
    public static final byte FORMAT = 16;
    public static final byte PRIVATE_USE = 18;
    public static final byte SURROGATE = 19;
    public static final byte DASH_PUNCTUATION = 20;
    public static final byte START_PUNCTUATION = 21;
    public static final byte END_PUNCTUATION = 22;
    public static final byte CONNECTOR_PUNCTUATION = 23;
    public static final byte OTHER_PUNCTUATION = 24;
    public static final byte MATH_SYMBOL = 25;
    public static final byte CURRENCY_SYMBOL = 26;
    public static final byte MODIFIER_SYMBOL = 27;
    public static final byte OTHER_SYMBOL = 28;
    public static final Class TYPE = Class.getPrimitiveClass("char");
    private final char value;
    private static final long serialVersionUID = 3786198910865385080L;

    public Character(char c) {
        this.value = c;
    }

    public char charValue() {
        return this.value;
    }

    public int hashCode() {
        return this.value;
    }

    public boolean equals(Object object) {
        return object != null && object instanceof Character && ((Character)object).value == this.value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static boolean isSpace(char c) {
        switch (c) {
            case '\t': 
            case '\n': 
            case '\f': 
            case '\r': 
            case ' ': {
                return true;
            }
        }
        return false;
    }

    public static boolean isLetterOrDigit(char c) {
        return Character.isLetter(c) || Character.isDigit(c);
    }

    public static boolean isJavaLetter(char c) {
        return c == '$' || c == '_' || Character.isLetter(c);
    }

    public static boolean isJavaLetterOrDigit(char c) {
        return c == '$' || c == '_' || Character.isLetterOrDigit(c);
    }

    public static boolean isTitleCase(char c) {
        switch (Character.getType(c)) {
            case 3: {
                return true;
            }
        }
        return false;
    }

    public static boolean isDefined(char c) {
        return Character.getType(c) != 0;
    }

    public static boolean isIdentifierIgnorable(char c) {
        return c >= '\u0000' && c <= '\b' || c >= '\u000e' && c <= '\u001b' || c >= '\u007f' && c <= '\u009f' || c >= '\u200c' && c <= '\u200f' || c >= '\u202a' && c <= '\u202e' || c >= '\u206a' && c <= '\u206f' || c == '\ufeff';
    }

    public static boolean isLowerCase(char c) {
        switch (Character.getType(c)) {
            case 2: {
                return true;
            }
        }
        return false;
    }

    public static boolean isUpperCase(char c) {
        switch (Character.getType(c)) {
            case 1: {
                return true;
            }
        }
        return false;
    }

    public static boolean isDigit(char c) {
        return Character.getType(c) == 9;
    }

    public static boolean isLetter(char c) {
        switch (Character.getType(c)) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                return true;
            }
        }
        return false;
    }

    public static char toLowerCase(char c) {
        CharacterProperties characterProperties = Character.getCharProp(c);
        if (characterProperties.lower != '\u0000') {
            return characterProperties.lower;
        }
        return c;
    }

    public static char toUpperCase(char c) {
        CharacterProperties characterProperties = Character.getCharProp(c);
        if (characterProperties.upper != '\u0000') {
            return characterProperties.upper;
        }
        return c;
    }

    public static char toTitleCase(char c) {
        CharacterProperties characterProperties = Character.getCharProp(c);
        if (characterProperties.title != '\u0000') {
            return characterProperties.title;
        }
        return c;
    }

    public static int digit(char c, int n) {
        if (n < 2 || n > 36) {
            return -1;
        }
        int n2 = n;
        if (Character.isDigit(c)) {
            n2 = Character.getNumericValue(c);
            if (n2 < 0) {
                return -1;
            }
        } else if ('A' <= c && c <= 'Z') {
            n2 = c - 55;
        } else if ('a' <= c && c <= 'z') {
            n2 = c - 87;
        }
        return n2 < n ? n2 : -1;
    }

    public static char forDigit(int n, int n2) {
        if (n2 < 2 || n2 > 36) {
            return '\u0000';
        }
        if (n < 0 || n >= n2) {
            return '\u0000';
        }
        if (n < 10) {
            return (char)(48 + n);
        }
        return (char)(97 + (n - 10));
    }

    public static int getNumericValue(char c) {
        return Character.getCharProp((char)c).numeric;
    }

    public static int getType(char c) {
        return Character.getCharProp((char)c).category;
    }

    public static boolean isISOControl(char c) {
        if (c < ' ') {
            return true;
        }
        if (c < '\u007f') {
            return false;
        }
        return c < '\u00a0';
    }

    public static boolean isJavaIdentifierPart(char c) {
        switch (Character.getType(c)) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 23: 
            case 26: {
                return true;
            }
        }
        return Character.isIdentifierIgnorable(c);
    }

    public static boolean isJavaIdentifierStart(char c) {
        switch (Character.getType(c)) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 23: 
            case 26: {
                return true;
            }
        }
        return false;
    }

    public static boolean isSpaceChar(char c) {
        switch (Character.getType(c)) {
            case 12: 
            case 13: 
            case 14: {
                return true;
            }
        }
        return false;
    }

    public static boolean isUnicodeIdentifierPart(char c) {
        switch (Character.getType(c)) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 23: {
                return true;
            }
        }
        return Character.isIdentifierIgnorable(c);
    }

    public static boolean isUnicodeIdentifierStart(char c) {
        return Character.isLetter(c);
    }

    public static boolean isWhitespace(char c) {
        switch (c) {
            case '\t': 
            case '\n': 
            case '\u000b': 
            case '\f': 
            case '\r': 
            case '\u001c': 
            case '\u001d': 
            case '\u001e': 
            case '\u001f': {
                return true;
            }
        }
        switch (Character.getType(c)) {
            case 12: {
                return !Character.getCharProp((char)c).noBreak;
            }
            case 13: 
            case 14: {
                return true;
            }
        }
        return false;
    }

    private static CharacterProperties getCharProp(char c) {
        CharacterProperties characterProperties = CharacterProperties.cached;
        if (characterProperties.unicode == c) {
            return characterProperties;
        }
        int n = CharacterProperties.getIndex(c);
        characterProperties = n < 0 ? new CharacterProperties(c, 0, false, -1, '\u0000', '\u0000', '\u0000') : CharacterProperties.decodeProp(c, n);
        CharacterProperties.cached = characterProperties;
        return characterProperties;
    }

    private static class CharacterProperties {
        char unicode;
        int category;
        boolean noBreak;
        short numeric;
        char upper;
        char lower;
        char title;
        static CharacterProperties cached = new CharacterProperties('\u0000', 15, false, -1, '\u0000', '\u0000', '\u0000');
        private static byte[] propTable = ClassLoader.getSystemResourceAsBytes0("kaffe/lang/unicode.tbl");
        private static char[] rangeStart;
        private static char[] rangeEnd;
        private static int[] rangeOffset;

        CharacterProperties(char c, int n, boolean bl, short s, char c2, char c3, char c4) {
            this.unicode = c;
            this.category = n;
            this.noBreak = bl;
            this.numeric = s;
            this.upper = c2;
            this.lower = c3;
            this.title = c4;
            cached = this;
        }

        private static int getIndex(char c) {
            char[] cArray = rangeStart;
            char[] cArray2 = rangeEnd;
            int n = 0;
            int n2 = cArray.length - 1;
            while (n <= n2) {
                int n3 = n + n2 >> 1;
                if (c < cArray[n3]) {
                    n2 = n3 - 1;
                    continue;
                }
                if (c > cArray2[n3]) {
                    n = n3 + 1;
                    continue;
                }
                return n3;
            }
            return -1;
        }

        private static CharacterProperties decodeProp(char c, int n) {
            byte[] byArray = propTable;
            byte by = (byte)(rangeOffset[n] >> 20 & 3);
            int n2 = rangeOffset[n] & 0xFFFFF;
            if (by == 0) {
                n2 += 3 * (c - rangeStart[n]);
            } else if (by == 3) {
                n2 += 9 * (c - rangeStart[n]);
            }
            boolean bl = false;
            int n3 = byArray[n2] & 0x1F;
            if (n3 == 31) {
                n3 = 12;
                bl = true;
            }
            if (by < 3) {
                char c2 = (char)(((byArray[n2 + 1] & 0xFF) << 8) + (byArray[n2 + 2] & 0xFF));
                if (by == 2) {
                    c2 = (char)(c2 + (short)(0xFFFF & c - rangeStart[n]));
                }
                switch (byArray[n2] >> 5 & 3) {
                    case 0: {
                        return new CharacterProperties(c, n3, bl, -1, '\u0000', '\u0000', '\u0000');
                    }
                    case 1: {
                        return new CharacterProperties(c, n3, bl, -1, c2, '\u0000', c2);
                    }
                    case 2: {
                        return new CharacterProperties(c, n3, bl, -1, '\u0000', c2, '\u0000');
                    }
                }
                return new CharacterProperties(c, n3, bl, (short)c2, '\u0000', '\u0000', '\u0000');
            }
            short s = (short)(((byArray[n2 + 1] & 0xFF) << 8) + (byArray[n2 + 2] & 0xFF));
            char c3 = (char)(((byArray[n2 + 3] & 0xFF) << 8) + (byArray[n2 + 4] & 0xFF));
            char c4 = (char)(((byArray[n2 + 5] & 0xFF) << 8) + (byArray[n2 + 6] & 0xFF));
            char c5 = (char)(((byArray[n2 + 7] & 0xFF) << 8) + (byArray[n2 + 8] & 0xFF));
            return new CharacterProperties(c, n3, bl, s, c3, c4, c5);
        }

        static {
            if (propTable == null) {
                throw new Error("Missing Kaffe Unicode Database table");
            }
            byte[] byArray = ClassLoader.getSystemResourceAsBytes0("kaffe/lang/unicode.idx");
            if (byArray == null) {
                throw new Error("Missing Kaffe Unicode Database index");
            }
            if (byArray.length % 7 != 0) {
                throw new Error("Corrupted Kaffe Unicode Database");
            }
            int n = byArray.length / 7;
            rangeStart = new char[n];
            rangeEnd = new char[n];
            rangeOffset = new int[n];
            int n2 = 0;
            int n3 = 0;
            while (n2 < n) {
                CharacterProperties.rangeStart[n2] = (char)(((byArray[n3] & 0xFF) << 8) + (byArray[n3 + 1] & 0xFF));
                CharacterProperties.rangeEnd[n2] = (char)(((byArray[n3 + 2] & 0xFF) << 8) + (byArray[n3 + 3] & 0xFF));
                CharacterProperties.rangeOffset[n2] = ((byArray[n3 + 4] & 0xFF) << 16) + ((byArray[n3 + 5] & 0xFF) << 8) + (byArray[n3 + 6] & 0xFF);
                ++n2;
                n3 += 7;
            }
        }
    }
}

