/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

import java.io.DataInput;
import java.io.EOFException;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UTFDataFormatException;

class ProcessInputStream
extends FilterInputStream
implements DataInput {
    public ProcessInputStream(InputStream inputStream) {
        super(inputStream);
    }

    public final int read(byte[] byArray) throws IOException {
        return this.read(byArray, 0, byArray.length);
    }

    public final int read(byte[] byArray, int n, int n2) throws IOException {
        return super.read(byArray, n, n2);
    }

    public final boolean readBoolean() throws IOException {
        return this.readByte() != 0;
    }

    public final byte readByte() throws IOException {
        int n = super.read();
        if (n == -1) {
            throw new EOFException();
        }
        return (byte)n;
    }

    public final char readChar() throws IOException {
        int n = this.readUnsignedByte();
        int n2 = this.readUnsignedByte();
        return (char)(n << 8 | n2);
    }

    public final double readDouble() throws IOException {
        return Double.longBitsToDouble(this.readLong());
    }

    public final float readFloat() throws IOException {
        return Float.intBitsToFloat(this.readInt());
    }

    public final void readFully(byte[] byArray) throws IOException {
        this.readFully(byArray, 0, byArray.length);
    }

    public final void readFully(byte[] byArray, int n, int n2) throws IOException {
        int n3;
        for (int i = 0; i < n2; i += n3) {
            n3 = this.read(byArray, n + i, n2 + i);
            if (n3 != -1) continue;
            throw new EOFException();
        }
    }

    public final int readInt() throws IOException {
        int n = this.readUnsignedByte();
        int n2 = this.readUnsignedByte();
        int n3 = this.readUnsignedByte();
        int n4 = this.readUnsignedByte();
        int n5 = n << 24 | n2 << 16 | n3 << 8 | n4;
        return n5;
    }

    public final String readLine() throws IOException {
        boolean bl = false;
        StringBuffer stringBuffer = new StringBuffer();
        while (!bl) {
            int n = super.read();
            if (n == -1) {
                bl = true;
                continue;
            }
            stringBuffer.append((byte)n);
            if ((char)n == '\n') {
                bl = true;
            }
            if ((char)n != '\r') continue;
            super.mark(1);
            int n2 = super.read();
            if (n2 == -1) {
                bl = true;
                continue;
            }
            if ((char)n2 == '\n') {
                stringBuffer.append((byte)n2);
                bl = true;
                continue;
            }
            this.reset();
        }
        return stringBuffer.toString();
    }

    public final long readLong() throws IOException {
        int n = this.readInt();
        int n2 = this.readInt();
        return (long)n << 32 | (long)n2 & 0xFFFFFFFFFFFFFFFFL;
    }

    public final short readShort() throws IOException {
        int n = this.readUnsignedByte();
        int n2 = this.readUnsignedByte();
        return (short)(n << 8 | n2);
    }

    public final String readUTF() throws IOException {
        return ProcessInputStream.readUTF(this);
    }

    public static final synchronized String readUTF(DataInput dataInput) throws IOException {
        int n = dataInput.readUnsignedShort();
        StringBuffer stringBuffer = new StringBuffer();
        int n2 = 0;
        while (n2 < n) {
            int n3 = dataInput.readUnsignedByte();
            if ((n3 & 0x80) == 128) {
                char c;
                byte by;
                if ((n3 & 0xE0) == 192) {
                    by = dataInput.readByte();
                    if ((by & 0xC0) == 128) {
                        c = (char)(((n3 & 0x1F) << 6) + (by & 0x3F));
                        stringBuffer.append(c);
                        n2 += 2;
                        continue;
                    }
                    throw new UTFDataFormatException();
                }
                if ((n3 & 0xF0) == 224) {
                    by = dataInput.readByte();
                    if ((by & 0xC0) == 128) {
                        c = dataInput.readByte();
                        if ((c & 0xC0) == 128) {
                            char c2 = (char)(((n3 & 0xF) << 12) + ((by & 0x3F) << 6) + (c & 0x3F));
                            stringBuffer.append(c2);
                            n2 += 3;
                            continue;
                        }
                        throw new UTFDataFormatException();
                    }
                    throw new UTFDataFormatException();
                }
                throw new UTFDataFormatException();
            }
            stringBuffer.append((char)n3);
            ++n2;
        }
        if (n2 > n) {
            throw new UTFDataFormatException();
        }
        return stringBuffer.toString();
    }

    public final int readUnsignedByte() throws IOException {
        int n = super.read();
        if (n == -1) {
            throw new EOFException();
        }
        return n & 0xFF;
    }

    public final int readUnsignedShort() throws IOException {
        int n = this.readUnsignedByte();
        int n2 = this.readUnsignedByte();
        return n << 8 | n2;
    }

    public final int skipBytes(int n) throws IOException {
        long l = super.skip(n);
        int n2 = (int)l;
        if (n2 != n) {
            throw new EOFException();
        }
        return n2;
    }
}

