/*
 * Decompiled with CFR 0.152.
 */
package java.net;

import java.net.InetAddress;
import java.net.UnknownHostException;

public final class DatagramPacket {
    private byte[] buf;
    private int length;
    private InetAddress address;
    private int port;

    public DatagramPacket(byte[] byArray, int n) {
        this.buf = byArray;
        this.length = n < this.buf.length ? n : this.buf.length;
        try {
            this.address = InetAddress.getLocalHost();
        }
        catch (UnknownHostException unknownHostException) {
            this.address = InetAddress.getLoopback();
        }
        this.port = -1;
    }

    public DatagramPacket(byte[] byArray, int n, InetAddress inetAddress, int n2) {
        this.buf = byArray;
        this.length = n < this.buf.length ? n : this.buf.length;
        this.address = inetAddress;
        this.port = n2;
    }

    public synchronized InetAddress getAddress() {
        return this.address;
    }

    public synchronized byte[] getData() {
        return this.buf;
    }

    public synchronized int getLength() {
        if (this.port == -1) {
            return 0;
        }
        return this.length;
    }

    public synchronized int getPort() {
        return this.port;
    }

    public synchronized void setAddress(InetAddress inetAddress) {
        this.address = inetAddress;
    }

    public synchronized void setData(byte[] byArray) {
        this.buf = byArray;
    }

    public synchronized void setLength(int n) {
        if (n > this.buf.length) {
            throw new IllegalArgumentException();
        }
        this.length = n;
    }

    public synchronized void setPort(int n) {
        if (n < 0 || n > 65535) {
            throw new IllegalArgumentException();
        }
        this.port = n;
    }
}

