/*
 * Decompiled with CFR 0.152.
 */
package java.text;

import java.text.ChoiceFormat;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.FieldPosition;
import java.text.Format;
import java.text.NumberFormat;
import java.text.ParseException;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.Locale;
import kaffe.util.NotImplemented;

public class MessageFormat
extends Format {
    private Locale locale = Locale.getDefault();
    private Format[] formats;
    private int[] argumentNumber;
    private transient String[] strs;
    private int maxOffset;
    private int[] offsets;
    private String pattern;

    public MessageFormat(String string) {
        this.applyPattern(string);
    }

    public void applyPattern(String string) {
        int n = string.length();
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            if (string.charAt(i) != '{') continue;
            ++n2;
            while (string.charAt(i) != '}' && i < n) {
                ++i;
            }
        }
        this.formats = new Format[n2];
        this.strs = new String[n2 + 1];
        this.argumentNumber = new int[n2];
        n2 = 0;
        int n3 = 0;
        for (int i = 0; i < n; ++i) {
            if (string.charAt(i) != '{') continue;
            this.strs[n2] = string.substring(n3, i);
            n3 = ++i;
            while (string.charAt(i) != '}' && i < n) {
                ++i;
            }
            this.parseFormat(string.substring(n3, i), n2);
            ++n2;
            n3 = i + 1;
        }
        this.strs[n2] = string.substring(n3, n);
    }

    private void parseFormat(String string, int n) {
        int n2;
        int n3 = string.indexOf(44);
        int n4 = n3 + 1;
        if (n3 == -1) {
            n4 = n3 = string.length();
        }
        int n5 = string.indexOf(44, n3 + 1);
        int n6 = n5 + 1;
        if (n5 == -1) {
            n6 = n5 = string.length();
        }
        try {
            n2 = Integer.parseInt(string.substring(0, n3));
        }
        catch (NumberFormatException numberFormatException) {
            n2 = -1;
        }
        String string2 = string.substring(n4, n5);
        String string3 = string.substring(n6, string.length());
        this.argumentNumber[n] = n2;
        this.formats[n] = string2.equals("time") ? (string3.equals("") ? DateFormat.getTimeInstance(2, this.locale) : (string3.equals("short") ? DateFormat.getTimeInstance(3, this.locale) : (string3.equals("medium") ? DateFormat.getTimeInstance(2, this.locale) : (string3.equals("long") ? DateFormat.getTimeInstance(1, this.locale) : (string3.equals("full") ? DateFormat.getTimeInstance(0, this.locale) : new SimpleDateFormat(string3, this.locale)))))) : (string2.equals("date") ? (string3.equals("") ? DateFormat.getDateInstance(2, this.locale) : (string3.equals("short") ? DateFormat.getDateInstance(3, this.locale) : (string3.equals("medium") ? DateFormat.getDateInstance(2, this.locale) : (string3.equals("long") ? DateFormat.getDateInstance(1, this.locale) : (string3.equals("full") ? DateFormat.getDateInstance(0, this.locale) : new SimpleDateFormat(string3, this.locale)))))) : (string2.equals("number") ? (string3.equals("currency") ? NumberFormat.getCurrencyInstance(this.locale) : (string3.equals("percent") ? NumberFormat.getPercentInstance(this.locale) : (string3.equals("integer") ? NumberFormat.getNumberInstance(this.locale) : new DecimalFormat(string3, this.locale)))) : (string2.equals("choice") ? new ChoiceFormat(string3) : null)));
    }

    public Object clone() {
        MessageFormat messageFormat = new MessageFormat("");
        messageFormat.locale = this.locale;
        messageFormat.strs = this.strs;
        messageFormat.formats = this.formats;
        messageFormat.argumentNumber = this.argumentNumber;
        return messageFormat;
    }

    public boolean equals(Object object) {
        try {
            MessageFormat messageFormat = (MessageFormat)object;
            if (this.locale != messageFormat.locale) {
                return false;
            }
            for (int i = 0; i < this.formats.length; ++i) {
                if (!this.formats[i].equals(messageFormat.formats[i])) {
                    return false;
                }
                if (this.strs[i].equals(messageFormat.strs[i])) continue;
                return false;
            }
            return true;
        }
        catch (ClassCastException classCastException) {
            return false;
        }
    }

    public static String format(String string, Object[] objectArray) {
        return new MessageFormat(string).format(objectArray, new StringBuffer(), (FieldPosition)null).toString();
    }

    public final StringBuffer format(Object[] objectArray, StringBuffer stringBuffer, FieldPosition fieldPosition) {
        FieldPosition fieldPosition2 = new FieldPosition(0);
        for (int i = 0; i < this.formats.length; ++i) {
            stringBuffer.append(this.strs[i]);
            if (this.formats[i] == null) {
                stringBuffer.append(objectArray[this.argumentNumber[i]].toString());
                continue;
            }
            this.formats[i].format(objectArray[this.argumentNumber[i]], stringBuffer, fieldPosition2);
        }
        stringBuffer.append(this.strs[this.strs.length - 1]);
        return stringBuffer;
    }

    public final StringBuffer format(Object object, StringBuffer stringBuffer, FieldPosition fieldPosition) {
        if (object instanceof Object[]) {
            return this.format((Object[])object, stringBuffer, fieldPosition);
        }
        return this.format(new Object[]{object}, stringBuffer, fieldPosition);
    }

    public Format[] getFormats() {
        return this.formats;
    }

    public Locale getLocale() {
        return this.locale;
    }

    public int hashCode() {
        return super.hashCode();
    }

    public Object[] parse(String string, ParsePosition parsePosition) {
        throw new NotImplemented();
    }

    public Object[] parse(String string) throws ParseException {
        return this.parse(string, new ParsePosition(0));
    }

    public Object parseObject(String string, ParsePosition parsePosition) {
        Object[] objectArray = this.parse(string, parsePosition);
        return objectArray;
    }

    public void setFormat(int n, Format format) {
        this.formats[n] = format;
    }

    public void setFormats(Format[] formatArray) {
        this.formats = formatArray;
    }

    public void setLocale(Locale locale2) {
        this.locale = locale2;
    }

    public String toPattern() {
        throw new NotImplemented();
    }
}

