/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import java.io.Serializable;
import java.util.MissingResourceException;

public final class Locale
implements Cloneable,
Serializable {
    private static final long serialVersionUID = 9149081749638150636L;
    public static final Locale ENGLISH = new Locale("EN", null);
    public static final Locale FRENCH = new Locale("FR", null);
    public static final Locale GERMAN = new Locale("DE", null);
    public static final Locale ITALIAN = new Locale("IT", null);
    public static final Locale JAPANESE = new Locale("JA", null);
    public static final Locale KOREAN = new Locale("KO", null);
    public static final Locale CHINESE = new Locale("ZH", null);
    public static final Locale SIMPLIFIED_CHINESE = new Locale("ZH", null);
    public static final Locale TRADITIONAL_CHINESE = new Locale("ZH", null);
    public static final Locale FRANCE = new Locale("FR", "FR");
    public static final Locale GERMANY = new Locale("DE", "DE");
    public static final Locale ITALY = new Locale("IT", "IT");
    public static final Locale JAPAN = new Locale("JA", "JP");
    public static final Locale KOREA = new Locale("KO", "KR");
    public static final Locale CHINA = new Locale("ZH", "CN");
    public static final Locale PRC = new Locale("??", "??");
    public static final Locale TAIWAN = new Locale("ZH", "TW");
    public static final Locale UK = new Locale("EN", "GB");
    public static final Locale US = new Locale("EN", "US");
    public static final Locale CANADA = new Locale("EN", "CA");
    public static final Locale CANADA_FRENCH = new Locale("FR", "CA");
    private static Locale defaultLocale;
    private String lang;
    private String cntry;
    private String var;
    private int hashcode;

    public Locale(String string, String string2) {
        this(string, string2, null);
    }

    public Locale(String string, String string2, String string3) {
        this.lang = string;
        this.cntry = string2;
        this.var = string3;
        this.hashcode = super.hashCode();
    }

    public Object clone() {
        return new Locale(this.lang, this.cntry, this.var);
    }

    public boolean equals(Object object) {
        try {
            Locale locale2 = (Locale)object;
            if (!(this.lang != locale2.lang && !this.lang.equals(locale2.lang) || this.cntry != locale2.cntry && !this.cntry.equals(locale2.cntry) || this.var != locale2.var && !this.var.equals(locale2.var))) {
                return true;
            }
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
        return false;
    }

    public String getCountry() {
        return this.cntry;
    }

    public static synchronized Locale getDefault() {
        return defaultLocale;
    }

    public final String getDisplayCountry() {
        return this.cntry;
    }

    public String getDisplayCountry(Locale locale2) {
        return this.cntry;
    }

    public final String getDisplayLanguage() {
        return this.lang;
    }

    public String getDisplayLanguage(Locale locale2) {
        return this.lang;
    }

    public final String getDisplayName() {
        return this.toString();
    }

    public String getDisplayName(Locale locale2) {
        return this.toString();
    }

    public final String getDisplayVariant() {
        return this.var;
    }

    public String getDisplayVariant(Locale locale2) {
        return this.var;
    }

    public String getISO3Country() throws MissingResourceException {
        throw new MissingResourceException("ISO3 not supported", "Locale", "");
    }

    public String getISO3Language() throws MissingResourceException {
        throw new MissingResourceException("ISO3 not supported", "Locale", "");
    }

    public String getLanguage() {
        return this.lang;
    }

    public String getVariant() {
        return this.var;
    }

    public synchronized int hashCode() {
        return this.hashcode;
    }

    public static synchronized void setDefault(Locale locale2) {
        defaultLocale = locale2;
    }

    public final String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.lang != null) {
            stringBuffer.append(this.lang);
            if (this.cntry != null) {
                stringBuffer.append("_");
            }
        }
        if (this.cntry != null) {
            stringBuffer.append(this.cntry);
            if (this.var != null) {
                stringBuffer.append("_");
            }
        }
        if (this.var != null) {
            stringBuffer.append(this.var);
        }
        return new String(stringBuffer);
    }

    static {
        String string = System.getProperty("user.language", "EN");
        String string2 = System.getProperty("user.region", "US");
        defaultLocale = new Locale(string, string2);
    }
}

