/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.PushbackInputStream;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties$17$;
import java.util.Vector;

public class Properties
extends Hashtable {
    private static final long serialVersionUID = 4112578634029874840L;
    protected Properties defaults;
    private StringBuffer key;
    private StringBuffer value;

    public Properties() {
        this(null);
    }

    public Properties(Properties properties) {
        this.defaults = properties;
    }

    private static String escape(String string, boolean bl) {
        StringBuffer stringBuffer = new StringBuffer();
        block8: for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            switch (c) {
                case '!': 
                case '#': {
                    if (i == 0) {
                        stringBuffer.append("\\");
                    }
                    stringBuffer.append(c);
                    continue block8;
                }
                case ' ': 
                case ':': 
                case '=': {
                    if (!bl) {
                        stringBuffer.append(c);
                        continue block8;
                    }
                }
                case '\\': {
                    stringBuffer.append(String.valueOf("\\").concat(String.valueOf(c)));
                    continue block8;
                }
                case '\n': {
                    stringBuffer.append("\\n");
                    continue block8;
                }
                case '\t': {
                    stringBuffer.append("\\t");
                    continue block8;
                }
                case '\r': {
                    stringBuffer.append("\\r");
                    continue block8;
                }
                default: {
                    if (c > '~') {
                        stringBuffer.append("\\\\u");
                        stringBuffer.append(Character.forDigit(c >> 12 & 0xF, 16));
                        stringBuffer.append(Character.forDigit(c >> 8 & 0xF, 16));
                        stringBuffer.append(Character.forDigit(c >> 4 & 0xF, 16));
                        stringBuffer.append(Character.forDigit(c & 0xF, 16));
                        continue block8;
                    }
                    stringBuffer.append(c);
                }
            }
        }
        return stringBuffer.toString();
    }

    public String getProperty(String string) {
        Object object = super.get(string);
        if (object != null) {
            return (String)object;
        }
        if (this.defaults != null) {
            return this.defaults.getProperty(string);
        }
        return null;
    }

    public String getProperty(String string, String string2) {
        String string3 = this.getProperty(string);
        if (string3 == null) {
            return string2;
        }
        return string3;
    }

    public void list(PrintStream printStream) {
        this.list(new PrintWriter(printStream, true));
    }

    public void list(PrintWriter printWriter) {
        try {
            this.save(printWriter, "Properties list");
        }
        catch (IOException iOException) {
            System.err.println("unable to list properties");
        }
    }

    public Enumeration propertyNames() {
        Vector vector = new Vector();
        Enumeration enumeration = this.keys();
        while (enumeration.hasMoreElements()) {
            vector.addElement(enumeration.nextElement());
        }
        if (this.defaults != null) {
            Enumeration enumeration2 = this.defaults.keys();
            while (enumeration2.hasMoreElements()) {
                Object object = enumeration2.nextElement();
                if (vector.contains(object)) continue;
                vector.addElement(object);
            }
        }
        return new 17$$anonymous_class16(vector, this);
    }

    public synchronized void load(InputStream inputStream) throws IOException {
        PushbackInputStream pushbackInputStream = new PushbackInputStream(inputStream, 16);
        while (this.readKeyAndValue(pushbackInputStream)) {
            this.put(this.key.toString(), this.value.toString());
        }
        this.key = null;
        this.value = null;
    }

    /*
     * Unable to fully structure code
     */
    private boolean readKeyAndValue(PushbackInputStream var1_1) throws IOException {
        block21: while (true) {
            if ((var2_2 = var1_1.read()) != -1 && var2_2 <= 32) {
                continue;
            }
            switch (var2_2) {
                case 33: 
                case 35: {
                    while (true) {
                        if ((var2_2 = var1_1.read()) != 10) ** break;
                        continue block21;
                    }
                }
                case -1: {
                    return false;
                }
                default: {
                    this.key = new StringBuffer();
                    this.value = new StringBuffer();
                    block23: while (true) {
                        switch (var2_2) {
                            case 58: 
                            case 61: {
                                break block23;
                            }
                            case 13: {
                                var2_2 = var1_1.read();
                                switch (var2_2) {
                                    case 10: {
                                        break;
                                    }
                                    case -1: {
                                        return true;
                                    }
                                    default: {
                                        var1_1.unread(var2_2);
                                        break block23;
                                    }
                                }
                            }
                            case -1: 
                            case 10: {
                                return true;
                            }
                            default: {
                                if (var2_2 <= 32) break block23;
                                var1_1.unread(var2_2);
                                this.key.append((char)Properties.getEscapedChar(var1_1));
                                var2_2 = var1_1.read();
                                continue block23;
                            }
                        }
                        break;
                    }
                    while ((var2_2 = var1_1.read()) <= 32) {
                        if (var2_2 != -1 && var2_2 != 10) continue;
                        return true;
                    }
                    while (true) {
                        switch (var2_2) {
                            case 13: {
                                var2_2 = var1_1.read();
                                switch (var2_2) {
                                    case -1: {
                                        this.value.append('\r');
                                    }
                                    case 10: {
                                        return true;
                                    }
                                }
                                var1_1.unread(var2_2);
                                this.value.append('\r');
                                break;
                            }
                            case -1: 
                            case 10: {
                                return true;
                            }
                            default: {
                                var1_1.unread(var2_2);
                                this.value.append((char)Properties.getEscapedChar(var1_1));
                            }
                        }
                        var2_2 = var1_1.read();
                    }
                }
            }
            break;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private static int getEscapedChar(PushbackInputStream pushbackInputStream) throws IOException {
        int n = pushbackInputStream.read();
        switch (n) {
            case 92: {
                n = pushbackInputStream.read();
                switch (n) {
                    case 13: {
                        n = pushbackInputStream.read();
                        switch (n) {
                            default: {
                                pushbackInputStream.unread(n);
                            }
                            case -1: {
                                pushbackInputStream.unread(13);
                                return 92;
                            }
                            case 10: 
                        }
                    }
                    case 10: {
                        while ((n = pushbackInputStream.read()) != -1 && n <= 32) {
                        }
                        return n;
                    }
                    case 110: {
                        return 10;
                    }
                    case 114: {
                        return 13;
                    }
                    case 116: {
                        return 9;
                    }
                    case 92: {
                        n = pushbackInputStream.read();
                        switch (n) {
                            case 117: {
                                int[] nArray = new int[4];
                                int n2 = 0;
                                int n3 = 0;
                                while (true) {
                                    int n4;
                                    if (n3 >= 4) {
                                        return n2;
                                    }
                                    nArray[n3] = pushbackInputStream.read();
                                    if (nArray[n3] == -1 || (n4 = Character.digit((char)nArray[n3++], 16)) == -1) break;
                                    n2 = n2 << 4 | n4;
                                }
                                while (n3 > 0) {
                                    pushbackInputStream.unread(nArray[--n3]);
                                }
                                break;
                            }
                        }
                        pushbackInputStream.unread(n);
                        return 92;
                    }
                    case -1: {
                        return 92;
                    }
                }
                return n;
            }
            case 13: {
                n = pushbackInputStream.read();
                switch (n) {
                    default: {
                        pushbackInputStream.unread(n);
                    }
                    case -1: {
                        return 13;
                    }
                    case 10: 
                }
                return n;
            }
        }
        return n;
    }

    public synchronized void save(OutputStream outputStream, String string) {
        try {
            this.store(outputStream, string);
        }
        catch (IOException iOException) {
            System.err.println(String.valueOf("Unable to save properties: ").concat(String.valueOf(string)));
        }
    }

    public synchronized void store(OutputStream outputStream, String string) throws IOException {
        this.save(new PrintWriter(outputStream, true), string);
    }

    private synchronized void save(PrintWriter printWriter, String string) throws IOException {
        if (string != null) {
            printWriter.println(String.valueOf("# ").concat(String.valueOf(Properties.escape(string, false))));
        }
        Enumeration enumeration = this.propertyNames();
        while (enumeration.hasMoreElements()) {
            String string2 = (String)enumeration.nextElement();
            printWriter.println(String.valueOf(String.valueOf(Properties.escape(string2, true)).concat(String.valueOf("="))).concat(String.valueOf(Properties.escape(this.getProperty(string2), false))));
        }
        printWriter.flush();
    }
}

