/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import java.util.Date;
import java.util.GregorianCalendar;
import java.util.TimeZone;

public class SimpleTimeZone
extends TimeZone {
    private static final long serialVersionUID = -403250971215465050L;
    private int startMonth;
    private int startDayOfWeek;
    private int startDayOfWeekInMonth;
    private int startTime;
    private int endMonth;
    private int endDayOfWeek;
    private int endDayOfWeekInMonth;
    private int endTime;
    private int startYear;
    private int rawOffset;
    private int daylightOffset;
    private boolean useDaylight;

    public SimpleTimeZone(int n, String string) {
        this.rawOffset = n;
        this.setID(string);
        this.useDaylight = false;
    }

    public SimpleTimeZone(int n, String string, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9) {
        this.startYear = 0;
        this.rawOffset = n;
        this.daylightOffset = n + 3600000;
        this.setID(string);
        this.setStartRule(n2, n3, n4, n5);
        this.setEndRule(n6, n7, n8, n9);
        this.useDaylight = true;
    }

    public Object clone() {
        SimpleTimeZone simpleTimeZone = new SimpleTimeZone(this.getRawOffset(), this.getID(), this.startMonth, this.startDayOfWeekInMonth, this.startDayOfWeek, this.startTime, this.endMonth, this.endDayOfWeekInMonth, this.endDayOfWeek, this.endTime);
        return simpleTimeZone;
    }

    public boolean equals(Object object) {
        try {
            SimpleTimeZone simpleTimeZone = (SimpleTimeZone)object;
            if (this.getID() == simpleTimeZone.getID() && this.rawOffset == simpleTimeZone.rawOffset && this.startMonth == simpleTimeZone.startMonth && this.startDayOfWeekInMonth == simpleTimeZone.startDayOfWeekInMonth && this.startDayOfWeek == simpleTimeZone.startDayOfWeek && this.startTime == simpleTimeZone.startTime && this.endMonth == simpleTimeZone.endMonth && this.endDayOfWeekInMonth == simpleTimeZone.endDayOfWeekInMonth && this.endDayOfWeek == simpleTimeZone.endDayOfWeek && this.endTime == simpleTimeZone.endTime && this.startYear == simpleTimeZone.startYear) {
                return true;
            }
        }
        catch (ClassCastException classCastException) {
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        return false;
    }

    public int getOffset(int n, int n2, int n3, int n4, int n5, int n6) {
        int n7;
        int n8 = this.rawOffset;
        int n9 = this.daylightOffset;
        if (n2 < this.startYear || n == 0) {
            return n8;
        }
        if (!this.useDaylight) {
            return n8;
        }
        if (n3 < this.startMonth || n3 > this.endMonth) {
            return n8;
        }
        if (n3 > this.startMonth && n3 < this.endMonth) {
            return n9;
        }
        int n10 = (6 + n5 - 1 + n4 - 1) / 7;
        switch (n3) {
            default: {
                n7 = 31;
                break;
            }
            case 1: {
                n7 = 29;
                break;
            }
            case 3: 
            case 5: 
            case 8: 
            case 10: {
                n7 = 30;
            }
        }
        int n11 = (6 + n5 - 1 + n7) / 7;
        if (n3 == this.startMonth) {
            int n12 = this.startDayOfWeekInMonth;
            if (n12 < 0) {
                n12 += n11;
            }
            if (n10 < n12) {
                return n8;
            }
            if (n10 > n12) {
                return n9;
            }
            if (n5 < this.startDayOfWeek) {
                return n8;
            }
            if (n5 > this.startDayOfWeek) {
                return n9;
            }
            if (n6 < this.startTime) {
                return n8;
            }
            return n9;
        }
        int n13 = this.endDayOfWeekInMonth;
        if (n13 < 0) {
            n13 += n11;
        }
        if (n10 < n13) {
            return n9;
        }
        if (n10 > n13) {
            return n8;
        }
        if (n5 < this.endDayOfWeek) {
            return n9;
        }
        if (n5 > this.endDayOfWeek) {
            return n8;
        }
        if (n6 < this.endTime) {
            return n9;
        }
        return n8;
    }

    public int getRawOffset() {
        return this.rawOffset;
    }

    public synchronized int hashCode() {
        return this.rawOffset;
    }

    public boolean inDaylightTime(Date date) {
        if (!this.useDaylight) {
            return false;
        }
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        gregorianCalendar.setTime(date);
        int n = this.getOffset(gregorianCalendar.get(0), gregorianCalendar.get(1), gregorianCalendar.get(2), gregorianCalendar.get(5), gregorianCalendar.get(7), ((gregorianCalendar.get(10) * 60 + gregorianCalendar.get(12)) * 60 + gregorianCalendar.get(13)) * 1000 + gregorianCalendar.get(14));
        return n != this.rawOffset;
    }

    public void setEndRule(int n, int n2, int n3, int n4) {
        this.endMonth = n;
        this.endDayOfWeekInMonth = n2;
        this.endDayOfWeek = n3;
        this.endTime = n4;
    }

    public void setRawOffset(int n) {
        this.rawOffset = n;
    }

    public void setStartRule(int n, int n2, int n3, int n4) {
        this.startMonth = n;
        this.startDayOfWeekInMonth = n2;
        this.startDayOfWeek = n3;
        this.startTime = n4;
    }

    public void setStartYear(int n) {
        this.startYear = n;
    }

    public boolean useDaylightTime() {
        return this.useDaylight;
    }

    static {
        new SimpleTimeZone(-39600000, "MIT");
        new SimpleTimeZone(-36000000, "HST");
        new SimpleTimeZone(-32400000, "AST");
        new SimpleTimeZone(-28800000, "PST", 3, 1, 1, 0x6DDD00, 9, -1, 1, 0x6DDD00);
        new SimpleTimeZone(-25200000, "PNT");
        new SimpleTimeZone(-25200000, "MST", 3, 1, 1, 0x6DDD00, 9, -1, 1, 0x6DDD00);
        new SimpleTimeZone(-21600000, "CST");
        new SimpleTimeZone(-18000000, "EST");
        new SimpleTimeZone(-18000000, "IET");
        new SimpleTimeZone(-14400000, "PRT");
        new SimpleTimeZone(-12600000, "CNT");
        new SimpleTimeZone(-10800000, "AGT");
        new SimpleTimeZone(-3600000, "CAT");
        new SimpleTimeZone(0, "GMT");
        new SimpleTimeZone(3600000, "ECT");
        new SimpleTimeZone(3600000, "EET");
        new SimpleTimeZone(0x6DDD00, "ART");
        new SimpleTimeZone(10800000, "EAT");
        new SimpleTimeZone(12600000, "MET");
        new SimpleTimeZone(14400000, "NET");
        new SimpleTimeZone(18000000, "PLT");
        new SimpleTimeZone(19800000, "IST");
        new SimpleTimeZone(21600000, "BST");
        new SimpleTimeZone(25200000, "VST");
        new SimpleTimeZone(28800000, "CTT");
        new SimpleTimeZone(32400000, "JST");
        new SimpleTimeZone(34200000, "ACT");
        new SimpleTimeZone(36000000, "AET");
        new SimpleTimeZone(39600000, "SST");
        new SimpleTimeZone(43200000, "NST");
    }
}

