/*
 * Decompiled with CFR 0.152.
 */
package kaffe.io;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamClass;
import java.io.OptionalDataException;
import java.io.StreamCorruptedException;
import java.util.Hashtable;
import kaffe.io.ObjectInputStreamImpl;
import kaffe.io.ObjectOutputStreamImpl;
import kaffe.util.Ptr;

public class ObjectStreamClassImpl
extends ObjectStreamClass {
    private static Hashtable streamClasses = new Hashtable();
    private int method;
    private long serialVersionUID;
    private ObjectStreamClassImpl superstream;
    private Class iclazz;
    private Ptr[] fields;

    public ObjectStreamClassImpl(Class clazz, int n) {
        this.name = clazz.getName();
        this.clazz = clazz;
        this.method = n;
        this.serialVersionUID = ObjectStreamClassImpl.getSerialVersionUID0(clazz);
        this.superstream = (ObjectStreamClassImpl)ObjectStreamClass.lookup(clazz.getSuperclass());
        this.iclazz = null;
    }

    public ObjectStreamClassImpl() {
        this.clazz = Class.forName("kaffe.io.ObjectStreamClassImpl");
        this.name = this.clazz.getName();
        this.method = 3;
        this.serialVersionUID = 0L;
        this.superstream = null;
        this.iclazz = null;
    }

    public Object getObject(ObjectInputStream objectInputStream, ObjectInputStreamImpl objectInputStreamImpl) throws StreamCorruptedException, OptionalDataException {
        Object object = this.allocateNewObject();
        objectInputStreamImpl.makeObjectReference(object);
        this.getObjectWithoutSuper(object, objectInputStream, objectInputStreamImpl);
        return object;
    }

    public void getObjectWithoutSuper(Object object, ObjectInputStream objectInputStream, ObjectInputStreamImpl objectInputStreamImpl) throws StreamCorruptedException, OptionalDataException {
        block9: {
            if (this.superstream != null) {
                this.superstream.getObjectWithoutSuper(object, objectInputStream, objectInputStreamImpl);
            }
            try {
                if ((this.method & 4) != 0) {
                    ((Externalizable)object).readExternal(objectInputStream);
                    break block9;
                }
                if ((this.method & 1) != 0) {
                    boolean bl = objectInputStreamImpl.enableBuffering(true);
                    this.invokeObjectReader0(object, objectInputStream);
                    objectInputStreamImpl.enableBuffering(bl);
                    if (objectInputStreamImpl.readByte() != 120) {
                        throw new StreamCorruptedException("missing endblockdata");
                    }
                    break block9;
                }
                if ((this.method & 2) != 0) {
                    this.defaultReadObject(object, objectInputStream);
                    break block9;
                }
                throw new StreamCorruptedException("unknown method type");
            }
            catch (ClassCastException classCastException) {
                classCastException.printStackTrace();
                throw new StreamCorruptedException(String.valueOf("error getting object: ").concat(String.valueOf(classCastException)));
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new StreamCorruptedException(String.valueOf("error getting object: ").concat(String.valueOf(classNotFoundException)));
            }
            catch (IOException iOException) {
                throw new StreamCorruptedException(String.valueOf("error getting object: ").concat(String.valueOf(iOException)));
            }
        }
    }

    public Object getClass(ObjectInputStream objectInputStream, ObjectInputStreamImpl objectInputStreamImpl) throws StreamCorruptedException, OptionalDataException {
        try {
            Object object = this.allocateNewObject();
            objectInputStreamImpl.makeObjectReference(object);
            this.invokeObjectReader0(object, objectInputStream);
            if (objectInputStreamImpl.readByte() != 120) {
                throw new StreamCorruptedException("missing endblockdata");
            }
            ((ObjectStreamClassImpl)object).superstream = (ObjectStreamClassImpl)objectInputStream.readObject();
            return object;
        }
        catch (IOException iOException) {
            throw new StreamCorruptedException(String.valueOf("error getting object: ").concat(String.valueOf(iOException)));
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new StreamCorruptedException(String.valueOf("error getting object: ").concat(String.valueOf(classNotFoundException)));
        }
    }

    public Object getArray(ObjectInputStream objectInputStream, ObjectInputStreamImpl objectInputStreamImpl) throws StreamCorruptedException {
        try {
            Class clazz = this.clazz.getComponentType();
            int n = objectInputStream.readInt();
            Object object = this.allocateNewArray(n);
            objectInputStreamImpl.makeObjectReference(object);
            if (clazz == Character.TYPE) {
                char[] cArray = (char[])object;
                for (int i = 0; i < n; ++i) {
                    cArray[i] = objectInputStream.readChar();
                }
            } else if (clazz == Short.TYPE) {
                short[] sArray = (short[])object;
                for (int i = 0; i < n; ++i) {
                    sArray[i] = objectInputStream.readShort();
                }
            } else if (clazz == Integer.TYPE) {
                int[] nArray = (int[])object;
                for (int i = 0; i < n; ++i) {
                    nArray[i] = objectInputStream.readInt();
                }
            } else if (clazz == Boolean.TYPE) {
                boolean[] blArray = (boolean[])object;
                for (int i = 0; i < n; ++i) {
                    blArray[i] = objectInputStream.readBoolean();
                }
            } else if (clazz == Long.TYPE) {
                long[] lArray = (long[])object;
                for (int i = 0; i < n; ++i) {
                    lArray[i] = objectInputStream.readLong();
                }
            } else if (clazz == Double.TYPE) {
                double[] dArray = (double[])object;
                for (int i = 0; i < n; ++i) {
                    dArray[i] = objectInputStream.readDouble();
                }
            } else if (clazz == Float.TYPE) {
                float[] fArray = (float[])object;
                for (int i = 0; i < n; ++i) {
                    fArray[i] = objectInputStream.readFloat();
                }
            } else if (clazz == Byte.TYPE) {
                byte[] byArray = (byte[])object;
                for (int i = 0; i < n; ++i) {
                    byArray[i] = objectInputStream.readByte();
                }
            } else {
                Object[] objectArray = (Object[])object;
                for (int i = 0; i < n; ++i) {
                    objectArray[i] = objectInputStream.readObject();
                }
            }
            return object;
        }
        catch (ClassCastException classCastException) {
            classCastException.printStackTrace();
            throw new StreamCorruptedException(String.valueOf("bad array: ").concat(String.valueOf(classCastException)));
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new StreamCorruptedException(String.valueOf("bad array: ").concat(String.valueOf(classNotFoundException)));
        }
        catch (IOException iOException) {
            throw new StreamCorruptedException(String.valueOf("bad array: ").concat(String.valueOf(iOException)));
        }
    }

    public void putObject(Object object, ObjectOutputStream objectOutputStream, ObjectOutputStreamImpl objectOutputStreamImpl) throws IOException {
        objectOutputStreamImpl.makeObjectReference(object);
        this.putObjectWithoutSuper(object, objectOutputStream, objectOutputStreamImpl);
    }

    public void putObjectWithoutSuper(Object object, ObjectOutputStream objectOutputStream, ObjectOutputStreamImpl objectOutputStreamImpl) throws IOException {
        if (this.superstream != null) {
            this.superstream.putObjectWithoutSuper(object, objectOutputStream, objectOutputStreamImpl);
        }
        if ((this.method & 4) != 0) {
            ((Externalizable)object).writeExternal(objectOutputStream);
        } else if ((this.method & 1) != 0) {
            boolean bl = objectOutputStreamImpl.enableBuffering(true);
            this.invokeObjectWriter0(object, objectOutputStream);
            objectOutputStreamImpl.enableBuffering(bl);
            objectOutputStreamImpl.writeByte(120);
        } else if ((this.method & 2) != 0) {
            this.defaultWriteObject(object, objectOutputStream);
        } else {
            throw new StreamCorruptedException("unknown method type");
        }
    }

    public void putClass(Object object, ObjectOutputStream objectOutputStream, ObjectOutputStreamImpl objectOutputStreamImpl) throws IOException {
        objectOutputStreamImpl.makeObjectReference(object);
        this.invokeObjectWriter0(object, objectOutputStream);
        objectOutputStreamImpl.writeByte(120);
    }

    public void putArray(Object object, ObjectOutputStream objectOutputStream, ObjectOutputStreamImpl objectOutputStreamImpl) throws IOException {
        Class clazz = object.getClass().getComponentType();
        objectOutputStreamImpl.makeObjectReference(object);
        if (clazz == Character.TYPE) {
            char[] cArray = (char[])object;
            int n = cArray.length;
            objectOutputStream.writeInt(n);
            for (int i = 0; i < n; ++i) {
                objectOutputStream.writeChar(cArray[i]);
            }
        } else if (clazz == Byte.TYPE) {
            byte[] byArray = (byte[])object;
            int n = byArray.length;
            objectOutputStream.writeInt(n);
            for (int i = 0; i < n; ++i) {
                objectOutputStream.writeByte(byArray[i]);
            }
        } else if (clazz == Short.TYPE) {
            short[] sArray = (short[])object;
            int n = sArray.length;
            objectOutputStream.writeInt(n);
            for (int i = 0; i < n; ++i) {
                objectOutputStream.writeShort(sArray[i]);
            }
        } else if (clazz == Integer.TYPE) {
            int[] nArray = (int[])object;
            int n = nArray.length;
            objectOutputStream.writeInt(n);
            for (int i = 0; i < n; ++i) {
                objectOutputStream.writeInt(nArray[i]);
            }
        } else if (clazz == Boolean.TYPE) {
            boolean[] blArray = (boolean[])object;
            int n = blArray.length;
            objectOutputStream.writeInt(n);
            for (int i = 0; i < n; ++i) {
                objectOutputStream.writeBoolean(blArray[i]);
            }
        } else if (clazz == Long.TYPE) {
            long[] lArray = (long[])object;
            int n = lArray.length;
            objectOutputStream.writeInt(n);
            for (int i = 0; i < n; ++i) {
                objectOutputStream.writeLong(lArray[i]);
            }
        } else if (clazz == Double.TYPE) {
            double[] dArray = (double[])object;
            int n = dArray.length;
            objectOutputStream.writeInt(n);
            for (int i = 0; i < n; ++i) {
                objectOutputStream.writeDouble(dArray[i]);
            }
        } else if (clazz == Float.TYPE) {
            float[] fArray = (float[])object;
            int n = fArray.length;
            objectOutputStream.writeInt(n);
            for (int i = 0; i < n; ++i) {
                objectOutputStream.writeFloat(fArray[i]);
            }
        } else {
            Object[] objectArray = (Object[])object;
            int n = objectArray.length;
            objectOutputStream.writeInt(n);
            for (int i = 0; i < n; ++i) {
                objectOutputStream.writeObject(objectArray[i]);
            }
        }
    }

    public void defaultReadObject(Object object, ObjectInputStream objectInputStream) {
        this.inputClassFields(object, objectInputStream);
    }

    public void defaultWriteObject(Object object, ObjectOutputStream objectOutputStream) {
        this.outputClassFields(object, objectOutputStream);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        this.name = objectInputStream.readUTF();
        this.serialVersionUID = objectInputStream.readLong();
        this.method = objectInputStream.readUnsignedByte();
        int n = objectInputStream.readShort();
        for (int i = 0; i < n; ++i) {
            int n2 = objectInputStream.readUnsignedByte();
            String string = objectInputStream.readUTF();
            if (n2 != 76 && n2 != 91) continue;
            try {
                String string2 = (String)objectInputStream.readObject();
                continue;
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new StreamCorruptedException("bad type");
            }
        }
        this.clazz = objectInputStream.resolveClassInternal(this);
        long l = ObjectStreamClassImpl.getSerialVersionUID0(this.clazz);
        if (this.serialVersionUID != l) {
            throw new StreamCorruptedException(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf("mismatched serial version UIDs: expected ").concat(String.valueOf(this.serialVersionUID))).concat(String.valueOf(" but local class `"))).concat(String.valueOf(this.clazz.getName()))).concat(String.valueOf("' has UID "))).concat(String.valueOf(l)));
        }
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.writeUTF(this.name);
        objectOutputStream.writeLong(this.serialVersionUID);
        objectOutputStream.writeByte(this.method);
        this.outputClassFieldInfo(objectOutputStream);
    }

    public long getSerialVersionUID() {
        return ObjectStreamClassImpl.getSerialVersionUID0(this.clazz);
    }

    private static native void init();

    private native Object allocateNewObject();

    private native Object allocateNewArray(int var1);

    public static native boolean hasWriteObject(Class var0);

    private native void inputClassFields(Object var1, ObjectInputStream var2);

    private native void outputClassFields(Object var1, ObjectOutputStream var2);

    private native boolean invokeObjectReader0(Object var1, ObjectInputStream var2);

    private native boolean invokeObjectWriter0(Object var1, ObjectOutputStream var2);

    private native void outputClassFieldInfo(ObjectOutputStream var1);

    public static native long getSerialVersionUID0(Class var0);

    static {
        ObjectStreamClassImpl.init();
    }
}

