/*
 * Decompiled with CFR 0.152.
 */
package kaffe.net.www.protocol;

import java.awt.Toolkit;
import java.io.IOException;
import java.net.URL;
import java.net.URLConnection;

public abstract class BasicURLConnection
extends URLConnection {
    protected static final String[] headers = new String[]{"content-encoding", "content-length", "content-type", "date", "expiration", "If-Modified-Since", "lastModified"};
    protected String[] headersValue = new String[headers.length];
    protected static final int ContentEncoding = 0;
    protected static final int ContentLength = 1;
    protected static final int ContentType = 2;
    protected static final int Date = 3;
    protected static final int Expiration = 4;
    protected static final int IfModifiedSince = 5;
    protected static final int LastModified = 6;

    public BasicURLConnection(URL uRL) {
        super(uRL);
    }

    public abstract void connect() throws IOException;

    public String getHeaderField(String string) {
        for (int i = 0; i < headers.length; ++i) {
            if (!headers[i].equals(string)) continue;
            return this.getHeaderField(i);
        }
        return null;
    }

    public String getHeaderField(int n) {
        if (n < 0 || n >= this.headersValue.length) {
            return null;
        }
        return this.headersValue[n];
    }

    public String getHeaderFieldKey(int n) {
        if (n < 0 || n >= headers.length) {
            return null;
        }
        return headers[n];
    }

    protected void setHeaderField(String string, String string2) {
        for (int i = 0; i < headers.length; ++i) {
            if (!headers[i].equals(string)) continue;
            this.headersValue[i] = string2;
            break;
        }
    }

    public Object getContent() throws IOException {
        if (this.headersValue[0] == null) {
            return null;
        }
        if (this.headersValue[0].startsWith("image/")) {
            return Toolkit.getDefaultToolkit().getImage(this.url).getSource();
        }
        return null;
    }

    protected void setContentTypeFromName() {
        String string;
        this.headersValue[2] = string = URLConnection.getFileNameMap().getContentTypeFor(this.url.getFile());
        this.headersValue[0] = string;
    }
}

