/*
 * Decompiled with CFR 0.152.
 */
package kaffe.util;

import kaffe.util.TimerClient;
import kaffe.util.TimerClientEntry;

public class Timer
extends Thread {
    TimerClientEntry[] clients;
    int nClients;
    int resolution = Integer.MAX_VALUE;
    boolean stop;
    static Timer defaultTimer;

    public Timer() {
        this.clients = new TimerClientEntry[5];
        for (int i = 0; i < this.clients.length; ++i) {
            this.clients[i] = new TimerClientEntry();
        }
        this.start();
    }

    public synchronized boolean addClient(TimerClient timerClient, int n, int n2) {
        int n3;
        for (n3 = 0; n3 < this.nClients; ++n3) {
            if (this.clients[n3].client != timerClient) continue;
            return false;
        }
        if (this.nClients == this.clients.length) {
            TimerClientEntry[] timerClientEntryArray = new TimerClientEntry[this.clients.length + 10];
            System.arraycopy(this.clients, 0, timerClientEntryArray, 0, this.nClients);
            this.clients = timerClientEntryArray;
            for (n3 = this.nClients; n3 < this.clients.length; ++n3) {
                this.clients[n3] = new TimerClientEntry();
            }
        }
        TimerClientEntry timerClientEntry = this.clients[this.nClients++];
        timerClientEntry.client = timerClient;
        timerClientEntry.nextNotify = System.currentTimeMillis() + (long)n;
        timerClientEntry.interval = n2;
        if (n2 < this.resolution) {
            this.resolution = n2;
            this.interrupt();
        }
        if (this.nClients == 1) {
            this.notify();
        }
        return true;
    }

    public static Timer getDefaultTimer() {
        if (defaultTimer == null) {
            defaultTimer = new Timer();
        }
        return defaultTimer;
    }

    public synchronized boolean removeClient(TimerClient timerClient) {
        for (int i = 0; i < this.nClients; ++i) {
            TimerClientEntry timerClientEntry = this.clients[i];
            if (timerClientEntry.client != timerClient) continue;
            int n = i + 1;
            int n2 = this.nClients - 1;
            timerClientEntry.client = null;
            if (n < n2) {
                System.arraycopy(this.clients, n, this.clients, i, n2 - i);
            }
            this.clients[--this.nClients] = timerClientEntry;
            if (this.resolution == timerClientEntry.interval && this.nClients > 0) {
                int n3 = Integer.MAX_VALUE;
                for (i = 0; i < this.nClients; ++i) {
                    if (this.clients[i].interval >= n3) continue;
                    n3 = this.clients[i].interval;
                }
                if (n3 != this.resolution) {
                    this.resolution = n3;
                }
            }
            return true;
        }
        return false;
    }

    public void run() {
        while (!this.stop) {
            try {
                while (!this.stop) {
                    Timer timer = this;
                    synchronized (timer) {
                        Object var7_7;
                        try {
                            if (this.nClients == 0) {
                                this.wait();
                            }
                            long l = System.currentTimeMillis();
                            for (int i = 0; i < this.nClients; ++i) {
                                TimerClientEntry timerClientEntry = this.clients[i];
                                if (l <= timerClientEntry.nextNotify) continue;
                                timerClientEntry.client.timerExpired(this);
                                timerClientEntry.nextNotify = l + (long)timerClientEntry.interval;
                            }
                            var7_7 = null;
                        }
                        catch (Throwable throwable) {
                            var7_7 = null;
                            throw throwable;
                        }
                    }
                    if (this.nClients <= 0) continue;
                    Thread.sleep(this.resolution);
                }
            }
            catch (InterruptedException interruptedException) {
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    public void startNotify() {
        this.stop = false;
        this.start();
    }

    public void stopNotify() {
        this.stop = true;
    }
}

