/*
 * Decompiled with CFR 0.152.
 */
package BR.unicamp.Guarana;

import BR.unicamp.Guarana.Guarana;
import BR.unicamp.Guarana.Result;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;

public final class Operation {
    public static final int nop = 0;
    public static final int invocation = 2;
    public static final int methodInvocation = 2;
    public static final int constructorInvocation = 3;
    public static final int synchronization = 4;
    public static final int monitorEnter = 4;
    public static final int monitorExit = 5;
    public static final int read = 8;
    public static final int write = 9;
    public static final int readWriteMask = 9;
    public static final int field = 16;
    public static final int array = 32;
    public static final int arrayMask = 96;
    public static final int arrayLength = 104;
    public static final int fieldRead = 24;
    public static final int fieldWrite = 25;
    public static final int arrayRead = 40;
    public static final int arrayWrite = 41;

    private Operation() {
    }

    public Result perform() {
        return Guarana.perform(this);
    }

    public native void validate() throws NoSuchMethodError, AbstractMethodError, IllegalArgumentException, NoSuchFieldError, ArrayIndexOutOfBoundsException;

    public native Object getObject();

    public native Thread getThread();

    public native Class getType();

    public native boolean isClassOperation();

    public native int getOpType();

    public native boolean isMethodInvocation();

    public native Method getMethod();

    public native boolean isConstructorInvocation();

    public native Constructor getConstructor();

    public native Object[] getArguments();

    public native boolean isSynchronization();

    public native boolean isMonitorEnter();

    public native boolean isMonitorExit();

    public native boolean isReadOperation();

    public native boolean isWriteOperation();

    public native boolean isFieldOperation();

    public native Field getField();

    public native boolean isArrayOperation();

    public native boolean isArrayLengthOperation();

    public native int getArrayIndex();

    public native Object getValue();

    public native boolean isReplacement();

    public native Operation getReplaced();

    public boolean replaced(Operation operation) {
        for (Operation operation2 = this; operation2 != null; operation2 = operation2.getReplaced()) {
            if (operation2 != operation) continue;
            return true;
        }
        return false;
    }

    public Operation getOriginal() {
        if (!this.isReplacement()) {
            return this;
        }
        return this.getReplaced().getOriginal();
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = this.isClassOperation();
        if (bl) {
            stringBuffer.append(Guarana.getClassName((Class)this.getObject()));
        } else {
            stringBuffer.append(Guarana.toString(this.getObject()));
        }
        switch (this.getOpType()) {
            case 0: {
                stringBuffer.append(".<nop>");
                break;
            }
            case 2: {
                stringBuffer.append('.');
                Method method = this.getMethod();
                if (!bl) {
                    stringBuffer.append(Guarana.getClassName(method.getDeclaringClass())).append('.');
                }
                stringBuffer.append(method.getName()).append('(');
                Class<?>[] classArray = method.getParameterTypes();
                Object[] objectArray = this.getArguments();
                int n = classArray.length;
                int n2 = objectArray.length;
                for (int i = 0; i < n || i < n2; ++i) {
                    if (i > 0) {
                        stringBuffer.append(',');
                    }
                    if (i < n) {
                        Class<?> clazz = classArray[i];
                        if (clazz.isPrimitive()) {
                            stringBuffer.append(clazz).append(' ');
                            if (i < n2) {
                                stringBuffer.append(objectArray[i]);
                                continue;
                            }
                            stringBuffer.append('?');
                            continue;
                        }
                        stringBuffer.append(clazz.getName()).append(' ');
                        if (i < n2) {
                            stringBuffer.append(Guarana.toString(objectArray[i]));
                            continue;
                        }
                        stringBuffer.append('?');
                        continue;
                    }
                    stringBuffer.append('?').append(' ').append(Guarana.toString(objectArray[i]));
                }
                stringBuffer.append(')');
                break;
            }
            case 3: {
                stringBuffer.append('.');
                Constructor constructor = this.getConstructor();
                stringBuffer.append(Guarana.getClassName(constructor.getDeclaringClass())).append('(');
                Class<?>[] classArray = constructor.getParameterTypes();
                Object[] objectArray = this.getArguments();
                int n = classArray.length;
                int n3 = objectArray.length;
                for (int i = 0; i < n || i < n3; ++i) {
                    if (i > 0) {
                        stringBuffer.append(',');
                    }
                    if (i < n) {
                        Class<?> clazz = classArray[i];
                        if (clazz.isPrimitive()) {
                            stringBuffer.append(clazz).append(' ');
                            if (i < n3) {
                                stringBuffer.append(objectArray[i]);
                                continue;
                            }
                            stringBuffer.append('?');
                            continue;
                        }
                        stringBuffer.append(clazz.getName()).append(' ');
                        if (i < n3) {
                            stringBuffer.append(Guarana.toString(objectArray[i]));
                            continue;
                        }
                        stringBuffer.append('?');
                        continue;
                    }
                    stringBuffer.append('?').append(' ').append(Guarana.toString(objectArray[i]));
                }
                stringBuffer.append(')');
                break;
            }
            case 4: {
                stringBuffer.append(".<monitor enter>");
                break;
            }
            case 5: {
                stringBuffer.append(".<monitor exit>");
                break;
            }
            case 24: {
                stringBuffer.append('.');
                Field field = this.getField();
                if (!bl) {
                    stringBuffer.append(Guarana.getClassName(field.getDeclaringClass())).append('.');
                }
                stringBuffer.append(this.getField().getName());
                break;
            }
            case 25: {
                stringBuffer.append('.');
                Field field = this.getField();
                if (!bl) {
                    stringBuffer.append(Guarana.getClassName(field.getDeclaringClass())).append('.');
                }
                stringBuffer.append(field.getName()).append('=');
                Object object = this.getValue();
                if (field.getType().isPrimitive()) {
                    stringBuffer.append(object);
                    break;
                }
                stringBuffer.append(Guarana.toString(object));
                break;
            }
            case 104: {
                stringBuffer.append(".length");
                break;
            }
            case 40: {
                stringBuffer.append('[').append(this.getArrayIndex()).append(']');
                break;
            }
            case 41: {
                stringBuffer.append('[').append(this.getArrayIndex()).append(']').append('=');
                Object object = this.getValue();
                if (Guarana.getClass(this.getObject()).getComponentType().isPrimitive()) {
                    stringBuffer.append(object);
                    break;
                }
                stringBuffer.append(Guarana.toString(object));
                break;
            }
            default: {
                throw new IllegalArgumentException("unknown operation type");
            }
        }
        return stringBuffer.toString();
    }

    static {
        System.loadLibrary("guarana");
    }
}

