/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import java.util.ArrayList;
import java.util.ListIterator;
import java.util.Observer;

public class Observable {
    private final ArrayList observers = new ArrayList();
    private boolean changed = false;

    public synchronized void addObserver(Observer observer) {
        this.observers.add(observer);
    }

    public synchronized void deleteObserver(Observer observer) {
        int n = this.observers.indexOf(observer);
        if (n != -1) {
            this.observers.remove(n);
        }
    }

    public void notifyObservers() {
        this.notifyObservers(null);
    }

    public synchronized void notifyObservers(Object object) {
        if (this.changed) {
            ListIterator listIterator = ((ArrayList)this.observers.clone()).listIterator();
            while (listIterator.hasNext()) {
                ((Observer)listIterator.next()).update(this, object);
            }
            this.clearChanged();
        }
    }

    public synchronized void deleteObservers() {
        this.observers.clear();
    }

    protected void setChanged() {
        this.changed = true;
    }

    protected void clearChanged() {
        this.changed = false;
    }

    public boolean hasChanged() {
        return this.changed;
    }

    public synchronized int countObservers() {
        return this.observers.size();
    }
}

