/*
 * Decompiled with CFR 0.152.
 */
package java.rmi;

import java.net.MalformedURLException;
import java.net.URL;
import java.rmi.AlreadyBoundException;
import java.rmi.NotBoundException;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.rmi.registry.LocateRegistry;
import java.rmi.registry.Registry;

public final class Naming {
    public static Remote lookup(String string) throws NotBoundException, MalformedURLException, RemoteException {
        URL uRL = new URL("http:" + string);
        return Naming.getRegistry(uRL).lookup(uRL.getFile().substring(1));
    }

    public static void bind(String string, Remote remote) throws AlreadyBoundException, MalformedURLException, RemoteException {
        URL uRL = new URL("http:" + string);
        Naming.getRegistry(uRL).bind(uRL.getFile().substring(1), remote);
    }

    public static void unbind(String string) throws RemoteException, NotBoundException, MalformedURLException {
        URL uRL = new URL("http:" + string);
        Naming.getRegistry(uRL).unbind(uRL.getFile().substring(1));
    }

    public static void rebind(String string, Remote remote) throws RemoteException, MalformedURLException {
        URL uRL = new URL("http:" + string);
        Naming.getRegistry(uRL).rebind(uRL.getFile().substring(1), remote);
    }

    public static String[] list(String string) throws RemoteException, MalformedURLException {
        return Naming.getRegistry(new URL("http:" + string)).list();
    }

    private static Registry getRegistry(URL uRL) throws RemoteException {
        if (uRL.getPort() == -1) {
            return LocateRegistry.getRegistry(uRL.getHost());
        }
        return LocateRegistry.getRegistry(uRL.getHost(), uRL.getPort());
    }
}

