/*
 * GuaraNative.h
 * Declarations of utility functions for native implementation of Guarana
 *
 * Copyright 1997,1998,1999,2000 Alexandre Oliva <oliva@lsd.ic.unicamp.br>
 *
 * This file is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef _GuaraNative_h
#define _GuaraNative_h

struct Hjava_lang_Throwable;
struct Hjava_lang_Class;
struct Hjava_lang_Object;
struct Hjava_lang_Thread;
struct Hjava_util_Hashtable;

struct HBR_unicamp_Guarana_MetaObject;
struct HBR_unicamp_Guarana_Result;
struct HBR_unicamp_Guarana_Operation;
struct HBR_unicamp_Guarana_OperationFactory;
struct HBR_unicamp_Guarana_Message;

struct _methods; /* from kaffevm/classMethod.h */
struct _fields; /* from kaffevm/gtypes.h */
struct _slots; /* from kaffevm/constants.h */
struct _iLock; /* from kaffevm/locks.h */
struct _Collector; /* from kaffevm/gc.h */

/* from GuaraNative.c */

extern struct HNativeOperation *guarana_new_native_operation(struct Hjava_lang_Object *object, struct HBR_unicamp_Guarana_Operation *replaced);

extern struct HBR_unicamp_Guarana_Result *guarana_new_result_object(int /* enum result_type */ kind, struct HBR_unicamp_Guarana_Operation *op, jvalue res);

extern struct HOperationFactoryInternal *guarana_new_operation_factory(struct Hjava_lang_Object *object, struct HBR_unicamp_Guarana_MetaObject *metaObject);

/* if size is not NULL, the int it points to will be assigned the
 * number fo stack slots taken by the originally unwrapped value */
extern struct Hjava_lang_Object* guarana_wrap(struct Hjava_lang_Class *clazz, jvalue val, int *size);

/* returns the number of stack slots taken by the unwrapped value */
extern int guarana_unwrap(struct Hjava_lang_Class *clazz, jvalue *val, struct Hjava_lang_Object *wrapper);

extern struct HNativeResult *guarana_handle_operation(struct HNativeOperation *op);

extern void guarana_slots_reify_method_invocation(struct Hjava_lang_Object *obj, Method *method, struct _slots *args, struct _slots *retval);

extern void guarana_slots_resolve_method_invocation(struct Hjava_lang_Object *obj, Method *method, struct _slots *args, struct _slots *retval);

extern void guarana_va_list_reify_method_invocation(struct Hjava_lang_Object *obj, Method *method, va_list args, struct _slots *result);

extern void guarana_va_list_resolve_method_invocation(struct Hjava_lang_Object *obj, Method *method, va_list args, struct _slots *result);

extern void jvoid_reify_method_invocation(Method *method, Hjava_lang_Object *obj, ...);

extern jref jref_reify_method_invocation(Method *method, Hjava_lang_Object *obj, ...);

extern jword jboolean_reify_method_invocation(Method *method, Hjava_lang_Object *obj, ...);

extern jword jchar_reify_method_invocation(Method *method, Hjava_lang_Object *obj, ...);

extern jword jbyte_reify_method_invocation(Method *method, Hjava_lang_Object *obj, ...);

extern jword jshort_reify_method_invocation(Method *method, Hjava_lang_Object *obj, ...);

extern jword jint_reify_method_invocation(Method *method, Hjava_lang_Object *obj, ...);

extern jlong jlong_reify_method_invocation(Method *method, Hjava_lang_Object *obj, ...);

extern jfloat jfloat_reify_method_invocation(Method *method, Hjava_lang_Object *obj, ...);

extern jdouble jdouble_reify_method_invocation(Method *method, Hjava_lang_Object *obj, ...);

extern void guarana_reify_field_load(struct Hjava_lang_Object *o, struct Hjava_lang_Class *declass, struct _fields *field, jvalue *res);

extern jref jref_reify_field_load(struct Hjava_lang_Object *o, struct Hjava_lang_Class *declass, struct _fields *field);

extern jword jboolean_reify_field_load(struct Hjava_lang_Object *o, struct Hjava_lang_Class *declass, struct _fields *field);

extern jword jchar_reify_field_load(struct Hjava_lang_Object *o, struct Hjava_lang_Class *declass, struct _fields *field);

extern jword jbyte_reify_field_load(struct Hjava_lang_Object *o, struct Hjava_lang_Class *declass, struct _fields *field);

extern jword jshort_reify_field_load(struct Hjava_lang_Object *o, struct Hjava_lang_Class *declass, struct _fields *field);

extern jword jint_reify_field_load(struct Hjava_lang_Object *o, struct Hjava_lang_Class *declass, struct _fields *field);

extern jlong jlong_reify_field_load(struct Hjava_lang_Object *o, struct Hjava_lang_Class *declass, struct _fields *field);

extern jfloat jfloat_reify_field_load(struct Hjava_lang_Object *o, struct Hjava_lang_Class *declass, struct _fields *field);

extern jdouble jdouble_reify_field_load(struct Hjava_lang_Object *o, struct Hjava_lang_Class *declass, struct _fields *field);

extern void guarana_reify_field_store(struct Hjava_lang_Object *o, struct Hjava_lang_Class *declass, struct _fields *field, jvalue *val);

extern void jref_reify_field_store(struct Hjava_lang_Object *o, struct Hjava_lang_Class *declass, struct _fields *field, jref value);

extern void jboolean_reify_field_store(struct Hjava_lang_Object *o, struct Hjava_lang_Class *declass, struct _fields *field, jword value);

extern void jchar_reify_field_store(struct Hjava_lang_Object *o, struct Hjava_lang_Class *declass, struct _fields *field, jword value);

extern void jbyte_reify_field_store(struct Hjava_lang_Object *o, struct Hjava_lang_Class *declass, struct _fields *field, jword value);

extern void jshort_reify_field_store(struct Hjava_lang_Object *o, struct Hjava_lang_Class *declass, struct _fields *field, jword value);

extern void jint_reify_field_store(struct Hjava_lang_Object *o, struct Hjava_lang_Class *declass, struct _fields *field, jword value);

extern void jlong_reify_field_store(struct Hjava_lang_Object *o, struct Hjava_lang_Class *declass, struct _fields *field, jlong value);

extern void jfloat_reify_field_store(struct Hjava_lang_Object *o, struct Hjava_lang_Class *declass, struct _fields *field, jfloat value);

extern void jdouble_reify_field_store(struct Hjava_lang_Object *o, struct Hjava_lang_Class *declass, struct _fields *field, jdouble value);

extern void guarana_reify_array_load(struct Hjava_lang_Object *o, int index, jvalue *res);

extern jref jref_reify_array_load(struct Hjava_lang_Object *o, int index);

extern jword jboolean_reify_array_load(struct Hjava_lang_Object *o, int index);

extern jword jchar_reify_array_load(struct Hjava_lang_Object *o, int index);

extern jword jbyte_reify_array_load(struct Hjava_lang_Object *o, int index);

extern jword jshort_reify_array_load(struct Hjava_lang_Object *o, int index);

extern jword jint_reify_array_load(struct Hjava_lang_Object *o, int index);

extern jlong jlong_reify_array_load(struct Hjava_lang_Object *o, int index);

extern jfloat jfloat_reify_array_load(struct Hjava_lang_Object *o, int index);

extern jdouble jdouble_reify_array_load(struct Hjava_lang_Object *o, int index);

extern void guarana_reify_array_store(struct Hjava_lang_Object *o, int index, jvalue *val);

extern void jref_reify_array_store(struct Hjava_lang_Object *o, int index, jref value);

extern void jboolean_reify_array_store(struct Hjava_lang_Object *o, int index, jword value);

extern void jchar_reify_array_store(struct Hjava_lang_Object *o, int index, jword value);

extern void jbyte_reify_array_store(struct Hjava_lang_Object *o, int index, jword value);

extern void jshort_reify_array_store(struct Hjava_lang_Object *o, int index, jword value);

extern void jint_reify_array_store(struct Hjava_lang_Object *o, int index, jword value);

extern void jlong_reify_array_store(struct Hjava_lang_Object *o, int index, jlong value);

extern void jfloat_reify_array_store(struct Hjava_lang_Object *o, int index, jfloat value);

extern void jdouble_reify_array_store(struct Hjava_lang_Object *o, int index, jdouble value);

extern int guarana_reify_arraylength(struct Hjava_lang_Object *o);

extern void guarana_reify_monitorEnter(struct Hjava_lang_Object *o);
extern void guarana_reify_monitorExit(struct Hjava_lang_Object *o);

extern struct Hjava_lang_Object *guarana_newObject(struct Hjava_lang_Class *clazz, struct Hjava_lang_Object *creator, errorInfo* einfo);

extern struct Hjava_lang_Object* guarana_newArray(Hjava_lang_Class *eltype, int count, Hjava_lang_Object *creator, errorInfo* einfo);

/* renamed from kaffevm/object.c */

extern struct Hjava_lang_Object *newObjectNoMessage(struct Hjava_lang_Class *class, errorInfo *info);

extern struct Hjava_lang_Object *newArrayNoMessage(Hjava_lang_Class *eltype, int count, errorInfo *info);

extern Hjava_lang_Object* guarana_newMultiArray(Hjava_lang_Class *clazz, Hjava_lang_Object *creator, int *dims, errorInfo *info);

/* will be set in libraries/clib/native/Class.c */

extern struct Hjava_lang_reflect_Constructor* (*p_makeConstructor)(struct Hjava_lang_Class* clazz, int slot);

extern struct Hjava_lang_reflect_Method* (*p_makeMethod)(struct Hjava_lang_Class* clazz, int slot);

extern struct Hjava_lang_reflect_Field* (*p_makeField)(struct Hjava_lang_Class* clazz, int slot);

extern struct Hjava_lang_String* (*p_getClassName)(struct Hjava_lang_Class *clazz);

void walkPrimArray(struct _Collector *collector, void *base, uint32 size);

void walkOperation(struct _Collector *collector, void *base, uint32 size);

#endif
