// $Id: MetaBlocker.java,v 1.1 1999/04/18 21:39:21 oliva Exp $

/* Copyright 1999 Alexandre Oliva <oliva@dcc.unicamp.br>
 *
 * This file is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

package BR.unicamp.Guarana;

/**
 * A MetaBlocker is installed as the primary MetaObject of an Object
 * from the moment in which it is created with `new' up to the moment
 * in which the MetaObject of its creator returns from the invocation
 * of the method configure.  It rejects all Operations, throwing
 * Blocked (an inner class) exceptions.  If such a MetaObject is
 * installed on an Object in any other case, the Object becomes
 * totally unusable.
 *
 * @see MetaObject#configure
 *
 * @author Alexandre Oliva
 * @version $Revision: 1.1 $ */
public class MetaBlocker extends MetaObject {
    /** Creates a MetaBlocker.  */
    public MetaBlocker() {}

    public static class Blocked extends RuntimeException {}

    public Result handle(final Operation operation,
			 final Object object) {
	return Result.throwObject(new Blocked(), operation);
    }

    public Result handle(final Result result,
			 final Object object) {
	return Result.throwObject(new Blocked(), result.getOperation());
    }

    public void handle(final Message message, final Object object) {}

    public MetaObject configure(final Object newObject,
				final Object object) {
	return this;
    }

    public MetaObject reconfigure(final Object object,
				  final MetaObject oldMetaObject,
				  final MetaObject newMetaObject) {
	return this;
    }

    public void initialize(final OperationFactory factory,
			   final Object object) {}

    public void release(final Object object) {}
}
