// $Id: CreateInvoke.java,v 1.1 1999/09/12 06:51:12 oliva Exp $

/* Copyright 1999 Alexandre Oliva <oliva@lsd.ic.unicamp.br>
 *
 * This file is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

import java.lang.reflect.*;
import BR.unicamp.Guarana.*;

/**
 * Test the creation of an invoke() operation with more than one
 * argument.  The argument list used to be copied incorrectly.
 *
 * @author Alexandre Oliva
 * @version $Revision: 1.1 $
 */
public class CreateInvoke extends MetaObject {
    public static void main(String[] argv) {
	final Object o = new Object();
	Guarana.reconfigure(o, null, new CreateInvoke());
	Guarana.broadcast(new Message() {}, o);
    }

    OperationFactory opf = null;
    
    public void initialize(final OperationFactory opf,
			   final Object o) {
	this.opf = opf;
    }

    private static Method get_wait_method() {
	try {
	    return Object.class.getMethod("wait",
					  new Class[] {
					      Long.TYPE,
					      Integer.TYPE
					  });
	} catch (NoSuchMethodException _) {
	    return null;
	}
    }

    final static Method wait_method;
    static {
	wait_method = get_wait_method();
    }

    public void handle(final Message m, final Object o) {
	try {
	    final Operation op = opf.invoke(wait_method,
					    new Object[] {
						new Long(1),
						new Integer(0)
						    });

	    final Object[] arguments = op.getArguments();
	    for(int i = 0, len = arguments.length; i < len; ++i)
		System.out.println(arguments[i]);

	    op.perform();
	} catch (IllegalAccessException _) {}
    }

    public Result handle(final Operation op, final Object o) {
	return Result.inspectResult;
    }

    public Result handle(final Result res, final Object o) {
	final Operation op = res.getOperation().getOriginal();
	if (wait_method.equals(op.getMethod())) {
	    final Object[] arguments = op.getArguments();
	    for(int i = 0, len = arguments.length; i < len; ++i)
		System.out.println(arguments[i]);
	}
	return null;
    }
}

/* Expected Output:
1
0
1
0
*/
