// $Id: NoJITLock.java,v 1.1 1999/09/12 06:51:12 oliva Exp $

/* Copyright 1999 Alexandre Oliva <oliva@lsd.ic.unicamp.br>
 *
 * This file is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

import BR.unicamp.Guarana.*;

/**
 * The JIT compiler acquires a lock on the Class while it is compiling
 * any of its methods.  This lock shouldn't be intercepted, as it is
 * not in the level of the Java language.
 *
 * @author Alexandre Oliva
 * @version $Revision: 1.1 $
 */
public class NoJITLock extends MetaObject {
    public static void main(String[] argv) {
	final Object o = new Object();
	Guarana.reconfigure(Object.class, null, new NoJITLock());
	o.getClass();
    }

    public Result handle(final Operation op, final Object o) {
	System.out.println(op);
	return null;
    }
}

/* Expected output:
*/
