/*
 * Decompiled with CFR 0.152.
 */
package java.awt;

import java.awt.AWTEvent;
import java.awt.AWTEventMulticaster;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Defaults;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.HotKeyHandler;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import kaffe.awt.ImageDict;
import kaffe.awt.ImageSpec;

public class Button
extends Component
implements MouseListener,
KeyListener,
FocusListener {
    String label;
    boolean pushed;
    ActionListener aListener;
    String aCmd;
    boolean active;
    FontMetrics fm;
    ImageSpec imgs;

    public Button() {
        this("");
    }

    public Button(String string) {
        this.bgClr = Defaults.BtnClr;
        this.cursor = Cursor.getPredefinedCursor(12);
        this.setFont(Defaults.BtnFont);
        this.setBackground(Defaults.BtnClr);
        this.setForeground(Defaults.BtnTxtClr);
        this.setLabel(string);
        this.addMouseListener(this);
        this.addKeyListener(this);
        this.addFocusListener(this);
    }

    void activate() {
        this.pushed = true;
        this.repaint();
        Toolkit.tlkSync();
        try {
            Thread.sleep(100L);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.pushed = false;
        this.repaint();
    }

    public void addActionListener(ActionListener actionListener) {
        this.aListener = AWTEventMulticaster.add(this.aListener, actionListener);
        this.eventMask |= 0x80;
    }

    void drawImage(Graphics graphics) {
        Image image = this.imgs.getImage();
        int n = image.getWidth(this);
        int n2 = image.getHeight(this);
        int n3 = this.pushed ? 1 : 0;
        int n4 = (this.width - n) / 2 + n3;
        int n5 = (this.height - n2) / 2 + n3;
        graphics.drawImage(image, n4, n5, this);
    }

    void drawText(Graphics graphics) {
        Color color;
        Color color2;
        int n = (this.width - this.fm.stringWidth(this.label)) / 2;
        int n2 = this.height - (this.height - this.fm.getHeight()) / 2 - this.fm.getDescent();
        if (this.pushed) {
            --n;
            --n2;
            color2 = Color.yellow;
            color = Color.red;
        } else if (this.active) {
            color2 = this.bgClr.brighter();
            color = Defaults.FocusClr;
        } else {
            color2 = this.bgClr.brighter();
            color = this.fgClr;
        }
        graphics.setColor(color2);
        graphics.drawString(this.label, n + 1, n2 + 1);
        graphics.setColor(color);
        graphics.drawString(this.label, n, n2);
    }

    public void focusGained(FocusEvent focusEvent) {
        this.repaint();
    }

    public void focusLost(FocusEvent focusEvent) {
        this.repaint();
    }

    public String getActionCommand() {
        return this.aCmd != null ? this.aCmd : this.label;
    }

    public String getLabel() {
        return this.label;
    }

    public Dimension getPreferredSize() {
        int n = 40;
        int n2 = 20;
        if (this.imgs != null) {
            n = this.imgs.getImage().getWidth(this) + 4;
            n2 = this.imgs.getImage().getHeight(this) + 4;
        } else if (this.fm != null) {
            n = Math.max(n, 4 * this.fm.stringWidth(this.label) / 3);
            n2 = Math.max(n2, 2 * this.fm.getHeight());
        }
        return new Dimension(n, n2);
    }

    public void keyPressed(KeyEvent keyEvent) {
        int n = keyEvent.getModifiers();
        if (n != 0) {
            return;
        }
        switch (keyEvent.getKeyCode()) {
            case 10: {
                this.activate();
                this.notifyAction();
                break;
            }
            default: {
                return;
            }
        }
        keyEvent.consume();
    }

    public void keyReleased(KeyEvent keyEvent) {
    }

    public void keyTyped(KeyEvent keyEvent) {
        switch (keyEvent.getKeyChar()) {
            case ' ': {
                this.activate();
                this.notifyAction();
            }
        }
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
        this.active = true;
        this.repaint();
    }

    public void mouseExited(MouseEvent mouseEvent) {
        this.active = false;
        this.repaint();
    }

    public void mousePressed(MouseEvent mouseEvent) {
        this.pushed = true;
        if (AWTEvent.keyTgt != this) {
            this.requestFocus();
        } else {
            this.repaint();
        }
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        this.pushed = false;
        if (this.contains(mouseEvent.getX(), mouseEvent.getY())) {
            this.notifyAction();
        }
        this.repaint();
    }

    void notifyAction() {
        if (this.hasToNotify(128, this.aListener)) {
            ActionEvent actionEvent = AWTEvent.getActionEvent(this, 1001);
            ((AWTEvent)actionEvent).setActionEvent(this.getActionCommand(), 0);
            Toolkit.eventQueue.postEvent(actionEvent);
        }
    }

    public void paint(Graphics graphics) {
        int n = 2;
        if (this.imgs != null && this.imgs.isPlain()) {
            graphics.setColor(this.parent.getBackground());
            graphics.fillRect(0, 0, this.width, this.height);
            if (this.active) {
                graphics.setColor(Defaults.BtnPointClr);
                graphics.draw3DRect(0, 0, this.width - 1, this.height - 1, !this.pushed);
            }
            this.drawImage(graphics);
        } else {
            this.paintBorder(graphics);
            graphics.setColor(this.active ? Defaults.BtnPointClr : this.bgClr);
            graphics.fill3DRect(n, n, this.width - 2 * n, this.height - 2 * n, !this.pushed);
            if (this.imgs != null) {
                this.drawImage(graphics);
            } else if (this.label != null) {
                this.drawText(graphics);
            }
        }
    }

    protected String paramString() {
        return String.valueOf(String.valueOf(super.paramString()).concat(String.valueOf(",Label: "))).concat(String.valueOf(this.label));
    }

    protected void processActionEvent(ActionEvent actionEvent) {
        if (AWTEvent.keyTgt != this) {
            this.activate();
        }
        this.aListener.actionPerformed(actionEvent);
    }

    protected void processEvent(AWTEvent aWTEvent) {
        if (aWTEvent instanceof ActionEvent) {
            this.processActionEvent((ActionEvent)aWTEvent);
        } else {
            super.processEvent(aWTEvent);
        }
    }

    public void removeActionListener(ActionListener actionListener) {
        this.aListener = AWTEventMulticaster.remove(this.aListener, actionListener);
    }

    public void setActionCommand(String string) {
        this.aCmd = string;
    }

    public void setFont(Font font) {
        super.setFont(font);
        this.fm = this.getFontMetrics(font);
        if (this.isVisible()) {
            this.repaint();
        }
    }

    public void setLabel(String string) {
        int n = string.indexOf(126);
        if (n > -1) {
            this.label = String.valueOf(string.substring(0, n)).concat(String.valueOf(string.substring(n + 1)));
            char c = string.charAt(n + 1);
            HotKeyHandler.addHotKey(this, c, 8, this.label);
        } else if (string.startsWith(" ") && string.endsWith(" ")) {
            this.imgs = ImageDict.getDefaultDict().getSpec(string.substring(1, string.length() - 1), null, this);
            this.label = this.imgs != null ? null : string;
        } else {
            this.label = string;
        }
        if (this.isShowing()) {
            this.repaint();
        }
    }
}

