/*
 * Decompiled with CFR 0.152.
 */
package java.awt;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager2;
import java.awt.Toolkit;
import java.util.Enumeration;
import java.util.Hashtable;

public class CardLayout
implements LayoutManager2 {
    int hgap;
    int vgap;
    Hashtable comptable = new Hashtable();

    public CardLayout() {
        this(0, 0);
    }

    public CardLayout(int n, int n2) {
        this.hgap = n;
        this.vgap = n2;
    }

    public void addLayoutComponent(Component component, Object object) {
        if (object instanceof String) {
            this.addLayoutComponent((String)object, component);
        }
    }

    public void addLayoutComponent(String string, Component component) {
        this.comptable.put(string, component);
        if (this.comptable.size() > 1) {
            component.setVisible(false);
        }
    }

    public void first(Container container) {
        Component component = null;
        for (int i = 0; i < container.nChildren; ++i) {
            Component component2 = container.children[i];
            if (component == null) {
                component = component2;
            }
            if (!component2.isVisible()) continue;
            if (component2 != component) {
                component2.setVisible(false);
                component.setVisible(true);
            }
            return;
        }
    }

    public int getHgap() {
        return this.hgap;
    }

    public float getLayoutAlignmentX(Container container) {
        return 0.5f;
    }

    public float getLayoutAlignmentY(Container container) {
        return 0.5f;
    }

    Dimension getLayoutSize(Container container, boolean bl) {
        Object object;
        Dimension dimension = new Dimension();
        for (int i = 0; i < container.nChildren; ++i) {
            object = container.children[i];
            Dimension dimension2 = bl ? ((Component)object).getPreferredSize() : ((Component)object).getMinimumSize();
            dimension.width = Math.max(dimension.width, dimension2.width);
            dimension.height = Math.max(dimension.height, dimension2.height);
        }
        object = container.insets;
        dimension.width += ((Insets)object).left + ((Insets)object).right;
        dimension.height += ((Insets)object).top + ((Insets)object).bottom;
        return dimension;
    }

    public int getVgap() {
        return this.vgap;
    }

    public void invalidateLayout(Container container) {
    }

    public void last(Container container) {
        Component component = null;
        for (int i = container.nChildren - 1; i >= 0; --i) {
            Component component2 = container.children[i];
            if (component == null) {
                component = component2;
            }
            if (!component2.isVisible()) continue;
            if (component2 != component) {
                component2.setVisible(false);
                component.setVisible(true);
            }
            return;
        }
    }

    public void layoutContainer(Container container) {
        Insets insets = container.insets;
        for (int i = 0; i < container.nChildren; ++i) {
            container.children[i].setBounds(insets.left + this.hgap, insets.top + this.vgap, container.width - 2 * this.hgap - insets.left - insets.right, container.height - 2 * this.vgap - insets.top - insets.bottom);
        }
    }

    public Dimension maximumLayoutSize(Container container) {
        return Toolkit.singleton.getScreenSize();
    }

    public Dimension minimumLayoutSize(Container container) {
        return this.getLayoutSize(container, false);
    }

    public void next(Container container) {
        Component component = null;
        for (int i = 0; i < container.nChildren; ++i) {
            Component component2 = container.children[i];
            if (component2.isVisible()) {
                component = component2;
                continue;
            }
            if (component == null) continue;
            component.setVisible(false);
            component2.setVisible(true);
            return;
        }
    }

    public Dimension preferredLayoutSize(Container container) {
        return this.getLayoutSize(container, true);
    }

    public void previous(Container container) {
        Component component = null;
        for (int i = container.nChildren - 1; i >= 0; --i) {
            Component component2 = container.children[i];
            if (component2.isVisible()) {
                component = component2;
                continue;
            }
            if (component == null) continue;
            component.setVisible(false);
            component2.setVisible(true);
            return;
        }
    }

    public void removeLayoutComponent(Component component) {
        Enumeration enumeration = this.comptable.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            Component component2 = (Component)this.comptable.get(string);
            if (component2 != component) continue;
            this.comptable.remove(string);
            return;
        }
    }

    public void setHgap(int n) {
        this.hgap = n;
    }

    public void setVgap(int n) {
        this.vgap = n;
    }

    public void show(Container container, String string) {
        Component component = (Component)this.comptable.get(string);
        for (int i = 0; i < container.nChildren; ++i) {
            Component component2 = container.children[i];
            if (!component2.isVisible()) continue;
            if (component2 != component) {
                component2.setVisible(false);
                component.setVisible(true);
            }
            return;
        }
    }

    public String toString() {
        return String.valueOf(String.valueOf(String.valueOf("CardLayout: hgap: ").concat(String.valueOf(this.hgap))).concat(String.valueOf(",vgap: "))).concat(String.valueOf(this.vgap));
    }
}

