/*
 * Decompiled with CFR 0.152.
 */
package java.awt;

import java.awt.AWTEvent;
import java.awt.AWTEventMulticaster;
import java.awt.Color;
import java.awt.Container;
import java.awt.Defaults;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.ItemSelectable;
import java.awt.PopupMenu;
import java.awt.RowCanvas;
import java.awt.Scrollbar;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.Vector;

public class List
extends Container
implements ItemSelectable {
    ActionListener aListener;
    ItemListener iListener;
    ItemPane ip = new ItemPane();
    Vector selections = new Vector(1);
    boolean multipleMode;
    boolean selMouse;

    public List() {
        this(3, false);
    }

    public List(int n) {
        this(n, false);
    }

    public List(int n, boolean bl) {
        this.setMultipleMode(bl);
        this.setLayout(null);
        this.ip.setForeground(Defaults.ListTxtClr);
        this.ip.setBackground(Defaults.ListBgClr);
        this.setFont(Defaults.ListFont);
        this.ip.vScroll = new Scrollbar(1);
        this.add(this.ip.vScroll);
        this.ip.hScroll = new Scrollbar(0);
        this.add(this.ip.hScroll);
        this.add(this.ip);
        this.ip.setListeners();
    }

    public void add(PopupMenu popupMenu) {
        this.ip.add(popupMenu);
    }

    public void add(String string) {
        this.addElement(string, -1);
    }

    public synchronized void add(String string, int n) {
        this.addElement(string, n);
    }

    public synchronized void addActionListener(ActionListener actionListener) {
        this.aListener = AWTEventMulticaster.add(this.aListener, actionListener);
        this.eventMask |= 0x80;
    }

    void addElement(String string, int n) {
        if (n == -1) {
            this.ip.rows.addElement(string);
        } else {
            this.ip.rows.insertElementAt(string, n);
        }
        this.ip.updateHScroll(string);
        this.ip.updateVScroll();
        if (this.isShowing()) {
            this.ip.repaint();
        }
    }

    public void addItem(String string) {
        this.addElement(string, -1);
    }

    public synchronized void addItem(String string, int n) {
        this.addElement(string, n);
    }

    public synchronized void addItemListener(ItemListener itemListener) {
        this.iListener = AWTEventMulticaster.add(this.iListener, itemListener);
        this.eventMask |= 0x200;
    }

    public synchronized void delItem(int n) {
        this.removeElement(n);
    }

    public synchronized void deselect(int n) {
        this.deselectElement(n, true);
    }

    void deselectElement(int n, boolean bl) {
        try {
            Object object = this.ip.rows.elementAt(n);
            this.selections.removeElement(object);
            if (bl) {
                this.ip.repaintRows(n, 1);
            }
            this.notifyItem(new Integer(n), 2);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void doLayout() {
        this.ip.innerLayout();
    }

    public String getItem(int n) {
        return (String)this.ip.rows.elementAt(n);
    }

    public int getItemCount() {
        return this.ip.rows.size();
    }

    public synchronized String[] getItems() {
        String[] stringArray = new String[this.ip.rows.size()];
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray[i] = (String)this.ip.rows.elementAt(i);
        }
        return stringArray;
    }

    public Dimension getMinimumSize() {
        return new Dimension(50, 50);
    }

    public Dimension getMinimumSize(int n) {
        return this.getMinimumSize();
    }

    public Dimension getPreferredSize() {
        return new Dimension(100, 100);
    }

    public Dimension getPreferredSize(int n) {
        return this.getPreferredSize();
    }

    public int getRows() {
        return this.ip.rows.size();
    }

    public synchronized int getSelectedIndex() {
        if (this.selections.size() == 0) {
            return -1;
        }
        return this.ip.rows.indexOf(this.selections.firstElement());
    }

    public synchronized int[] getSelectedIndexes() {
        int n = this.selections.size();
        int[] nArray = new int[n];
        for (int i = 0; i < n; ++i) {
            nArray[i] = this.ip.rows.indexOf(this.selections.elementAt(i));
        }
        return nArray;
    }

    public synchronized String getSelectedItem() {
        return this.selections.size() > 0 ? (String)this.selections.firstElement() : null;
    }

    public synchronized String[] getSelectedItems() {
        int n = this.selections.size();
        String[] stringArray = new String[n];
        for (int i = 0; i < n; ++i) {
            stringArray[i] = (String)this.selections.elementAt(i);
        }
        return stringArray;
    }

    public Object[] getSelectedObjects() {
        int n = this.selections.size();
        Object[] objectArray = new Object[n];
        for (int i = 0; i < n; ++i) {
            objectArray[i] = this.selections.elementAt(i);
        }
        return objectArray;
    }

    public int getVisibleIndex() {
        return this.ip.first;
    }

    void hPosChange() {
        this.ip.repaint();
    }

    public boolean isIndexSelected(int n) {
        Object object = this.ip.rows.elementAt(n);
        return this.selections.contains(object);
    }

    public boolean isMultipleMode() {
        return this.multipleMode;
    }

    void notifyAction() {
        String string;
        String string2 = string = this.selections.size() > 0 ? (String)this.selections.firstElement() : null;
        if (string != null && this.hasToNotify(128, this.aListener)) {
            ActionEvent actionEvent = AWTEvent.getActionEvent(this, 1001);
            ((AWTEvent)actionEvent).setActionEvent(string, 0);
            Toolkit.eventQueue.postEvent(actionEvent);
        }
    }

    void notifyItem(Object object, int n) {
        if (this.hasToNotify(512, this.iListener)) {
            ItemEvent itemEvent = AWTEvent.getItemEvent(this, 0);
            ((AWTEvent)itemEvent).setItemEvent(object, n);
            Toolkit.eventQueue.postEvent(itemEvent);
        }
    }

    protected String paramString() {
        return super.paramString();
    }

    protected void processActionEvent(ActionEvent actionEvent) {
        this.aListener.actionPerformed(actionEvent);
    }

    protected void processEvent(AWTEvent aWTEvent) {
        if (aWTEvent instanceof ActionEvent) {
            this.processActionEvent((ActionEvent)aWTEvent);
        } else if (aWTEvent instanceof ItemEvent) {
            this.processItemEvent((ItemEvent)aWTEvent);
        } else {
            super.processEvent(aWTEvent);
        }
    }

    protected void processItemEvent(ItemEvent itemEvent) {
        this.iListener.itemStateChanged(itemEvent);
    }

    public synchronized void remove(String string) {
        this.removeElement(this.ip.rows.indexOf(string));
    }

    public synchronized void remove(int n) {
        this.removeElement(n);
    }

    public synchronized void removeActionListener(ActionListener actionListener) {
        this.aListener = AWTEventMulticaster.remove(this.aListener, actionListener);
    }

    public synchronized void removeAll() {
        this.selections.removeAllElements();
        this.ip.rows.removeAllElements();
        this.ip.first = 0;
        this.ip.updateVScroll();
        this.ip.repaint();
    }

    void removeElement(int n) {
        try {
            this.deselectElement(n, false);
            this.ip.rows.removeElementAt(n);
            this.ip.updateVScroll();
            this.ip.repaintRows(n, this.ip.getVisibleRows());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    void removeHScroll() {
        this.ip.hScroll = null;
    }

    public synchronized void removeItemListener(ItemListener itemListener) {
        this.iListener = AWTEventMulticaster.remove(this.iListener, itemListener);
    }

    void repaintRow(Graphics graphics, int n) {
        this.ip.repaintItem(graphics, n);
    }

    public synchronized void replaceItem(String string, int n) {
        try {
            Object object = this.ip.rows.elementAt(n);
            this.ip.rows.setElementAt(string, n);
            if (this.selections.contains(object)) {
                this.selections.setElementAt(string, this.selections.indexOf(object));
            }
            this.ip.repaintRows(n, 1);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void requestFocus() {
        this.ip.requestFocus();
    }

    public void select(int n) {
        if (n < 0 || n > this.ip.rows.size() - 1) {
            return;
        }
        Object object = this.ip.rows.elementAt(n);
        if (this.selections.contains(object)) {
            return;
        }
        if (!this.multipleMode && this.selections.size() > 0) {
            Object object2 = this.selections.firstElement();
            int n2 = this.ip.rows.indexOf(object2);
            this.selections.removeAllElements();
            this.ip.repaintRows(n2, 1);
            this.notifyItem(new Integer(n2), 2);
        }
        this.selections.addElement(object);
        this.ip.makeVisible(n);
        this.ip.repaintRows(n, 1);
        this.notifyItem(new Integer(n), 1);
    }

    public void setBackground(Color color) {
        super.setBackground(color);
        this.ip.setBackground(color);
    }

    public void setBounds(int n, int n2, int n3, int n4) {
        super.setBounds(n, n2, n3, n4);
        this.ip.updateVScroll();
    }

    public void setFont(Font font) {
        super.setFont(font);
        this.ip.setFont(font);
        this.ip.updateVScroll();
    }

    public void setForeground(Color color) {
        super.setForeground(color);
        this.ip.setForeground(color);
    }

    public synchronized void setMultipleMode(boolean bl) {
        this.multipleMode = bl;
    }

    void vPosChange(int n) {
    }

    class ItemPane
    extends RowCanvas
    implements MouseListener,
    MouseMotionListener,
    KeyListener {
        StringBuffer lnsBuf = new StringBuffer();
        int idxFlyOver = -1;

        public ItemPane() {
            this.addKeyListener(this);
            this.addMouseListener(this);
            this.addMouseMotionListener(this);
        }

        public void keyPressed(KeyEvent keyEvent) {
            int n = keyEvent.getModifiers();
            if (n != 0) {
                return;
            }
            List.this.selMouse = false;
            switch (keyEvent.getKeyCode()) {
                case 40: {
                    int n2 = List.this.getSelectedIndex() + 1;
                    this.makeVisible(n2);
                    List.this.select(n2);
                    break;
                }
                case 38: {
                    int n3 = List.this.getSelectedIndex() - 1;
                    this.makeVisible(n3);
                    List.this.select(n3);
                    break;
                }
                case 10: {
                    List.this.notifyAction();
                    break;
                }
                case 33: {
                    this.makeVisible(this.first - this.getVisibleRows());
                    break;
                }
                case 34: {
                    this.makeVisible(this.first + 2 * this.getVisibleRows() - 1);
                    break;
                }
                case 27: {
                    List.this.selections.removeAllElements();
                    this.repaint();
                    break;
                }
                default: {
                    return;
                }
            }
            keyEvent.consume();
        }

        public void keyReleased(KeyEvent keyEvent) {
        }

        public void keyTyped(KeyEvent keyEvent) {
            int n = keyEvent.getModifiers();
            if (n == 0 || n == 1) {
                this.letterNav(keyEvent.getKeyChar(), keyEvent.isShiftDown());
            }
        }

        void letterNav(char c, boolean bl) {
            int n = this.rows.size();
            if (!bl) {
                this.lnsBuf.setLength(0);
            }
            this.lnsBuf.append(c);
            for (int i = 0; i < n; ++i) {
                String string = (String)this.rows.elementAt(i);
                if (!string.regionMatches(true, 0, this.lnsBuf.toString(), 0, this.lnsBuf.length())) continue;
                List.this.select(i);
                return;
            }
        }

        public void mouseClicked(MouseEvent mouseEvent) {
            if (mouseEvent.getClickCount() == 1) {
                int n = this.getRowIdx(mouseEvent.getY());
                if (n > -1) {
                    List.this.selMouse = true;
                    List.this.select(n);
                }
            } else {
                List.this.notifyAction();
            }
        }

        public void mouseDragged(MouseEvent mouseEvent) {
        }

        public void mouseEntered(MouseEvent mouseEvent) {
        }

        public void mouseExited(MouseEvent mouseEvent) {
            this.updateFlyOver(-1);
        }

        public void mouseMoved(MouseEvent mouseEvent) {
            int n = this.getRowIdx(mouseEvent.getY());
            if (n != this.idxFlyOver) {
                this.updateFlyOver(n);
            }
        }

        public void mousePressed(MouseEvent mouseEvent) {
            if (AWTEvent.keyTgt != this) {
                List.this.ip.requestFocus();
            }
        }

        public void mouseReleased(MouseEvent mouseEvent) {
        }

        public void paint(Graphics graphics) {
            this.paintBorder(graphics);
            this.repaintRows(this.first, this.getVisibleRows());
        }

        void repaintItem(Graphics graphics, int n) {
            int n2 = 2;
            int n3 = this.xOffs + n2 + 2;
            int n4 = n2 + (n - this.first) * this.rowHeight;
            int n5 = n4 + this.rowHeight - (this.rowHeight - this.fm.getHeight()) / 2 - this.fm.getDescent();
            String string = (String)this.rows.elementAt(n);
            if (List.this.selections.contains(string)) {
                graphics.setColor(Defaults.ListSelBgClr);
                graphics.fill3DRect(n2, n4, this.width - 2 * n2, this.rowHeight, true);
                graphics.setColor(Defaults.ListSelTxtClr);
            } else if (n == this.idxFlyOver) {
                graphics.setColor(Defaults.ListFlyOverBgClr);
                graphics.fill3DRect(n2, n4, this.width - 2 * n2, this.rowHeight, !Defaults.ListFlyOverInset);
                graphics.setColor(Defaults.ListFlyOverTxtClr);
            } else {
                graphics.setColor(this.bgClr);
                graphics.fillRect(n2, n4, this.width - 2 * n2, this.rowHeight);
                graphics.setColor(this.fgClr);
            }
            graphics.drawString(string, n3, n5);
        }

        void repaintRow(Graphics graphics, int n) {
            this.repaintItem(graphics, n);
        }

        public void setFont(Font font) {
            this.fm = this.getFontMetrics(font);
            this.rowHeight = 3 * this.fm.getHeight() / 2;
            super.setFont(font);
        }

        void updateFlyOver(int n) {
            int n2 = this.idxFlyOver;
            this.idxFlyOver = n;
            if (n2 == n) {
                return;
            }
            Graphics graphics = this.getClippedGraphics();
            if (graphics != null) {
                if (n2 > -1 && n2 < this.rows.size()) {
                    this.repaintItem(graphics, n2);
                }
                if (n > -1) {
                    this.repaintItem(graphics, n);
                }
                graphics.dispose();
            }
        }

        void updateHScroll(String string) {
            int n = this.fm.stringWidth(string);
            if (this.hScroll != null && this.hScroll.getMaximum() < n) {
                this.hScroll.setMaximum(n);
            }
        }
    }
}

