/*
 * Decompiled with CFR 0.152.
 */
package java.io;

import java.io.IOException;
import java.io.Reader;

public class BufferedReader
extends Reader {
    private static final int DEFAULTBUFFERSIZE = 1024;
    private Reader rd;
    private char[] inbuf;
    private int pos;
    private int size;
    private boolean markset;

    public BufferedReader(Reader reader) {
        this(reader, 1024);
    }

    public BufferedReader(Reader reader, int n) {
        this.rd = reader;
        this.inbuf = new char[n];
        this.pos = 0;
        this.size = 0;
        this.markset = false;
    }

    public void close() throws IOException {
        this.rd.close();
    }

    public void mark(int n) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            try {
                char[] cArray = this.inbuf;
                if (n > this.inbuf.length) {
                    this.inbuf = new char[n];
                }
                System.arraycopy(cArray, this.pos, this.inbuf, 0, this.size);
                this.pos = 0;
                this.markset = true;
                Object var5_4 = null;
            }
            catch (Throwable throwable) {
                Object var5_5 = null;
                throw throwable;
            }
        }
    }

    public boolean markSupported() {
        return true;
    }

    protected void pushback() {
        ++this.size;
        --this.pos;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int read() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            try {
                if (this.pos < this.size) {
                    return this.inbuf[this.pos++];
                }
                if (this.refillBuffer() <= 0) return -1;
                return this.inbuf[this.pos++];
            }
            catch (Throwable throwable) {
                Object var4_8 = null;
                throw throwable;
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int read(char[] cArray, int n, int n2) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            try {
                int n3;
                do {
                    for (n3 = 0; n3 < this.size && n3 < n2; ++n3) {
                        cArray[n++] = this.inbuf[this.pos++];
                    }
                    this.size -= n3;
                    if ((n2 -= n3) == 0) {
                        return n3;
                    }
                    if (n3 <= 0 || this.size == this.inbuf.length) continue;
                    return n3;
                } while (this.refillBuffer() > 0);
                if (n3 > 0) return n3;
                return -1;
            }
            catch (Throwable throwable) {
                Object var8_14 = null;
                throw throwable;
            }
        }
    }

    public String readLine() throws IOException {
        int n = this.pos;
        int n2 = 32;
        String string = null;
        Object object = this.lock;
        synchronized (object) {
            String string2;
            try {
                while (true) {
                    if (this.pos < this.size && (n2 = this.inbuf[this.pos]) != 10 && n2 != 13) {
                        ++this.pos;
                        continue;
                    }
                    if (this.pos != this.size) break;
                    if (this.pos > n) {
                        string = string == null ? new String(this.inbuf, n, this.pos - n) : String.valueOf(string).concat(String.valueOf(new String(this.inbuf, n, this.pos - n)));
                    }
                    if (this.refillBuffer() <= 0) {
                        String string3 = string;
                        Object var7_7 = null;
                        return string3;
                    }
                    n = 0;
                }
                string = string == null ? new String(this.inbuf, n, this.pos - n) : String.valueOf(string).concat(String.valueOf(new String(this.inbuf, n, this.pos - n)));
                ++this.pos;
                if (n2 == 13 && this.read() != 10 && this.pos > 0) {
                    --this.pos;
                }
                string2 = string;
            }
            catch (Throwable throwable) {
                Object var7_9 = null;
                throw throwable;
            }
            Object var7_8 = null;
            return string2;
        }
    }

    public boolean ready() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            boolean bl;
            try {
                if (this.size > 0 || this.rd.ready()) {
                    boolean bl2 = true;
                    Object var4_4 = null;
                    return bl2;
                }
                bl = false;
            }
            catch (Throwable throwable) {
                Object var4_6 = null;
                throw throwable;
            }
            Object var4_5 = null;
            return bl;
        }
    }

    private int refillBuffer() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            int n;
            try {
                int n2 = this.rd.read(this.inbuf, 0, this.inbuf.length);
                this.pos = 0;
                this.markset = false;
                if (n2 > 0) {
                    this.size = n2;
                    int n3 = n2;
                    Object var5_5 = null;
                    return n3;
                }
                this.size = 0;
                n = -1;
            }
            catch (Throwable throwable) {
                Object var5_7 = null;
                throw throwable;
            }
            Object var5_6 = null;
            return n;
        }
    }

    public void reset() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            try {
                if (!this.markset) {
                    throw new IOException("invalid mark");
                }
                this.size += this.pos;
                this.pos = 0;
                Object var3_2 = null;
            }
            catch (Throwable throwable) {
                Object var3_3 = null;
                throw throwable;
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public long skip(long l) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            try {
                if (l < (long)this.size) {
                    this.size -= (int)l;
                    this.pos += (int)l;
                    return l;
                }
                long l2 = this.size;
                l -= l2;
                this.size = 0;
                this.pos = 0;
                while (true) {
                    this.markset = false;
                    long l3 = this.rd.read(this.inbuf, 0, this.inbuf.length);
                    if (l3 == -1L) {
                        return l2;
                    }
                    if (l3 > l) {
                        this.pos = (int)l;
                        this.size = (int)(l3 - l);
                        return l2 += l;
                    }
                    l2 += l3;
                    l -= l3;
                }
            }
            catch (Throwable throwable) {
                Object var11_8 = null;
                throw throwable;
            }
        }
    }
}

