/*
 * Decompiled with CFR 0.152.
 */
package java.io;

import java.io.Externalizable;
import java.io.IOException;
import java.io.NotActiveException;
import java.io.ObjectOutput;
import java.io.ObjectStreamClass;
import java.io.ObjectStreamConstants;
import java.io.OutputStream;
import java.io.StreamCorruptedException;
import java.util.Hashtable;

public class ObjectOutputStream
extends OutputStream
implements ObjectOutput,
ObjectStreamConstants {
    private Object currObject;
    private ObjectStreamClass currStreamClass;
    private OutputStream out;
    private byte[] outBuf = new byte[255];
    private int pos = 0;
    private Hashtable objectsDone = new Hashtable();
    private int nextKey = 0x7E0000;
    private boolean doBlocking = false;
    private boolean enableReplace = false;

    public ObjectOutputStream(OutputStream outputStream) throws IOException {
        this.out = outputStream;
        this.enableBuffering(false);
        this.writeStreamHeader();
        this.enableBuffering(true);
    }

    protected void annotateClass(Class clazz) throws IOException {
    }

    public void close() throws IOException {
        this.flush();
        this.out.close();
    }

    protected void drain() throws IOException {
        ObjectOutputStream objectOutputStream = this;
        synchronized (objectOutputStream) {
            try {
                if (this.pos > 0) {
                    if (this.doBlocking) {
                        this.out.write(119);
                        this.out.write(this.pos);
                    }
                    this.out.write(this.outBuf, 0, this.pos);
                    this.pos = 0;
                }
                Object var3_2 = null;
            }
            catch (Throwable throwable) {
                Object var3_3 = null;
                throw throwable;
            }
        }
    }

    protected final boolean enableReplaceObject(boolean bl) throws SecurityException {
        boolean bl2 = this.enableReplace;
        this.enableReplace = bl;
        return bl2;
    }

    public void flush() throws IOException {
        this.drain();
        this.out.flush();
    }

    protected Object replaceObject(Object object) throws IOException {
        return object;
    }

    public void reset() throws IOException {
        if (this.currObject != null) {
            throw new IOException("currently serializing object");
        }
        this.enableBuffering(false);
        this.objectsDone = new Hashtable();
        this.pos = 0;
        this.writeByte(121);
        this.enableBuffering(false);
    }

    public void write(byte[] byArray) throws IOException {
        this.write(byArray, 0, byArray.length);
    }

    public void write(byte[] byArray, int n, int n2) throws IOException {
        ObjectOutputStream objectOutputStream = this;
        synchronized (objectOutputStream) {
            try {
                for (int i = 0; i < n2; ++i) {
                    this.write(byArray[n + i]);
                }
                Object var7_6 = null;
            }
            catch (Throwable throwable) {
                Object var7_7 = null;
                throw throwable;
            }
        }
    }

    public void writeBoolean(boolean bl) throws IOException {
        if (bl) {
            this.write(1);
        } else {
            this.write(0);
        }
    }

    public void writeByte(int n) throws IOException {
        this.write(n);
    }

    public void writeBytes(String string) throws IOException {
        char[] cArray = string.toCharArray();
        int n = cArray.length;
        ObjectOutputStream objectOutputStream = this;
        synchronized (objectOutputStream) {
            try {
                for (int i = 0; i < n; ++i) {
                    this.write(cArray[i] & 0xFF);
                }
                Object var7_6 = null;
            }
            catch (Throwable throwable) {
                Object var7_7 = null;
                throw throwable;
            }
        }
    }

    public void writeChar(int n) throws IOException {
        ObjectOutputStream objectOutputStream = this;
        synchronized (objectOutputStream) {
            try {
                this.write(n >> 8 & 0xFF);
                this.write(n & 0xFF);
                Object var4_3 = null;
            }
            catch (Throwable throwable) {
                Object var4_4 = null;
                throw throwable;
            }
        }
    }

    public void writeChars(String string) throws IOException {
        char[] cArray = string.toCharArray();
        ObjectOutputStream objectOutputStream = this;
        synchronized (objectOutputStream) {
            try {
                for (int i = 0; i < cArray.length; ++i) {
                    this.write(cArray[i] >> 8 & 0xFF);
                    this.write(cArray[i] & 0xFF);
                }
                Object var6_5 = null;
            }
            catch (Throwable throwable) {
                Object var6_6 = null;
                throw throwable;
            }
        }
    }

    public void writeDouble(double d) throws IOException {
        long l = Double.doubleToLongBits(d);
        ObjectOutputStream objectOutputStream = this;
        synchronized (objectOutputStream) {
            try {
                this.write((int)(l >> 56) & 0xFF);
                this.write((int)(l >> 48) & 0xFF);
                this.write((int)(l >> 40) & 0xFF);
                this.write((int)(l >> 32) & 0xFF);
                this.write((int)(l >> 24) & 0xFF);
                this.write((int)(l >> 16) & 0xFF);
                this.write((int)(l >> 8) & 0xFF);
                this.write((int)l & 0xFF);
                Object var7_4 = null;
            }
            catch (Throwable throwable) {
                Object var7_5 = null;
                throw throwable;
            }
        }
    }

    public void writeFloat(float f) throws IOException {
        int n = Float.floatToIntBits(f);
        ObjectOutputStream objectOutputStream = this;
        synchronized (objectOutputStream) {
            try {
                this.write(n >> 24 & 0xFF);
                this.write(n >> 16 & 0xFF);
                this.write(n >> 8 & 0xFF);
                this.write(n & 0xFF);
                Object var5_4 = null;
            }
            catch (Throwable throwable) {
                Object var5_5 = null;
                throw throwable;
            }
        }
    }

    public void writeInt(int n) throws IOException {
        ObjectOutputStream objectOutputStream = this;
        synchronized (objectOutputStream) {
            try {
                this.write(n >> 24 & 0xFF);
                this.write(n >> 16 & 0xFF);
                this.write(n >> 8 & 0xFF);
                this.write(n & 0xFF);
                Object var4_3 = null;
            }
            catch (Throwable throwable) {
                Object var4_4 = null;
                throw throwable;
            }
        }
    }

    public void writeLong(long l) throws IOException {
        ObjectOutputStream objectOutputStream = this;
        synchronized (objectOutputStream) {
            try {
                this.write((int)(l >> 56) & 0xFF);
                this.write((int)(l >> 48) & 0xFF);
                this.write((int)(l >> 40) & 0xFF);
                this.write((int)(l >> 32) & 0xFF);
                this.write((int)(l >> 24) & 0xFF);
                this.write((int)(l >> 16) & 0xFF);
                this.write((int)(l >> 8) & 0xFF);
                this.write((int)l & 0xFF);
                Object var5_3 = null;
            }
            catch (Throwable throwable) {
                Object var5_4 = null;
                throw throwable;
            }
        }
    }

    public void writeShort(int n) throws IOException {
        ObjectOutputStream objectOutputStream = this;
        synchronized (objectOutputStream) {
            try {
                this.write(n >> 8 & 0xFF);
                this.write(n & 0xFF);
                Object var4_3 = null;
            }
            catch (Throwable throwable) {
                Object var4_4 = null;
                throw throwable;
            }
        }
    }

    public final void writeObject(Object object) throws IOException {
        ObjectOutputStream objectOutputStream = this;
        synchronized (objectOutputStream) {
            try {
                if (this.enableReplace) {
                    object = this.replaceObject(object);
                }
                this.drain();
                boolean bl = this.enableBuffering(false);
                if (object == null) {
                    this.writeByte(112);
                    this.enableBuffering(bl);
                    Object var10_4 = null;
                    return;
                }
                Object object2 = this.currObject;
                ObjectStreamClass objectStreamClass = this.currStreamClass;
                this.currObject = object;
                Class clazz = object.getClass();
                this.currStreamClass = ObjectStreamClass.lookup(clazz);
                if (this.currStreamClass != null) {
                    Integer n = (Integer)this.objectsDone.get(object);
                    if (n != null) {
                        this.writeByte(113);
                        this.writeInt(n);
                    } else {
                        if (object instanceof ObjectStreamClass) {
                            this.writeByte(114);
                        } else if (object instanceof String) {
                            this.writeByte(116);
                        } else if (clazz.isArray()) {
                            this.writeByte(117);
                            this.writeObject(this.currStreamClass);
                        } else {
                            this.writeByte(115);
                            this.writeObject(this.currStreamClass);
                        }
                        n = new Integer(++this.nextKey);
                        this.objectsDone.put(object, n);
                        switch (this.currStreamClass.method) {
                            case 4: {
                                try {
                                    ((Externalizable)object).writeExternal(this);
                                }
                                catch (ClassCastException classCastException) {}
                                break;
                            }
                            case 1: {
                                this.invokeObjectWriter(object, clazz);
                                break;
                            }
                            case 2: {
                                this.defaultWriteObject();
                                break;
                            }
                            case 8: {
                                this.writeUTF((String)object);
                                break;
                            }
                            default: {
                                throw new StreamCorruptedException("unknown method type");
                            }
                        }
                        this.annotateClass(this.currStreamClass.clazz);
                    }
                }
                this.currObject = object2;
                this.currStreamClass = objectStreamClass;
                this.enableBuffering(bl);
            }
            catch (Throwable throwable) {
                Object var10_6 = null;
                throw throwable;
            }
            Object var10_5 = null;
            {
            }
        }
    }

    public final void defaultWriteObject() throws IOException {
        ObjectOutputStream objectOutputStream = this;
        synchronized (objectOutputStream) {
            try {
                if (this.currObject == null) {
                    throw new NotActiveException();
                }
                if (this.currStreamClass.clazz.isArray()) {
                    this.writeArray(this.currStreamClass, this.currObject);
                } else {
                    this.writeDataFields(this.currStreamClass, this.currObject);
                }
                Object var3_2 = null;
            }
            catch (Throwable throwable) {
                Object var3_3 = null;
                throw throwable;
            }
        }
    }

    private void writeDataFields(ObjectStreamClass objectStreamClass, Object object) {
        if (objectStreamClass == null) {
            return;
        }
        this.writeDataFields(objectStreamClass.superclazzStream, object);
        this.outputClassFields(object, objectStreamClass.clazz, objectStreamClass.fieldRdWr);
    }

    private void writeArray(ObjectStreamClass objectStreamClass, Object object) throws IOException {
        block9: {
            Class clazz;
            block15: {
                block14: {
                    block13: {
                        block12: {
                            block11: {
                                block10: {
                                    block8: {
                                        clazz = objectStreamClass.clazz.getComponentType();
                                        if (clazz != Class.forName("java.lang.Object")) break block8;
                                        Object[] objectArray = (Object[])object;
                                        int n = objectArray.length;
                                        this.writeInt(n);
                                        for (int i = 0; i < n; ++i) {
                                            this.writeObject(objectArray[i]);
                                        }
                                        break block9;
                                    }
                                    if (clazz != Character.TYPE) break block10;
                                    char[] cArray = (char[])object;
                                    int n = cArray.length;
                                    this.writeInt(n);
                                    for (int i = 0; i < n; ++i) {
                                        this.writeChar(cArray[i]);
                                    }
                                    break block9;
                                }
                                if (clazz != Short.TYPE) break block11;
                                short[] sArray = (short[])object;
                                int n = sArray.length;
                                this.writeInt(n);
                                for (int i = 0; i < n; ++i) {
                                    this.writeShort(sArray[i]);
                                }
                                break block9;
                            }
                            if (clazz != Integer.TYPE) break block12;
                            int[] nArray = (int[])object;
                            int n = nArray.length;
                            this.writeInt(n);
                            for (int i = 0; i < n; ++i) {
                                this.writeInt(nArray[i]);
                            }
                            break block9;
                        }
                        if (clazz != Boolean.TYPE) break block13;
                        boolean[] blArray = (boolean[])object;
                        int n = blArray.length;
                        this.writeInt(n);
                        for (int i = 0; i < n; ++i) {
                            this.writeBoolean(blArray[i]);
                        }
                        break block9;
                    }
                    if (clazz != Long.TYPE) break block14;
                    long[] lArray = (long[])object;
                    int n = lArray.length;
                    this.writeInt(n);
                    for (int i = 0; i < n; ++i) {
                        this.writeLong(lArray[i]);
                    }
                    break block9;
                }
                if (clazz != Double.TYPE) break block15;
                double[] dArray = (double[])object;
                int n = dArray.length;
                this.writeInt(n);
                for (int i = 0; i < n; ++i) {
                    this.writeDouble(dArray[i]);
                }
                break block9;
            }
            if (clazz != Float.TYPE) break block9;
            float[] fArray = (float[])object;
            int n = fArray.length;
            this.writeInt(n);
            for (int i = 0; i < n; ++i) {
                this.writeFloat(fArray[i]);
            }
        }
    }

    protected void writeStreamHeader() throws IOException {
        ObjectOutputStream objectOutputStream = this;
        synchronized (objectOutputStream) {
            try {
                this.writeShort(-21267);
                this.writeShort(5);
                Object var3_2 = null;
            }
            catch (Throwable throwable) {
                Object var3_3 = null;
                throw throwable;
            }
        }
    }

    public void writeUTF(String string) throws IOException {
        String string2 = ObjectOutputStream.makeUTF(string);
        ObjectOutputStream objectOutputStream = this;
        synchronized (objectOutputStream) {
            try {
                this.writeShort(string2.length());
                this.writeBytes(string2);
                Object var5_4 = null;
            }
            catch (Throwable throwable) {
                Object var5_5 = null;
                throw throwable;
            }
        }
    }

    public void write(int n) throws IOException {
        ObjectOutputStream objectOutputStream = this;
        synchronized (objectOutputStream) {
            try {
                this.outBuf[this.pos] = (byte)n;
                ++this.pos;
                if (this.pos == this.outBuf.length) {
                    this.drain();
                }
                Object var4_3 = null;
            }
            catch (Throwable throwable) {
                Object var4_4 = null;
                throw throwable;
            }
        }
    }

    private static String makeUTF(String string) {
        char[] cArray = string.toCharArray();
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < cArray.length; ++i) {
            char c = cArray[i];
            if (c >= '\u0001' && c <= '\u007f') {
                stringBuffer.append(c);
                continue;
            }
            if ((c >= '\u0080' && c <= '\u07ff') | c == '\u0000') {
                stringBuffer.append((c & 0x7C0) >> 6 | 0xC0);
                stringBuffer.append(c & 0x3F | 0x80);
                continue;
            }
            stringBuffer.append((c & 0xF000) >> 12 | 0xE0);
            stringBuffer.append((c & 0xFC0) >> 6 | 0x80);
            stringBuffer.append(c & 0x3F | 0x80);
        }
        return stringBuffer.toString();
    }

    private boolean enableBuffering(boolean bl) throws IOException {
        if (bl != this.doBlocking) {
            this.drain();
            this.doBlocking = bl;
            return !bl;
        }
        return bl;
    }

    private native boolean invokeObjectWriter(Object var1, Class var2);

    private native void outputClassFields(Object var1, Class var2, int[] var3);
}

