/*
 * Decompiled with CFR 0.152.
 */
package java.io;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamField;
import java.io.Serializable;
import java.io.StreamCorruptedException;
import java.util.Hashtable;

public class ObjectStreamClass
implements Serializable {
    private static Hashtable streamClasses = new Hashtable();
    String name;
    Class clazz;
    ObjectStreamClass superclazzStream;
    int method;
    long serialVersionUID;
    ObjectStreamField[] fieldInfo;
    int[] fieldRdWr;

    public Class forClass() {
        return this.clazz;
    }

    public String getName() {
        return this.name;
    }

    public static ObjectStreamClass lookup(Class clazz) {
        int n;
        ObjectStreamClass objectStreamClass = (ObjectStreamClass)streamClasses.get(clazz);
        if (objectStreamClass != null) {
            return objectStreamClass;
        }
        if (clazz == Class.forName("java.lang.String")) {
            n = 8;
        } else if (Class.forName("java.io.Externalizable").isAssignableFrom(clazz)) {
            n = 4;
        } else if (Class.forName("java.io.Serializable").isAssignableFrom(clazz)) {
            n = ObjectStreamClass.hasWriteObject(clazz) ? 1 : 2;
        } else {
            return null;
        }
        objectStreamClass = new ObjectStreamClass();
        objectStreamClass.name = clazz.getName();
        objectStreamClass.clazz = clazz;
        objectStreamClass.method = n;
        objectStreamClass.superclazzStream = ObjectStreamClass.lookup(clazz.getSuperclass());
        if (!clazz.isArray()) {
            objectStreamClass.buildFieldsAndOffset();
        } else {
            objectStreamClass.fieldInfo = new ObjectStreamField[0];
            objectStreamClass.fieldRdWr = new int[0];
        }
        streamClasses.put(clazz, objectStreamClass);
        return objectStreamClass;
    }

    void buildFieldsAndOffset() {
        this.fieldInfo = this.getFields0(this.clazz);
        int n = this.fieldInfo.length;
        this.fieldRdWr = new int[n * 2];
        for (int i = 0; i < n; ++i) {
            this.fieldRdWr[i * 2] = this.fieldInfo[i].type;
            this.fieldRdWr[i * 2 + 1] = this.fieldInfo[i].offset;
        }
    }

    public String toString() {
        return String.valueOf(String.valueOf(this.getName()).concat(String.valueOf(": static final long serialVersionUID = "))).concat(String.valueOf(Long.toString(ObjectStreamClass.getSerialVersionUID(this.clazz))));
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.writeUTF(this.name);
        objectOutputStream.writeLong(this.serialVersionUID);
        objectOutputStream.writeByte(this.method);
        int n = this.fieldInfo.length;
        objectOutputStream.writeShort(n);
        for (int i = 0; i < n; ++i) {
            objectOutputStream.writeByte(this.fieldInfo[i].type);
            objectOutputStream.writeUTF(this.fieldInfo[i].name);
            if (this.fieldInfo[i].typeString == null) continue;
            objectOutputStream.writeObject(this.fieldInfo[i].typeString);
        }
        objectOutputStream.writeByte(120);
        objectOutputStream.writeObject(this.superclazzStream);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        this.name = objectInputStream.readUTF();
        this.serialVersionUID = objectInputStream.readLong();
        this.method = objectInputStream.readUnsignedByte();
        int n = objectInputStream.readShort();
        this.fieldInfo = new ObjectStreamField[n];
        for (int i = 0; i < n; ++i) {
            this.fieldInfo[i] = new ObjectStreamField();
            int n2 = objectInputStream.readUnsignedByte();
            this.fieldInfo[i].type = (char)n2;
            this.fieldInfo[i].name = objectInputStream.readUTF();
            if (n2 == 76 || n2 == 91) {
                try {
                    this.fieldInfo[i].typeString = (String)objectInputStream.readObject();
                }
                catch (ClassCastException classCastException) {
                    throw new StreamCorruptedException("expected string");
                }
            } else {
                this.fieldInfo[i].typeString = null;
            }
            this.fieldInfo[i].offset = 0;
        }
        objectInputStream.expectByte((byte)120, "missing endblockdata");
        try {
            this.superclazzStream = (ObjectStreamClass)objectInputStream.readObject();
        }
        catch (ClassCastException classCastException) {
            throw new StreamCorruptedException("expected class desc");
        }
    }

    private static native int getClassAccess(Class var0);

    private static native String[] getMethodSignatures(Class var0);

    private static native int getMethodAccess(Class var0, String var1);

    private static native String[] getFieldSignatures(Class var0);

    private static native int getFieldAccess(Class var0, String var1);

    private native ObjectStreamField[] getFields0(Class var1);

    public static native long getSerialVersionUID(Class var0);

    private static native boolean hasWriteObject(Class var0);
}

