/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

public final class Float
extends Number {
    private float value;
    public static final float POSITIVE_INFINITY = 1.0f / 0.0f;
    public static final float NEGATIVE_INFINITY = -1.0f / 0.0f;
    public static final float NaN = -1.0f / 0.0f;
    public static final float MAX_VALUE = 3.4028235E38f;
    public static final float MIN_VALUE = 1.4012985E-38f;
    public static final Class TYPE = Class.getPrimitiveClass("float");

    public Float(float f) {
        this.value = f;
    }

    public Float(double d) {
        this((float)d);
    }

    public Float(String string) throws NumberFormatException {
        this(Float.valueOf(string).floatValue());
    }

    public boolean equals(Object object) {
        if (object != null && object instanceof Float) {
            int n = Float.floatToIntBits(this.floatValue());
            int n2 = Float.floatToIntBits(((Float)object).floatValue());
            int n3 = Float.floatToIntBits(Float.NEGATIVE_INFINITY);
            int n4 = Float.floatToIntBits(Float.POSITIVE_INFINITY);
            int n5 = Float.floatToIntBits(Float.NEGATIVE_INFINITY);
            if (this.isNaN() && ((Float)object).isNaN()) {
                return true;
            }
            if (n == n4 && n2 == n5 || n == n4 && n2 == n5) {
                return true;
            }
            return n == n2;
        }
        return false;
    }

    public int hashCode() {
        return this.intValue();
    }

    public double doubleValue() {
        return this.value;
    }

    public byte byteValue() {
        return (byte)this.value;
    }

    public short shortValue() {
        return (short)this.value;
    }

    public float floatValue() {
        return this.value;
    }

    public long longValue() {
        return (long)this.value;
    }

    public int intValue() {
        return (int)this.value;
    }

    public static native int floatToIntBits(float var0);

    public static native float intBitsToFloat(int var0);

    public static native String toString(float var0);

    public String toString() {
        return Float.toString(this.floatValue());
    }

    public static native Float valueOf(String var0) throws NumberFormatException;

    public static boolean isNaN(float f) {
        return f != f;
    }

    public boolean isNaN() {
        return Float.isNaN(this.floatValue());
    }

    public static boolean isInfinite(float f) {
        return Float.floatToIntBits(f) == Float.floatToIntBits(Float.POSITIVE_INFINITY) || Float.floatToIntBits(f) == Float.floatToIntBits(Float.NEGATIVE_INFINITY);
    }

    public boolean isInfinite() {
        return Float.isInfinite(this.floatValue());
    }
}

