/*
 * Decompiled with CFR 0.152.
 */
package java.net;

import java.io.FileDescriptor;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.InetAddress;
import java.net.SocketException;

public class DatagramSocket {
    private int localPort;
    private FileDescriptor fd = new FileDescriptor();

    public DatagramSocket() throws SocketException {
        this(0);
    }

    public DatagramSocket(int n) throws SocketException {
        System.getSecurityManager().checkListen(n);
        this.datagramSocketCreate();
        this.localPort = n;
        this.datagramSocketBind(this.localPort);
    }

    public synchronized void close() {
        this.datagramSocketClose();
    }

    private native int datagramSocketBind(int var1);

    private native void datagramSocketClose();

    private native void datagramSocketCreate();

    private native int datagramSocketPeek(InetAddress var1);

    private native void datagramSocketReceive(DatagramPacket var1);

    private native void datagramSocketSend(DatagramPacket var1);

    protected synchronized void finalize() {
        this.close();
    }

    public int getLocalPort() {
        return this.localPort;
    }

    public synchronized void receive(DatagramPacket datagramPacket) throws IOException {
        System.getSecurityManager().checkConnect(datagramPacket.getAddress().getHostName(), datagramPacket.getPort());
        this.datagramSocketReceive(datagramPacket);
    }

    public void send(DatagramPacket datagramPacket) throws IOException {
        System.getSecurityManager().checkConnect(datagramPacket.getAddress().getHostName(), datagramPacket.getPort());
        this.datagramSocketSend(datagramPacket);
    }

    static {
        System.loadLibrary("net");
    }
}

