/*
 * Decompiled with CFR 0.152.
 */
package java.net;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.PlainSocketImpl;
import java.net.SocketImpl;
import java.net.SocketImplFactory;

public final class Socket {
    private static SocketImplFactory factory = null;
    SocketImpl impl = factory == null ? new PlainSocketImpl() : factory.createSocketImpl();

    Socket() {
    }

    public Socket(InetAddress inetAddress, int n) throws IOException {
        this(inetAddress, n, true);
    }

    public Socket(InetAddress inetAddress, int n, boolean bl) throws IOException {
        this();
        this.impl.create(bl);
        this.impl.connect(inetAddress, n);
    }

    public Socket(String string, int n) throws IOException {
        this(string, n, true);
    }

    public Socket(String string, int n, boolean bl) throws IOException {
        this(InetAddress.getByName(string), n, bl);
    }

    public synchronized void close() throws IOException {
        this.impl.close();
    }

    public InetAddress getInetAddress() {
        return this.impl.getInetAddress();
    }

    public InputStream getInputStream() throws IOException {
        return this.impl.getInputStream();
    }

    public int getLocalPort() {
        return this.impl.getLocalPort();
    }

    public OutputStream getOutputStream() throws IOException {
        return this.impl.getOutputStream();
    }

    public int getPort() {
        return this.impl.getPort();
    }

    public static synchronized void setSocketImplFactory(SocketImplFactory socketImplFactory) throws IOException {
        factory = socketImplFactory;
    }

    public String toString() {
        return this.impl.toString();
    }
}

