/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import java.util.ObservableClient;
import java.util.Observer;

public class Observable {
    Observer client;
    boolean hasChanged;

    public synchronized void addObserver(Observer observer) {
        if (this.client == null) {
            this.client = observer;
        } else {
            if (this.client == observer) {
                return;
            }
            if (this.client instanceof ObservableClient) {
                ObservableClient observableClient = (ObservableClient)this.client;
                while (observableClient.next != null) {
                    observableClient = observableClient.next;
                }
                observableClient.next = new ObservableClient(observer);
            } else {
                ObservableClient observableClient = new ObservableClient(this.client);
                observableClient.next = new ObservableClient(observer);
                this.client = observableClient;
            }
        }
    }

    protected void clearChanged() {
        this.hasChanged = false;
    }

    public synchronized int countObservers() {
        if (this.client == null) {
            return 0;
        }
        if (this.client instanceof ObservableClient) {
            ObservableClient observableClient = (ObservableClient)this.client;
            int n = 1;
            while (observableClient.next != null) {
                observableClient = observableClient.next;
                ++n;
            }
            return n;
        }
        return 1;
    }

    public synchronized void deleteObserver(Observer observer) {
        if (this.client != null) {
            if (this.client instanceof ObservableClient) {
                ObservableClient observableClient = (ObservableClient)this.client;
                if (observableClient.client == observer && observableClient.next == null) {
                    this.client = null;
                } else {
                    while (observableClient.next != null) {
                        if (observableClient.next.client == observer) {
                            observableClient.next = observableClient.next.next;
                            break;
                        }
                        observableClient = observableClient.next;
                    }
                }
            } else if (this.client == observer) {
                this.client = null;
            }
        }
    }

    public synchronized void deleteObservers() {
        this.client = null;
    }

    public boolean hasChanged() {
        return this.hasChanged;
    }

    public void notifyObservers() {
        this.notifyObservers(null);
    }

    public synchronized void notifyObservers(Object object) {
        if (this.hasChanged && this.client != null) {
            this.client.update(this, object);
            this.hasChanged = false;
        }
    }

    protected void setChanged() {
        this.hasChanged = true;
    }
}

