/*
 * Decompiled with CFR 0.152.
 */
package kaffe.awt;

import java.applet.Applet;
import java.applet.AppletContext;
import java.applet.AppletStub;
import java.applet.AudioClip;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Label;
import java.awt.Menu;
import java.awt.MenuBar;
import java.awt.Panel;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.StreamTokenizer;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class AppletViewer
extends Frame
implements AppletStub,
AppletContext,
ActionListener {
    Applet app;
    Vector apps = new Vector();
    URL base;
    String codebase;
    String code;
    Hashtable paramDict = new Hashtable();
    Panel client = new Panel();
    Label state = new Label();

    public AppletViewer(File file) {
        super(String.valueOf("AppletViewer: ").concat(String.valueOf(file)));
        this.setLayout(null);
        this.setMenus();
        this.add(this.state);
        Dimension dimension = new Dimension(200, 200);
        try {
            int n;
            FileReader fileReader = new FileReader(file);
            StreamTokenizer streamTokenizer = new StreamTokenizer(fileReader);
            streamTokenizer.lowerCaseMode(true);
            while ((n = streamTokenizer.nextToken()) != -1) {
                if (n != 60 || (n = streamTokenizer.nextToken()) != -3) continue;
                if (streamTokenizer.sval.equals("applet")) {
                    this.parseApplet(streamTokenizer, dimension);
                    continue;
                }
                if (!streamTokenizer.sval.equals("param")) continue;
                this.parseParam(streamTokenizer);
            }
            fileReader.close();
            Class clazz = Class.forName(this.code);
            this.app = (Applet)clazz.newInstance();
            this.app.setStub(this);
            this.apps.addElement(this.app);
            this.add(this.app);
            this.showStatus("applet started");
        }
        catch (Exception exception) {
            exception.printStackTrace();
            this.showStatus("cannot start applet");
            exception.printStackTrace();
        }
        this.getFrameDim(dimension);
        this.setBounds(0, 0, dimension.width, dimension.height);
        this.init();
        this.setVisible(true);
    }

    public void doLayout() {
        Insets insets = this.getInsets();
        Dimension dimension = this.getSize();
        int n = this.getStateHeight();
        if (this.app != null) {
            this.app.setBounds(insets.left, insets.top, dimension.width - insets.left - insets.right, dimension.height - insets.top - insets.bottom - n);
        }
        this.state.setBounds(insets.left, dimension.height - insets.bottom - n, dimension.width - insets.left - insets.right, n);
        super.doLayout();
    }

    int getStateHeight() {
        return 2 * this.state.getFontMetrics(this.state.getFont()).getHeight();
    }

    void getFrameDim(Dimension dimension) {
        Insets insets = this.getInsets();
        dimension.width += insets.left + insets.right;
        dimension.height += insets.top + insets.bottom + this.getStateHeight();
    }

    void parseApplet(StreamTokenizer streamTokenizer, Dimension dimension) throws IOException {
        while (streamTokenizer.nextToken() != 62) {
            if (streamTokenizer.sval.equals("codebase")) {
                streamTokenizer.lowerCaseMode(false);
                streamTokenizer.nextToken();
                streamTokenizer.nextToken();
                this.codebase = new String(streamTokenizer.sval);
                streamTokenizer.lowerCaseMode(true);
                continue;
            }
            if (streamTokenizer.sval.equals("code")) {
                streamTokenizer.lowerCaseMode(false);
                streamTokenizer.nextToken();
                streamTokenizer.nextToken();
                this.code = new String(streamTokenizer.sval);
                if (this.code.endsWith(".class")) {
                    this.code = this.code.substring(0, this.code.length() - 6);
                }
                streamTokenizer.lowerCaseMode(true);
                continue;
            }
            if (streamTokenizer.sval.equals("height")) {
                streamTokenizer.nextToken();
                streamTokenizer.nextToken();
                dimension.height = (int)streamTokenizer.nval;
                continue;
            }
            if (!streamTokenizer.sval.equals("width")) continue;
            streamTokenizer.nextToken();
            streamTokenizer.nextToken();
            dimension.width = (int)streamTokenizer.nval;
        }
    }

    void parseParam(StreamTokenizer streamTokenizer) throws IOException {
        String string = null;
        String string2 = null;
        while (streamTokenizer.nextToken() != 62) {
            if (streamTokenizer.sval.equals("name")) {
                streamTokenizer.nextToken();
                streamTokenizer.nextToken();
                string = new String(streamTokenizer.sval);
                continue;
            }
            if (!streamTokenizer.sval.equals("value")) continue;
            streamTokenizer.nextToken();
            streamTokenizer.lowerCaseMode(false);
            streamTokenizer.nextToken();
            string2 = streamTokenizer.ttype == -2 ? Double.toString(streamTokenizer.nval) : new String(streamTokenizer.sval);
            streamTokenizer.lowerCaseMode(true);
        }
        if (string != null && string2 != null) {
            this.paramDict.put(string, string2);
        }
    }

    public void appletResize(int n, int n2) {
        Dimension dimension = new Dimension(n, n2);
        this.getFrameDim(dimension);
        this.setSize(dimension);
    }

    public Applet getApplet(String string) {
        return this.app;
    }

    public AppletContext getAppletContext() {
        return this;
    }

    public Enumeration getApplets() {
        return this.apps.elements();
    }

    public AudioClip getAudioClip(URL uRL) {
        return null;
    }

    public URL getCodeBase() {
        return this.base;
    }

    public URL getDocumentBase() {
        return this.base;
    }

    public Image getImage(URL uRL) {
        return Toolkit.getDefaultToolkit().getImage(uRL);
    }

    public String getParameter(String string) {
        String string2 = string.toLowerCase();
        String string3 = (String)this.paramDict.get(string2);
        return string3;
    }

    void init() {
        try {
            if (this.codebase == null || this.codebase.equals(".")) {
                String string = System.getProperty("user.dir");
                this.base = new URL("file", "localhost", String.valueOf(string).concat(String.valueOf(File.separator)));
            } else {
                this.base = new URL(this.codebase);
            }
        }
        catch (MalformedURLException malformedURLException) {
            this.showStatus(String.valueOf("invalid codebase: ").concat(String.valueOf(this.codebase)));
        }
        try {
            this.app.init();
            this.app.start();
        }
        catch (NullPointerException nullPointerException) {
            this.showStatus("invalid code");
        }
    }

    public boolean isActive() {
        return true;
    }

    public static void main(String[] stringArray) {
        if (stringArray.length == 0) {
            System.out.println("usage: AppletViewer <html file>");
        } else {
            File file = new File(stringArray[0]);
            if (file.exists()) {
                new AppletViewer(file);
            } else {
                System.out.println(String.valueOf(String.valueOf("file ").concat(String.valueOf(file))).concat(String.valueOf(" does not exist")));
            }
        }
    }

    void setMenus() {
        MenuBar menuBar = new MenuBar();
        Menu menu = new Menu("Applet");
        menu.add("Restart");
        menu.add("Reload");
        menu.add("Stop");
        menu.add("Save...");
        menu.add("Start");
        menu.add("Clone...");
        menu.addSeparator();
        menu.add("Tag...");
        menu.add("Info...");
        menu.add("Edit");
        menu.add("Character Encoding");
        menu.addSeparator();
        menu.add("Print...");
        menu.addSeparator();
        menu.add("Properties...");
        menu.addSeparator();
        menu.add("Close");
        menu.add("Quit");
        menu.addActionListener(this);
        menuBar.add(menu);
        this.setMenuBar(menuBar);
    }

    public void showDocument(URL uRL) {
    }

    public void showDocument(URL uRL, String string) {
    }

    public void showStatus(String string) {
        this.state.setText(String.valueOf(String.valueOf(" ").concat(String.valueOf(string))).concat(String.valueOf(" ")));
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if ("Quit".equals(string)) {
            System.exit(0);
        } else if ("Stop".equals(string)) {
            this.app.stop();
            this.showStatus("applet stopped");
        } else if ("Start".equals(string)) {
            this.app.start();
            this.showStatus("applet started");
        }
    }
}

