/*
 * Decompiled with CFR 0.152.
 */
package kaffe.awt;

import java.awt.Image;
import java.awt.Toolkit;
import java.awt.image.ImageObserver;
import java.io.File;
import java.net.URL;

public class ImageSpec {
    Image img;
    boolean plain;
    String fileName;
    Class loaderCls;

    public ImageSpec(String string, Class clazz, ImageObserver imageObserver, boolean bl, boolean bl2) {
        this.loaderCls = clazz;
        this.fileName = string;
        this.plain = bl2;
        if (bl) {
            this.loadImage(imageObserver);
        }
    }

    public Image getImage() {
        if (this.img == null) {
            this.loadImage(null);
        }
        return this.img;
    }

    public boolean isPlain() {
        return this.plain;
    }

    boolean loadImage(ImageObserver imageObserver) {
        if (this.img == null) {
            Toolkit toolkit = Toolkit.getDefaultToolkit();
            File file = new File(this.fileName);
            if (file.exists()) {
                this.img = toolkit.getImage(this.fileName);
                return true;
            }
            try {
                URL uRL = this.loaderCls.getResource(this.fileName);
                this.img = toolkit.getImage(uRL);
                if (imageObserver != null) {
                    this.img.getWidth(imageObserver);
                }
                return true;
            }
            catch (Exception exception) {
                return false;
            }
        }
        return true;
    }
}

