/*
 * Decompiled with CFR 0.152.
 */
package kaffe.util;

import kaffe.util.TimerClient;
import kaffe.util.TimerClientEntry;

public class Timer
extends Thread {
    TimerClientEntry[] clients;
    int nClients;
    int resolution;
    boolean stop;
    static Timer defaultTimer;

    public Timer(int n) {
        this.resolution = n;
        this.clients = new TimerClientEntry[5];
        for (int i = 0; i < this.clients.length; ++i) {
            this.clients[i] = new TimerClientEntry();
        }
        this.start();
    }

    public synchronized void addClient(TimerClient timerClient, int n, int n2) {
        if (this.nClients == this.clients.length) {
            TimerClientEntry[] timerClientEntryArray = new TimerClientEntry[this.clients.length + 10];
            System.arraycopy(this.clients, 0, timerClientEntryArray, 0, this.nClients);
            this.clients = timerClientEntryArray;
            for (int i = this.nClients; i < this.clients.length; ++i) {
                this.clients[i] = new TimerClientEntry();
            }
        }
        TimerClientEntry timerClientEntry = this.clients[this.nClients++];
        timerClientEntry.client = timerClient;
        timerClientEntry.nextNotify = System.currentTimeMillis() + (long)n;
        timerClientEntry.interval = n2;
        if (this.nClients == 1) {
            this.notify();
        }
    }

    public static Timer getDefaultTimer() {
        if (defaultTimer == null) {
            defaultTimer = new Timer(100);
        }
        return defaultTimer;
    }

    public synchronized void removeClient(TimerClient timerClient) {
        for (int i = 0; i < this.nClients; ++i) {
            TimerClientEntry timerClientEntry = this.clients[i];
            if (timerClientEntry.client != timerClient) continue;
            int n = i + 1;
            if (n < this.nClients--) {
                System.arraycopy(this.clients, n, this.clients, i, this.nClients - i);
                this.clients[this.nClients] = timerClientEntry;
            }
            timerClientEntry.client = null;
            return;
        }
    }

    public void run() {
        while (!this.stop) {
            try {
                while (!this.stop) {
                    Timer timer = this;
                    synchronized (timer) {
                        Object var7_6;
                        try {
                            if (this.nClients == 0) {
                                this.wait();
                            }
                            long l = System.currentTimeMillis();
                            for (int i = 0; i < this.nClients; ++i) {
                                TimerClientEntry timerClientEntry = this.clients[i];
                                if (l <= timerClientEntry.nextNotify) continue;
                                timerClientEntry.client.timerExpired(this);
                                timerClientEntry.nextNotify = l + (long)timerClientEntry.interval;
                            }
                            var7_6 = null;
                        }
                        catch (Throwable throwable) {
                            var7_6 = null;
                            throw throwable;
                        }
                    }
                    Thread.sleep(this.resolution);
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    public void startNotify() {
        this.stop = false;
        this.start();
    }

    public void stopNotify() {
        this.stop = true;
    }
}

