/*
 * Decompiled with CFR 0.152.
 */
package java.beans;

import java.beans.BeanDescriptor;
import java.beans.BeanInfo;
import java.beans.EventSetDescriptor;
import java.beans.GenericBeanInfo;
import java.beans.IndexedPropertyDescriptor;
import java.beans.IntrospectionException;
import java.beans.MethodDescriptor;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.TooManyListenersException;

public class Introspector {
    private static String[] beansearch = new String[]{"kaffe.beans.infos"};

    public static String decapitalize(String string) {
        if (string.length() > 2 && Character.isUpperCase(string.charAt(0)) && Character.isUpperCase(string.charAt(1))) {
            return string;
        }
        return String.valueOf(Character.toLowerCase(string.charAt(0))).concat(String.valueOf(string.substring(1)));
    }

    public static BeanInfo getBeanInfo(Class clazz) throws IntrospectionException {
        return Introspector.getBeanInfo(clazz, null);
    }

    public static BeanInfo getBeanInfo(Class clazz, Class clazz2) throws IntrospectionException {
        BeanInfo beanInfo = Introspector.loadBeanInfo(clazz);
        if (beanInfo != null) {
            return beanInfo;
        }
        if (clazz2 != null) {
            clazz2 = clazz2.getSuperclass();
        }
        if (clazz2 != null && !clazz.isInstance(clazz2)) {
            throw new IntrospectionException("Illegal stop class");
        }
        GenericBeanInfo genericBeanInfo = new GenericBeanInfo(new BeanDescriptor(clazz), Introspector.getProperties(clazz, clazz2), Introspector.getMethods(clazz, clazz2), Introspector.getListeners(clazz, clazz2));
        return genericBeanInfo;
    }

    public static String[] getBeanInfoSearchPath() {
        return beansearch;
    }

    private static EventSetDescriptor[] getListeners(Class clazz, Class clazz2) throws IntrospectionException {
        Object[] objectArray;
        Hashtable hashtable = new Hashtable();
        Hashtable hashtable2 = new Hashtable();
        Hashtable hashtable3 = new Hashtable();
        for (Class clazz3 = clazz; clazz3 != clazz2; clazz3 = clazz3.getSuperclass()) {
            objectArray = clazz3.getDeclaredMethods();
            for (int i = 0; i < objectArray.length; ++i) {
                if (!Modifier.isPublic(((Method)objectArray[i]).getModifiers()) || Modifier.isStatic(((Method)objectArray[i]).getModifiers())) continue;
                String string = ((Method)objectArray[i]).getName();
                if (string.startsWith("add") && string.endsWith("Listener")) {
                    string = string.substring(3, string.length() - 8);
                    hashtable3.put(string, string);
                    if (hashtable.get(string) != null) continue;
                    hashtable.put(string, objectArray[i]);
                    continue;
                }
                if (!string.startsWith("remove") || !string.endsWith("Listener")) continue;
                string = string.substring(6, string.length() - 8);
                hashtable3.put(string, string);
                if (hashtable2.get(string) != null) continue;
                hashtable2.put(string, objectArray[i]);
            }
        }
        objectArray = new EventSetDescriptor[hashtable3.size()];
        Enumeration enumeration = hashtable3.elements();
        block5: for (int i = 0; i < objectArray.length; ++i) {
            String string = (String)enumeration.nextElement();
            Method method = (Method)hashtable.get(string);
            Method method2 = (Method)hashtable2.get(string);
            if (method == null || method2 == null) continue;
            objectArray[i] = new EventSetDescriptor(Introspector.decapitalize(string), null, null, method, method2);
            Class[] classArray = method.getExceptionTypes();
            if (classArray == null) continue;
            for (int j = 0; j < classArray.length; ++j) {
                try {
                    if (!(classArray[j].newInstance() instanceof TooManyListenersException)) continue;
                    ((EventSetDescriptor)objectArray[i]).setUnicast(true);
                    continue block5;
                }
                catch (IllegalAccessException illegalAccessException) {
                    continue;
                }
                catch (InstantiationException instantiationException) {
                    // empty catch block
                }
            }
        }
        return objectArray;
    }

    private static MethodDescriptor[] getMethods(Class clazz, Class clazz2) throws IntrospectionException {
        Object[] objectArray;
        Hashtable hashtable = new Hashtable();
        for (Class clazz3 = clazz; clazz3 != clazz2; clazz3 = clazz3.getSuperclass()) {
            objectArray = clazz3.getDeclaredMethods();
            for (int i = 0; i < objectArray.length; ++i) {
                String string;
                if (!Modifier.isPublic(((Method)objectArray[i]).getModifiers()) || hashtable.get(string = ((Method)objectArray[i]).toString()) != null) continue;
                hashtable.put(string, objectArray[i]);
            }
        }
        objectArray = new MethodDescriptor[hashtable.size()];
        Enumeration enumeration = hashtable.elements();
        for (int i = 0; i < objectArray.length; ++i) {
            objectArray[i] = new MethodDescriptor((Method)enumeration.nextElement());
        }
        return objectArray;
    }

    private static PropertyDescriptor[] getProperties(Class clazz, Class clazz2) throws IntrospectionException {
        Class[] classArray;
        Object object;
        Object[] objectArray;
        Hashtable hashtable = new Hashtable();
        Hashtable hashtable2 = new Hashtable();
        Hashtable hashtable3 = new Hashtable();
        Hashtable hashtable4 = new Hashtable();
        Hashtable hashtable5 = new Hashtable();
        for (Class clazz3 = clazz; clazz3 != clazz2; clazz3 = clazz3.getSuperclass()) {
            objectArray = clazz3.getDeclaredMethods();
            block6: for (int i = 0; i < objectArray.length; ++i) {
                Object object2 = objectArray[i];
                int n = ((Method)object2).getModifiers();
                if (!Modifier.isPublic(n) || Modifier.isStatic(n)) continue;
                object = ((Method)object2).getName();
                classArray = ((Method)object2).getParameterTypes();
                switch (classArray.length) {
                    case 0: {
                        if (((String)object).startsWith("get")) {
                            object = ((String)object).substring(3);
                            hashtable5.put(object, object);
                            if (hashtable2.get(object) != null) continue block6;
                            hashtable2.put(object, object2);
                            continue block6;
                        }
                        if (!((String)object).startsWith("is")) continue block6;
                        object = ((String)object).substring(2);
                        hashtable5.put(object, object);
                        if (hashtable2.get(object) != null) continue block6;
                        hashtable2.put(object, object2);
                        continue block6;
                    }
                    case 1: {
                        if (((String)object).startsWith("set")) {
                            object = ((String)object).substring(3);
                            hashtable5.put(object, object);
                            if (hashtable.get(object) != null) continue block6;
                            hashtable.put(object, object2);
                            continue block6;
                        }
                        if (!((String)object).startsWith("get") || classArray[0] != Integer.TYPE) continue block6;
                        object = ((String)object).substring(3);
                        hashtable5.put(object, object);
                        if (hashtable4.get(object) != null) continue block6;
                        hashtable4.put(object, object2);
                        continue block6;
                    }
                    case 2: {
                        if (!((String)object).startsWith("set") || classArray[0] != Integer.TYPE) continue block6;
                        object = ((String)object).substring(3);
                        hashtable5.put(object, object);
                        if (hashtable3.get(object) != null) continue block6;
                        hashtable3.put(object, object2);
                    }
                }
            }
        }
        objectArray = new PropertyDescriptor[hashtable5.size()];
        Enumeration enumeration = hashtable5.elements();
        for (int i = 0; i < objectArray.length; ++i) {
            String string = (String)enumeration.nextElement();
            object = (Method)hashtable.get(string);
            classArray = (Class[])hashtable2.get(string);
            Method method = (Method)hashtable3.get(string);
            Method method2 = (Method)hashtable4.get(string);
            objectArray[i] = method == null && method2 == null ? new PropertyDescriptor(Introspector.decapitalize(string), (Method)classArray, (Method)object) : new IndexedPropertyDescriptor(Introspector.decapitalize(string), (Method)classArray, (Method)object, method2, method);
        }
        return objectArray;
    }

    private static BeanInfo loadBeanInfo(Class clazz) {
        String string = clazz.getName();
        BeanInfo beanInfo = Introspector.loadNamedBean(String.valueOf(string).concat(String.valueOf("BeanInfo")));
        if (beanInfo != null) {
            return beanInfo;
        }
        int n = string.lastIndexOf(46);
        int n2 = string.lastIndexOf(47);
        if (n2 > n) {
            n = n2;
        }
        string = string.substring(n + 1);
        for (int i = 0; i < beansearch.length; ++i) {
            beanInfo = Introspector.loadNamedBean(String.valueOf(String.valueOf(String.valueOf(beansearch[i]).concat(String.valueOf("."))).concat(String.valueOf(string))).concat(String.valueOf("BeanInfo")));
            if (beanInfo == null) continue;
            return beanInfo;
        }
        return null;
    }

    private static BeanInfo loadNamedBean(String string) {
        try {
            return (BeanInfo)Class.forName(string).newInstance();
        }
        catch (ClassNotFoundException classNotFoundException) {
        }
        catch (ClassCastException classCastException) {
        }
        catch (IllegalAccessException illegalAccessException) {
        }
        catch (InstantiationException instantiationException) {
            // empty catch block
        }
        return null;
    }

    public static void setBeanInfoSearchPath(String[] stringArray) {
        beansearch = stringArray;
    }
}

