/*
 * Decompiled with CFR 0.152.
 */
package java.io;

import java.io.FilenameFilter;
import java.io.IOException;
import java.util.Vector;

public class File {
    public static final String separator = System.getProperty("file.separator");
    public static final char separatorChar = separator.charAt(0);
    public static final String pathSeparator = System.getProperty("path.separator");
    public static final char pathSeparatorChar = pathSeparator.charAt(0);
    private String path;

    public File(File file, String string) {
        this.path = file == null ? string : String.valueOf(String.valueOf(file.getPath()).concat(String.valueOf(separatorChar))).concat(String.valueOf(string));
    }

    public File(String string) {
        this.path = string;
    }

    public File(String string, String string2) {
        if (string == null) {
            string = ".";
        }
        this.path = String.valueOf(String.valueOf(string).concat(String.valueOf(separatorChar))).concat(String.valueOf(string2));
    }

    public boolean canRead() {
        this.checkReadAccess();
        return this.exists() && this.canRead0();
    }

    private native boolean canRead0();

    public boolean canWrite() {
        this.checkWriteAccess();
        return this.canWrite0();
    }

    private native boolean canWrite0();

    private native String canonPath(String var1) throws IOException;

    private void checkReadAccess() {
        System.getSecurityManager().checkRead(this.getPath());
    }

    private void checkWriteAccess() {
        System.getSecurityManager().checkWrite(this.getPath());
    }

    public boolean delete() {
        System.getSecurityManager().checkDelete(this.getPath());
        return this.delete0();
    }

    private native boolean delete0();

    public boolean equals(Object object) {
        if (object != null && object instanceof File) {
            return ((File)object).getPath().equals(this.getPath());
        }
        return false;
    }

    public boolean exists() {
        this.checkReadAccess();
        return this.exists0();
    }

    private native boolean exists0();

    public String getAbsolutePath() {
        if (this.isAbsolute()) {
            return this.getPath();
        }
        return String.valueOf(String.valueOf(System.getProperty("user.dir")).concat(String.valueOf(separatorChar))).concat(String.valueOf(this.getPath()));
    }

    public String getCanonicalPath() throws IOException {
        return this.canonPath(this.path);
    }

    public String getName() {
        return this.path.substring(this.path.lastIndexOf(separatorChar) + 1);
    }

    public String getParent() {
        int n = this.path.lastIndexOf(separatorChar);
        if (n > 0) {
            return this.path.substring(0, n);
        }
        if (n == 0 && this.path.length() > 1) {
            return separator;
        }
        return null;
    }

    public String getPath() {
        return this.path;
    }

    public int hashCode() {
        return this.path.hashCode();
    }

    public native boolean isAbsolute();

    public boolean isDirectory() {
        this.checkReadAccess();
        return this.isDirectory0();
    }

    private native boolean isDirectory0();

    public boolean isFile() {
        this.checkReadAccess();
        return this.isFile0();
    }

    private native boolean isFile0();

    public long lastModified() {
        this.checkReadAccess();
        return this.lastModified0();
    }

    private native long lastModified0();

    public long length() {
        this.checkReadAccess();
        return this.length0();
    }

    private native long length0();

    public String[] list() {
        this.checkReadAccess();
        return this.list0();
    }

    public String[] list(FilenameFilter filenameFilter) {
        String[] stringArray;
        Vector vector = new Vector();
        String[] stringArray2 = this.list();
        for (int i = 0; i < stringArray2.length; ++i) {
            stringArray = stringArray2[i];
            if (filenameFilter == null || !filenameFilter.accept(this, (String)stringArray)) continue;
            vector.addElement(stringArray);
        }
        stringArray = new String[vector.size()];
        vector.copyInto(stringArray);
        return stringArray;
    }

    private native String[] list0();

    public boolean mkdir() {
        this.checkWriteAccess();
        if (this.isDirectory()) {
            return true;
        }
        return this.mkdir0();
    }

    private native boolean mkdir0();

    public boolean mkdirs() {
        File file;
        if (!this.toString().equals(separator) && !(file = new File(this.getParent())).mkdirs()) {
            return false;
        }
        return this.mkdir();
    }

    public boolean renameTo(File file) {
        System.getSecurityManager().checkWrite(this.getPath());
        System.getSecurityManager().checkWrite(file.getPath());
        return this.renameTo0(file);
    }

    private native boolean renameTo0(File var1);

    public String toString() {
        return this.path;
    }
}

