/*
 * Decompiled with CFR 0.152.
 */
package java.io;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;

public class LineNumberInputStream
extends FilterInputStream {
    private int lineNo = 0;
    private int markLineNo;
    private boolean pushedBack = false;
    private int pushBack;

    public LineNumberInputStream(InputStream inputStream) {
        super(inputStream);
    }

    public int available() throws IOException {
        int n = super.available();
        if (this.pushedBack) {
            ++n;
        }
        return n;
    }

    public int getLineNumber() {
        return this.lineNo;
    }

    public void mark(int n) {
        this.markLineNo = this.lineNo;
        super.mark(n);
    }

    private void pushBack(int n) {
        this.pushBack = n;
        this.pushedBack = true;
    }

    private int pushBackRead() throws IOException {
        if (this.pushedBack) {
            this.pushedBack = false;
            return this.pushBack;
        }
        return super.read();
    }

    public int read() throws IOException {
        int n = this.pushBackRead();
        if (n == 10 || n == 13) {
            ++this.lineNo;
        }
        if (n == 13) {
            int n2 = this.pushBackRead();
            if (n2 == 10) {
                n = n2;
            } else {
                this.pushBack(n2);
            }
        }
        return n;
    }

    public int read(byte[] byArray, int n, int n2) throws IOException {
        for (int i = n; i < n + n2; ++i) {
            int n3 = this.read();
            if (n3 == -1) {
                if (i - n == 0) {
                    return -1;
                }
                return i - n;
            }
            byArray[i] = (byte)n3;
        }
        return n2;
    }

    public void reset() throws IOException {
        this.lineNo = this.markLineNo;
        super.reset();
    }

    public void setLineNumber(int n) {
        this.lineNo = n;
    }

    public long skip(long l) throws IOException {
        byte[] byArray = new byte[(int)l];
        return this.read(byArray, 0, byArray.length);
    }
}

